/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.auth;

import com.tridium.cloudLink.BCloudConnectionService;
import com.tridium.cloudLink.CloudLinkUtils;
import com.tridium.cloudLink.auth.BAbstractClientAuthenticator;
import com.tridium.cloudLink.auth.BClientAuthenticatorsFolder;
import com.tridium.cloudLink.auth.BKeyStoreType;
import com.tridium.cloudLink.auth.EcdsaKeyPairGeneratorSupplier;
import com.tridium.cloudLink.auth.HsmSignatureKeyStoreHelper;
import com.tridium.cloudLink.auth.IKeyStoreHelper;
import com.tridium.cloudLink.auth.SignatureKeyStoreHelper;
import com.tridium.cloudLink.auth.SignatureSupplier;
import com.tridium.cloudLink.auth.SystemAuthenticationException;
import com.tridium.cloudLink.channel.BMessagingChannel;
import com.tridium.cloudLink.forge.auth.BAbstractForgeAuthenticator;
import com.tridium.cloudLink.forge.auth.BFederatedIdentityAuthenticator;
import com.tridium.cloudLink.forge.auth.BSystemAuthenticationState;
import com.tridium.cloudLink.forge.auth.BSystemRegistrationState;
import com.tridium.cloudLink.forge.auth.ForgeRegistrationRequest;
import com.tridium.cloudLink.forge.auth.ForgeRegistrationResponse;
import com.tridium.cloudLink.forge.auth.ForgeRegistrationStatusRequest;
import com.tridium.cloudLink.forge.auth.RpkChallengeParameters;
import com.tridium.cloudLink.forge.auth.RpkChallengeResponseParameters;
import com.tridium.cloudLink.forge.msg.ForgeRpkChallengeReply;
import com.tridium.cloudLink.forge.msg.ForgeRpkChallengeRequest;
import com.tridium.cloudLink.forge.msg.ForgeRpkResponseReply;
import com.tridium.cloudLink.forge.msg.ForgeRpkResponseRequest;
import com.tridium.cloudLink.forge.msg.ForgeSystemConnectionsReply;
import com.tridium.cloudLink.forge.msg.ForgeSystemConnectionsRequest;
import com.tridium.cloudLink.transport.BAbstractConnectionlessTransport;
import com.tridium.cloudLink.transport.BAbstractTransport;
import com.tridium.cloudLink.transport.HttpResponseMessage;
import com.tridium.cloudLink.transport.HttpStatusException;
import com.tridium.cloudLink.util.BIDevConfigurer;
import com.tridium.cloudLink.util.BearerTokenInfo;
import com.tridium.cloudLink.util.CertificateAliasAndPasswordWrapper;
import com.tridium.cloudLink.util.IValueWrapper;
import com.tridium.cloudLink.util.PasswordWrapper;
import com.tridium.cloudLink.util.StringWrapper;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONWriter;
import com.tridium.json.quick.QuickJSONWriter;
import com.tridium.nre.security.NiagaraBasicPermission;
import com.tridium.sys.Nre;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.security.HsmManager;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.security.BCertificateAliasAndPassword;
import javax.baja.security.BPassword;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.security.crypto.IKeyStore;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.ExecutorUtil;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="registrationState", type="BSystemRegistrationState", defaultValue="BSystemRegistrationState.DEFAULT", flags=257), @NiagaraProperty(name="authenticationState", type="BSystemAuthenticationState", defaultValue="BSystemAuthenticationState.DEFAULT", flags=259), @NiagaraProperty(name="systemOwnershipCode", type="String", defaultValue="", flags=1), @NiagaraProperty(name="systemPublicKey", type="BString", defaultValue="", flags=7), @NiagaraProperty(name="registrationUrl", type="BString", defaultValue="BString.DEFAULT", flags=5), @NiagaraProperty(name="authenticationUrl", type="BString", defaultValue="BString.DEFAULT", flags=5), @NiagaraProperty(name="connectionInfoUrl", type="BString", defaultValue="BString.DEFAULT", flags=5), @NiagaraProperty(name="authenticatorId", type="BString", defaultValue="BString.make(AUTH_PLATFORM_TYPE_RPK)", flags=1, override=true), @NiagaraProperty(name="gatewayId", type="BString", defaultValue="BString.DEFAULT", flags=5), @NiagaraProperty(name="keyStoreType", type="BKeyStoreType", defaultValue="BKeyStoreType.Unknown", flags=5), @NiagaraProperty(name="maxAuthenticateRetryInterval", type="BRelTime", defaultValue="BRelTime.makeDays(1)"), @NiagaraProperty(name="certificatePassword", type="BPassword", defaultValue="BPassword.make(\"\")", flags=64, facets={@Facet(name="BPassword.PLACEHOLDER_TEXT", value="\"%lexicon(workbench:default.password.placeholder.label)%\""), @Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")})})
@NiagaraActions(value={@NiagaraAction(name="reauthenticate", flags=257), @NiagaraAction(name="reregister", flags=1)})
@NiagaraTopic(name="registrationFailed", eventType="BString", flags=4)
public class BRpkAuthenticator
extends BAbstractForgeAuthenticator {
    public static final Property registrationState = BRpkAuthenticator.newProperty((int)257, (BValue)BSystemRegistrationState.DEFAULT, null);
    public static final Property authenticationState = BRpkAuthenticator.newProperty((int)259, (BValue)BSystemAuthenticationState.DEFAULT, null);
    public static final Property systemOwnershipCode = BRpkAuthenticator.newProperty((int)1, (String)"", null);
    public static final Property systemPublicKey = BRpkAuthenticator.newProperty((int)7, (String)"", null);
    public static final Property registrationUrl = BRpkAuthenticator.newProperty((int)5, (BValue)BString.DEFAULT, null);
    public static final Property authenticationUrl = BRpkAuthenticator.newProperty((int)5, (BValue)BString.DEFAULT, null);
    public static final Property connectionInfoUrl = BRpkAuthenticator.newProperty((int)5, (BValue)BString.DEFAULT, null);
    public static final Property authenticatorId = BRpkAuthenticator.newProperty((int)1, (BValue)BString.make((String)"RpkAuthenticator"), null);
    public static final Property gatewayId = BRpkAuthenticator.newProperty((int)5, (BValue)BString.DEFAULT, null);
    public static final Property keyStoreType = BRpkAuthenticator.newProperty((int)5, (BValue)BKeyStoreType.Unknown, null);
    public static final Property maxAuthenticateRetryInterval = BRpkAuthenticator.newProperty((int)0, (BValue)BRelTime.makeDays((int)1), null);
    public static final Property certificatePassword = BRpkAuthenticator.newProperty((int)64, (BValue)BPassword.make((String)""), (BFacets)BFacets.make((BFacets)BFacets.make((String)"placeholderText", (String)"%lexicon(workbench:default.password.placeholder.label)%"), (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE)));
    public static final Action reauthenticate = BRpkAuthenticator.newAction((int)257, null);
    public static final Action reregister = BRpkAuthenticator.newAction((int)1, null);
    public static final Topic registrationFailed = BRpkAuthenticator.newTopic((int)4, null);
    public static final Type TYPE = Sys.loadType(BRpkAuthenticator.class);
    private static final Lexicon lex = Lexicon.make((String)"cloudLinkForge");
    private static final Logger log = Logger.getLogger("cloudLink.auth.forge");
    private static final String SYSTEM_CLASS_ENV_VAR_NAME = "cloud_id_systemClass";
    private static final String GATEWAY_ID_ENV_VARIABLE_NAME = "PELION_DEVICE_ID";
    private static final String GATEWAY_ID_NOT_FOUND_VARIABLE_VALUE = "";
    private static final int SYSTEM_OWNERSHIP_CODE_LEN = 24;
    private static final Pattern JWT_PATTERN = Pattern.compile("([^.]+)\\.([^.]+)\\.([^.]+)");
    private static final String SAS_TOKEN_PREFIX = "SharedAccessSignature";
    private static final Pattern SAS_PATTERN = Pattern.compile("(\\w+)=([^&]+)(?:&|$)");
    private static final String SAS_KEY_SE = "se";
    private static final DateTimeFormatter SAS_DATE_FORMATTER = DateTimeFormatter.ofPattern("dd-MMM-yy h:mm a z");
    private static final int SYSTEM_ID_LEN_AFTER_RSVD_CHARS = 46;
    private static final int MAX_KEYCHECK_ITERS = 99;
    private static final int ITERS_LEN = 2;
    private static SecureRandom sRand;
    private static final Pattern PASSWORD_PATTERN;
    private static final int DEFAULT_AUTH_RETRY_DELAY_MINUTES = 1;
    private static final int IOTHUB_REG_RETRY_INTERVAL_MINUTES = 5;
    private static final String RETRY_MSG = "Retrying in 5 minutes.";
    private volatile Map<String, ConnectionInfo> cachedConnectionInfoMap = Collections.emptyMap();
    private ScheduledExecutorService executor;
    private Future<BSystemAuthenticationState> authFuture;
    private ScheduledFuture<BSystemAuthenticationState> renewalFuture;
    private int reconnectInterval;
    private final CompletableFuture<Void> whenStarted = new CompletableFuture();
    private static final long jwtExpirationClockSkew;
    protected IKeyStoreHelper keyHelper;
    private BPassword currentCertPassword;
    protected static final String KEY_STORE_NOT_FOUND = "Cannot make a key store helper because the %s key store is not available.";
    protected static final String HSM_KEY_STORE_NOT_FOUND;
    protected static final String USER_KEY_STORE_NOT_FOUND;
    protected static final String SOFTWARE_KEY_NOT_FOUND = "Cannot make a user key store helper because the expected software key was not found.";
    private BMessagingChannel messagingChannel;
    public static final String SYSTEM_GUID = "systemGuid";
    public static final String SYSTEM_TYPE = "systemType";
    private static final int CHALLENGE_LENGTH = 32;
    private static final int CHALLENGE_SALT_LENGTH = 8;
    private static final String CLIENT_RANDOM = "ClientRandom";
    private static final String CLIENT_RANDOM_SIGNATURE = "ClientRandomSignature";
    private static final int BACKOFF_FACTOR = 2;
    public static final String SYSTEM_CONNECTIONS_API = "/api/system/connections";
    public static final String RPK_CHALLENGE_API = "/api/authentication/rpkchallenge";
    public static final String RPK_CHALLENGE_RESPONSE_API = "/api/authentication/rpkchallengeresponse";
    private static final String AUTH_DEV_CONFIGURER = "cloudLinkInternal:AuthDevConfigurer";
    private static final String MAKE_HOST_ID = "makeHostId";

    public BSystemRegistrationState getRegistrationState() {
        return (BSystemRegistrationState)this.get(registrationState);
    }

    public void setRegistrationState(BSystemRegistrationState v) {
        this.set(registrationState, (BValue)v, null);
    }

    public BSystemAuthenticationState getAuthenticationState() {
        return (BSystemAuthenticationState)this.get(authenticationState);
    }

    public void setAuthenticationState(BSystemAuthenticationState v) {
        this.set(authenticationState, (BValue)v, null);
    }

    public String getSystemOwnershipCode() {
        return this.getString(systemOwnershipCode);
    }

    public void setSystemOwnershipCode(String v) {
        this.setString(systemOwnershipCode, v, null);
    }

    public String getSystemPublicKey() {
        return this.getString(systemPublicKey);
    }

    public void setSystemPublicKey(String v) {
        this.setString(systemPublicKey, v, null);
    }

    public String getRegistrationUrl() {
        return this.getString(registrationUrl);
    }

    public void setRegistrationUrl(String v) {
        this.setString(registrationUrl, v, null);
    }

    public String getAuthenticationUrl() {
        return this.getString(authenticationUrl);
    }

    public void setAuthenticationUrl(String v) {
        this.setString(authenticationUrl, v, null);
    }

    public String getConnectionInfoUrl() {
        return this.getString(connectionInfoUrl);
    }

    public void setConnectionInfoUrl(String v) {
        this.setString(connectionInfoUrl, v, null);
    }

    public String getGatewayId() {
        return this.getString(gatewayId);
    }

    public void setGatewayId(String v) {
        this.setString(gatewayId, v, null);
    }

    public BKeyStoreType getKeyStoreType() {
        return (BKeyStoreType)this.get(keyStoreType);
    }

    public void setKeyStoreType(BKeyStoreType v) {
        this.set(keyStoreType, (BValue)v, null);
    }

    public BRelTime getMaxAuthenticateRetryInterval() {
        return (BRelTime)this.get(maxAuthenticateRetryInterval);
    }

    public void setMaxAuthenticateRetryInterval(BRelTime v) {
        this.set(maxAuthenticateRetryInterval, (BValue)v, null);
    }

    public BPassword getCertificatePassword() {
        return (BPassword)this.get(certificatePassword);
    }

    public void setCertificatePassword(BPassword v) {
        this.set(certificatePassword, (BValue)v, null);
    }

    public void reauthenticate() {
        this.invoke(reauthenticate, null, null);
    }

    public void reregister() {
        this.invoke(reregister, null, null);
    }

    public void fireRegistrationFailed(BString event) {
        this.fire(registrationFailed, (BValue)event, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public void serviceStarted() throws Exception {
        super.serviceStarted();
        if (this.getConnectionService().map(ccs -> ccs.isFatalFault()).orElse(true).booleanValue()) {
            return;
        }
        this.executor = ExecutorUtil.newSingleThreadBackgroundScheduledExecutor((String)"forgeRpkAuth", (long)2L, (TimeUnit)TimeUnit.MINUTES);
        this.registerTransport();
    }

    public void serviceStopped() throws Exception {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        this.executor = null;
    }

    public boolean completesStarted() {
        return true;
    }

    public CompletableFuture<Void> whenServiceStarted() {
        return this.whenStarted;
    }

    public void started() throws Exception {
        super.started();
        if (this.getConnectionService().map(ccs -> ccs.isFatalFault()).orElse(true).booleanValue()) {
            return;
        }
        this.currentCertPassword = this.getCertificatePassword();
        this.reconnectInterval = 1;
        boolean isNewSystem = this.getSystemId().isEmpty();
        this.validateSystemInfo();
        String systemId = this.getSystemId();
        try {
            this.keyHelper = AccessController.doPrivileged(() -> {
                BPassword curCertPw = BPassword.make((String)this.currentCertPassword.getValue());
                if (isNewSystem) {
                    this.platformSpecificStartupBehavior();
                    return this.makeKeyStoreHelper(this.getKeyStorePrefix() + systemId, curCertPw, systemId);
                }
                return this.makeKeyStoreHelper(this.getKeyStorePrefix() + systemId, curCertPw, systemId, this.getKeyStoreType());
            });
            this.setFaultCause(GATEWAY_ID_NOT_FOUND_VARIABLE_VALUE);
            this.setStatus(BStatus.make((int)(this.getStatus().getBits() & 0xFFFFFFFD)));
            this.setKeyStoreType(this.keyHelper instanceof HsmSignatureKeyStoreHelper ? BKeyStoreType.Hsm : BKeyStoreType.User);
            this.setSystemPublicKey(Base64.getEncoder().encodeToString(this.keyHelper.getPublicKey().getEncoded()));
        }
        catch (Exception ex) {
            String faultCause;
            BKeyStoreType keyStoreType = this.getKeyStoreType();
            switch (keyStoreType.getOrdinal()) {
                case 2: {
                    faultCause = lex.get("rpk.keystore.userFailure");
                    break;
                }
                case 1: {
                    faultCause = lex.get("rpk.keystore.hsmFailure");
                    break;
                }
                default: {
                    faultCause = lex.get("rpk.keystore.unknownFailure");
                }
            }
            this.setFaultCause(faultCause);
            this.setStatus(BStatus.make((int)(this.getStatus().getBits() | 2)));
            String msg = ex instanceof PrivilegedActionException ? ex.getCause().getMessage() : ex.getMessage();
            log.log(Level.WARNING, "RpkAuthenticator failed to start: " + msg, log.isLoggable(Level.FINE) ? ex : null);
            return;
        }
        this.getConnectionService().ifPresent(ccs -> ccs.registerForConnectionServiceReady(() -> {
            BAbstractClientAuthenticator auth = ccs.getAuthenticator("FederatedIdentity");
            if (auth instanceof BFederatedIdentityAuthenticator) {
                log.fine("Federated Identity Authenticator is incorrect type (Forge); awaiting migration");
            } else {
                com.tridium.cloudLink.auth.BFederatedIdentityAuthenticator fedIdAuthenticator = (com.tridium.cloudLink.auth.BFederatedIdentityAuthenticator)ccs.getAuthenticator("FederatedIdentity");
                if (fedIdAuthenticator != null && fedIdAuthenticator.isRegistered()) {
                    this.iotHubRegistration();
                }
            }
            this.authAsync();
        }));
        String gatewayIdEnvVariable = AccessController.doPrivileged(() -> {
            String s = System.getenv(GATEWAY_ID_ENV_VARIABLE_NAME);
            return s != null ? s : GATEWAY_ID_NOT_FOUND_VARIABLE_VALUE;
        });
        log.finest(String.format("Setting gatewayId to (%s)", gatewayIdEnvVariable));
        this.setGatewayId(gatewayIdEnvVariable);
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning() || this.getConnectionService().map(ccs -> ccs.isFatalFault()).orElse(true).booleanValue()) {
            return;
        }
        super.changed(p, cx);
        if (p.equals(status)) {
            if (this.configurationAllowsAuthentication()) {
                this.authAsync();
            } else {
                log.config("Cannot authenticate, check configuration settings.");
                this.cancelAuth();
                this.cancelRenewal();
                this.clearAuthentication();
            }
        } else if (p.equals(systemType)) {
            this.setRegistrationState(BSystemRegistrationState.unregistered);
            if (this.configurationAllowsAuthentication()) {
                this.clearAuthentication();
                this.authAsync();
            } else {
                log.info("Cannot authenticate, check configuration settings.");
            }
        } else if (p.equals(certificatePassword)) {
            if (this.getKeyStoreType() == BKeyStoreType.Hsm) {
                log.info("The HSM is being used for the key entry.  Password changes are not supported.");
                return;
            }
            if (this.currentCertPassword == null) {
                return;
            }
            this.executor.execute(this::changeCertificatePassword);
        }
    }

    void changeCertificatePassword() {
        BPassword newCertPassword = this.getCertificatePassword();
        if (this.currentCertPassword.validate(newCertPassword)) {
            log.finest("The new certificate password matched the current certificate password. The password was not changed.");
            return;
        }
        try {
            log.info("Changing the certificate password...");
            AccessController.doPrivileged(() -> {
                this.keyHelper.changeKeyEntryPassword(BPassword.make((String)this.currentCertPassword.getValue()), BPassword.make((String)newCertPassword.getValue()));
                return null;
            });
            this.currentCertPassword = newCertPassword;
            log.info("Completed certificate password change.");
        }
        catch (Exception except) {
            log.fine("Reverting the certificatePassword property change.");
            this.setCertificatePassword(this.currentCertPassword);
            Throwable cause = except instanceof PrivilegedActionException ? except.getCause() : except;
            log.log(Level.WARNING, "The certificate password was not changed.", log.isLoggable(Level.FINE) ? cause : null);
        }
    }

    public void stopped() throws Exception {
        super.stopped();
        this.cancelAuth();
        this.cancelRenewal();
        this.clearAuthentication();
        this.keyHelper = null;
    }

    protected void platformSpecificStartupBehavior() {
        this.setEnabled(false);
    }

    public void addMessageHandlerProperties(BAbstractTransport transport, String audience, Map<String, Object> encoderProps) {
        Map<String, IValueWrapper<?>> connectionInfo;
        encoderProps.put("SystemId", this.getSystemId());
        if (transport instanceof BAbstractConnectionlessTransport && !(connectionInfo = this.getConnectionInfo(audience)).isEmpty()) {
            String token = AccessController.doPrivileged(() -> PasswordWrapper.getPasswordValue((IValueWrapper)((IValueWrapper)connectionInfo.get("token"))));
            encoderProps.put("Authorization", "Bearer " + token);
        }
    }

    public Map<String, Object> getPlatformProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put(SYSTEM_GUID, this.getSystemGuid());
        props.put(SYSTEM_TYPE, this.getSystemType());
        props.put("systemId", this.getSystemId());
        return props;
    }

    public boolean canAuthenticate() {
        return this.configurationAllowsAuthentication() && this.messagingChannel != null && this.messagingChannel.isOperational();
    }

    private boolean configurationAllowsAuthentication() {
        return this.isOperational() && !this.getSystemId().isEmpty() && !this.getSystemType().isEmpty() && !this.getAuthenticationUrl().isEmpty() && !this.getConnectionInfoUrl().isEmpty();
    }

    public final Map<String, IValueWrapper<?>> getConnectionInfo(String id) {
        ConnectionInfo info;
        if (!this.isOperational()) {
            log.finest("getConnectionInfo called while authenticator is not operational");
            return Collections.emptyMap();
        }
        NiagaraBasicPermission getConnectionStringPermission = new NiagaraBasicPermission("CLOUD_GET_CONNECTION_INFORMATION");
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            log.finest("getConnectionInfo called with no security manager");
            return Collections.emptyMap();
        }
        sm.checkPermission((Permission)getConnectionStringPermission);
        HashMap connectionMap = new HashMap();
        if (this.cachedConnectionInfoMap != null) {
            BPassword password;
            String passwordValue;
            info = this.cachedConnectionInfoMap.get(id);
            if (info != null && BRpkAuthenticator.isSasTokenExpired(passwordValue = AccessController.doPrivileged(() -> BRpkAuthenticator.lambda$getConnectionInfo$9(password = info.getPassword()))).orElse(false).booleanValue()) {
                info = this.refreshToken(id);
            }
        } else {
            info = this.refreshToken(id);
        }
        if (info != null) {
            connectionMap.put("hostName", (IValueWrapper<?>)new StringWrapper(info.getPath()));
            connectionMap.put("id", (IValueWrapper<?>)new StringWrapper(info.getUserName()));
            connectionMap.put("token", (IValueWrapper<?>)new PasswordWrapper(info.getPassword()));
        } else {
            log.finest(() -> "getConnectionInfo called but no connection info found for id [" + id + ']');
        }
        return connectionMap;
    }

    private ConnectionInfo refreshToken(String id) {
        if (this.configurationAllowsAuthentication()) {
            log.config(() -> "Refreshing IoT Hub token");
            try {
                this.authenticate(AuthenticationType.INITIAL);
                ConnectionInfo refreshedInfo = this.cachedConnectionInfoMap.get(id);
                if (refreshedInfo != null) {
                    log.config(() -> "Refreshed IoT Hub token");
                    return refreshedInfo;
                }
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Could not refresh IoT Hub token", log.isLoggable(Level.FINE) ? ex : null);
            }
        }
        return null;
    }

    public String getIotHubConnectionString() {
        Map<String, IValueWrapper<?>> connectionInfo = this.getConnectionInfo("IoTHub2");
        if (connectionInfo.isEmpty()) {
            connectionInfo = this.getConnectionInfo("IoTHub");
        }
        if (connectionInfo.isEmpty()) {
            throw new RuntimeException("Unable to get connection information from authenticator");
        }
        IValueWrapper<?> tokenWrapper = connectionInfo.get("token");
        String token = AccessController.doPrivileged(() -> PasswordWrapper.getPasswordValue((IValueWrapper)tokenWrapper));
        return String.format("HostName=%s;DeviceId=%s;SharedAccessSignature=%s;X509Cert=False", StringWrapper.getString(connectionInfo.get("hostName")), StringWrapper.getString(connectionInfo.get("id")), token);
    }

    public void doReregister() {
        AccessController.doPrivileged(() -> {
            this.iotHubRegistration();
            return null;
        });
    }

    protected void iotHubRegistration() {
        if (this.getRegistrationState().isRegistered()) {
            return;
        }
        BCloudConnectionService ccs = this.getConnectionService().orElse(null);
        if (ccs == null) {
            log.info("Cloud connection service not found; unable to register with IoTHub");
            return;
        }
        com.tridium.cloudLink.auth.BFederatedIdentityAuthenticator fedIdAuthenticator = (com.tridium.cloudLink.auth.BFederatedIdentityAuthenticator)ccs.getAuthenticator("FederatedIdentity");
        if (fedIdAuthenticator == null) {
            log.info("Federated Identity Authenticator not found; Retrying in 5 minutes.");
            this.executor.schedule(this::iotHubRegistration, 5L, TimeUnit.MINUTES);
            return;
        }
        if (!fedIdAuthenticator.isRegistered()) {
            log.info("Federated Identity Authenticator is not registered; Retrying in 5 minutes.");
            this.executor.schedule(this::iotHubRegistrationStatus, 5L, TimeUnit.MINUTES);
            return;
        }
        String fedIdCertAlias = fedIdAuthenticator.getCertAlias();
        if (fedIdCertAlias == null) {
            log.info("Federated Identity Authenticator does not have a valid certificate; Retrying in 5 minutes.");
            this.executor.schedule(this::iotHubRegistration, 5L, TimeUnit.MINUTES);
            return;
        }
        if (this.isFatalFault()) {
            log.warning("RPK Authenticator is in fatal fault; unable to register with IoTHub");
            return;
        }
        if (this.isFault()) {
            log.info("RPK Authenticator is in fault; Retrying in 5 minutes.");
            this.executor.schedule(this::iotHubRegistration, 5L, TimeUnit.MINUTES);
            return;
        }
        BCertificateAliasAndPassword certAliasAndPass = CertificateAliasAndPasswordWrapper.getCertificateAliasAndPassword((IValueWrapper)((IValueWrapper)fedIdAuthenticator.getConnectionInfo(null).get("certAliasAndPassword")));
        ForgeRegistrationRequest request = new ForgeRegistrationRequest(fedIdAuthenticator.getRegistrationHost(), this, certAliasAndPass);
        CompletableFuture reqFuture = AccessController.doPrivileged(() -> this.messagingChannel.sendAsync("HTTP", request.toMessage(true)));
        reqFuture.whenComplete((resp, err) -> {
            if (err != null) {
                log.log(Level.INFO, "Error registering device with IoTHub; Retrying in 5 minutes.", log.isLoggable(Level.FINE) ? err : null);
                fedIdAuthenticator.setStatusMessage(fedIdAuthenticator.getInitError(err));
                this.executor.schedule(this::iotHubRegistration, 5L, TimeUnit.MINUTES);
            } else {
                ForgeRegistrationResponse response = new ForgeRegistrationResponse((HttpResponseMessage)resp);
                if (response.isSuccessful()) {
                    log.config(() -> "IoT Hub registration response: " + response.getMessage());
                    fedIdAuthenticator.setStatusMessage(GATEWAY_ID_NOT_FOUND_VARIABLE_VALUE);
                    this.executor.schedule(this::iotHubRegistrationStatus, fedIdAuthenticator.getDeviceUuidDelay().getMillis(), TimeUnit.MILLISECONDS);
                } else {
                    log.info(() -> "IoTHub registration unsuccessful" + (log.isLoggable(Level.FINE) ? ": " + response.getMessage() : GATEWAY_ID_NOT_FOUND_VARIABLE_VALUE) + "; " + RETRY_MSG);
                    this.executor.schedule(this::iotHubRegistration, 5L, TimeUnit.MINUTES);
                }
            }
        });
    }

    protected void iotHubRegistrationStatus() {
        if (this.getRegistrationState().isRegistered()) {
            return;
        }
        BCloudConnectionService ccs = this.getConnectionService().orElse(null);
        if (ccs == null) {
            log.info("Cloud connection service not found; unable to get iothub registration status");
            return;
        }
        com.tridium.cloudLink.auth.BFederatedIdentityAuthenticator fedIdAuthenticator = (com.tridium.cloudLink.auth.BFederatedIdentityAuthenticator)ccs.getAuthenticator("FederatedIdentity");
        if (fedIdAuthenticator == null) {
            log.info("Federated Identity Authenticator not found; Retrying in 5 minutes.");
            this.executor.schedule(this::iotHubRegistrationStatus, 5L, TimeUnit.MINUTES);
            return;
        }
        if (!fedIdAuthenticator.isRegistered()) {
            log.info("Federated Identity Authenticator is not registered; Retrying in 5 minutes.");
            this.executor.schedule(this::iotHubRegistrationStatus, 5L, TimeUnit.MINUTES);
            return;
        }
        String fedIdCertAlias = fedIdAuthenticator.getCertAlias();
        if (fedIdCertAlias == null) {
            log.info("Federated Identity Authenticator does not have a valid certificate; Retrying in 5 minutes.");
            this.executor.schedule(this::iotHubRegistrationStatus, 5L, TimeUnit.MINUTES);
            return;
        }
        BCertificateAliasAndPassword certAliasAndPass = CertificateAliasAndPasswordWrapper.getCertificateAliasAndPassword((IValueWrapper)((IValueWrapper)fedIdAuthenticator.getConnectionInfo(null).get("certAliasAndPassword")));
        ForgeRegistrationStatusRequest request = new ForgeRegistrationStatusRequest(fedIdAuthenticator.getRegistrationHost(), this.getSystemId(), certAliasAndPass);
        CompletableFuture reqFuture = AccessController.doPrivileged(() -> this.messagingChannel.sendAsync("HTTP", request.toMessage(true)));
        reqFuture.whenComplete((resp, err) -> {
            if (err != null) {
                log.log(Level.INFO, "Error getting device registration status for IoTHub; retrying shortly", log.isLoggable(Level.FINE) ? err : null);
                fedIdAuthenticator.setStatusMessage(fedIdAuthenticator.getInitError(err));
                this.executor.schedule(this::iotHubRegistrationStatus, fedIdAuthenticator.getDeviceUuidDelay().getMillis(), TimeUnit.MILLISECONDS);
            } else {
                ForgeRegistrationResponse response = new ForgeRegistrationResponse((HttpResponseMessage)resp);
                if (response.isSuccessful() && "success".equals(response.getMessage())) {
                    log.config(() -> "IoTHub registration status reports " + response.getMessage());
                    fedIdAuthenticator.setStatusMessage(GATEWAY_ID_NOT_FOUND_VARIABLE_VALUE);
                    this.setEnabled(true);
                } else {
                    log.config(() -> "IoTHub registration status reports " + response.getMessage());
                    if ("pending".equals(response.getMessage())) {
                        log.config("Registration still pending; retrying shortly");
                        fedIdAuthenticator.setStatusMessage(GATEWAY_ID_NOT_FOUND_VARIABLE_VALUE);
                        this.executor.schedule(this::iotHubRegistrationStatus, fedIdAuthenticator.getDeviceUuidDelay().getMillis(), TimeUnit.MILLISECONDS);
                    } else {
                        log.info("Registration neither pending, nor successful; Retrying in 5 minutes.");
                        this.executor.schedule(this::iotHubRegistration, 5L, TimeUnit.MINUTES);
                    }
                }
            }
        });
    }

    public boolean canRegister() {
        return this.isOperational() && !this.getRegistrationUrl().isEmpty() && !this.getSystemId().isEmpty() && !this.getSystemType().isEmpty();
    }

    public boolean isRegistered() {
        return this.getRegistrationState().isRegistered();
    }

    public boolean isAuthenticated() {
        return this.getAuthenticationState().isAuthenticated();
    }

    protected void authenticate(AuthenticationType type) throws SystemAuthenticationException {
        log.config("Connecting to Forge identity provider with RPK");
        try {
            this.setAuthenticationState(BSystemAuthenticationState.authenticationPending);
            String provisioningSrvToken = this.rpkChallenge(this.getSystemId(), this.getSystemType(), this.getAuthenticationUrl());
            if (this.getRegistrationState() == BSystemRegistrationState.unregistered) {
                this.setRegistrationState(BSystemRegistrationState.needsProvisioning);
            }
            Map<String, ConnectionInfo> connectionInfoMap = this.systemConnections(provisioningSrvToken, this.getConnectionInfoUrl());
            this.cachedConnectionInfoMap = connectionInfoMap;
            if (connectionInfoMap.isEmpty()) {
                throw new RuntimeException("Could not find any system connection information");
            }
            BRpkAuthenticator.getIotHubConnectionInfo(connectionInfoMap).ifPresent(v -> this.setSystemGuid(v.getUserName()));
            if (!Thread.currentThread().isInterrupted()) {
                this.reconnectInterval = 1;
                this.scheduleRenewal(this.getRenewalInterval().getMinutes(), AuthenticationType.RENEWAL);
            }
            this.setRegistrationState(BSystemRegistrationState.registered);
            this.setAuthenticationState(BSystemAuthenticationState.authenticated);
        }
        catch (Exception e) {
            SystemAuthenticationException systemAuthExcept;
            Throwable cause = e.getCause();
            if (!(e instanceof InterruptedException) && !(cause instanceof InterruptedException)) {
                switch (type) {
                    case INITIAL: {
                        this.scheduleRenewal(this.reconnectInterval, AuthenticationType.INITIAL);
                        this.computeBackoff();
                        break;
                    }
                    case RENEWAL: {
                        int renewalMinutes = this.getRenewalFailureInterval().getMinutes();
                        if (renewalMinutes == 0) {
                            renewalMinutes = this.reconnectInterval;
                            this.computeBackoff();
                        }
                        this.scheduleRenewal(renewalMinutes, AuthenticationType.RENEWAL);
                    }
                }
            }
            if (e instanceof HttpStatusException || cause instanceof HttpStatusException) {
                int statusCode = ((HttpStatusException)cause).getStatusCode();
                if (statusCode == 404) {
                    this.setRegistrationState(BSystemRegistrationState.unregistered);
                } else if (statusCode == 403) {
                    this.setRegistrationState(BSystemRegistrationState.needsProvisioning);
                }
                systemAuthExcept = new SystemAuthenticationException(statusCode);
            } else {
                systemAuthExcept = new SystemAuthenticationException("Error during authentication: " + e, (Throwable)e);
            }
            this.setAuthenticationState(BSystemAuthenticationState.authenticationFailed);
            this.fireRegistrationFailed(BString.DEFAULT);
            throw systemAuthExcept;
        }
    }

    protected void computeBackoff() {
        this.reconnectInterval *= 2;
        if (this.reconnectInterval > this.getMaxAuthenticateRetryInterval().getMinutes()) {
            this.reconnectInterval = this.getMaxAuthenticateRetryInterval().getMinutes();
        }
    }

    private Future<BSystemAuthenticationState> authAsync() {
        this.cancelAuth();
        this.cancelRenewal();
        this.authFuture = this.executor.submit(() -> this.authSync(AuthenticationType.INITIAL));
        return this.authFuture;
    }

    protected void cancelAuth() {
        if (this.authFuture != null) {
            if (!this.authFuture.isDone()) {
                this.authFuture.cancel(true);
            }
            this.authFuture = null;
        }
    }

    private BSystemAuthenticationState authSync(AuthenticationType authType) {
        if (this.configurationAllowsAuthentication()) {
            log.fine("Authenticating with the cloud identity provider...");
            try {
                this.authenticate(authType);
                log.fine("Authenticated with the cloud identity provider");
            }
            catch (SystemAuthenticationException e) {
                log.log(Level.WARNING, "Cannot authenticate: " + e.getMessage(), log.isLoggable(Level.FINE) ? e : null);
            }
        }
        return this.getAuthenticationState();
    }

    private void clearAuthentication() {
        log.finest("Clearing Authentication information");
        if (this.isAuthenticated()) {
            this.cachedConnectionInfoMap.clear();
            this.setAuthenticationState(BSystemAuthenticationState.unauthenticated);
        }
    }

    public void doReauthenticate() {
        log.finest("doReauthenticate()");
        if (this.configurationAllowsAuthentication()) {
            this.authAsync();
        } else {
            log.info("Cannot authenticate, check configuration settings.");
        }
    }

    @NiagaraRpc(permissions="W", transports={@Transport(type=TransportType.box)})
    public String getBajaVersion(Context cx) {
        return Sys.getBajaVersion().toString();
    }

    @NiagaraRpc(permissions="W", transports={@Transport(type=TransportType.box)})
    public void reauthenticate(Context cx) throws Throwable {
        if (this.configurationAllowsAuthentication()) {
            this.authAsync();
        } else {
            log.info("Cannot authenticate, check configuration settings.");
        }
    }

    protected String generateSystemIdTemplate() {
        String template = "N4:%s:";
        String hostId = Arrays.stream(((BClientAuthenticatorsFolder)this.getParent().as(BClientAuthenticatorsFolder.class)).getChildren(BIDevConfigurer.class)).filter(biDevConfigurer -> AUTH_DEV_CONFIGURER.equals(biDevConfigurer.getType().toString())).findFirst().map(biDevConfigurer -> String.valueOf(biDevConfigurer.configure((BAbstractClientAuthenticator)this, new Object[]{MAKE_HOST_ID}))).orElse(Sys.getHostId());
        return template + hostId;
    }

    protected int maxSafeNameLen(String hostId) {
        if (hostId == null || hostId.isEmpty()) {
            return 46;
        }
        return 46 - hostId.length();
    }

    private static String generateGuidSystemId() {
        return "GUID:" + UUID.randomUUID();
    }

    private static String getSystemClass(String systemId) {
        if (systemId != null && systemId.contains(":")) {
            return systemId.substring(0, systemId.indexOf(":"));
        }
        throw new IllegalArgumentException("Cannot determine systemClass from systemId " + systemId);
    }

    protected String getSystemClass() throws PrivilegedActionException {
        String systemClass = AccessController.doPrivileged(() -> {
            String s = System.getenv(SYSTEM_CLASS_ENV_VAR_NAME);
            return s != null ? s : "N4";
        });
        return systemClass;
    }

    private void validateSystemInfo() {
        try {
            String systemId = this.getSystemId();
            String systemClass = this.getSystemClass();
            if (systemId.isEmpty()) {
                this.initialize(systemClass);
            } else {
                String systemClassFromId = BRpkAuthenticator.getSystemClass(systemId);
                if (!systemClassFromId.equals(systemClass)) {
                    String message = String.format("System ID class %s does not match System ID environment type %s", systemClassFromId, systemClass);
                    throw new IllegalStateException(message);
                }
                if (!systemClassFromId.equals("N4") && !systemClassFromId.equals("GUID")) {
                    String message = String.format("Invalid systemClass specified in systemId: %s", systemClassFromId);
                    this.configFatal(message);
                    throw new IllegalStateException(message);
                }
            }
            this.configOk();
        }
        catch (Exception ex) {
            log.log(Level.WARNING, String.format("Could not validate system id format: %s", this.getSystemId()), log.isLoggable(Level.FINE) ? ex : null);
            this.configFail(lex.getText("invalidSystemId"));
        }
    }

    protected String getSafeSystemId(String stationName, String systemIdTemplate) {
        String safeStationName = stationName.replace('_', '-');
        int maxSafeNameLen = this.maxSafeNameLen(Sys.getHostId());
        if (safeStationName.length() <= maxSafeNameLen) {
            return String.format(systemIdTemplate, safeStationName);
        }
        try {
            IKeyStore keyStore = this.getUserKeyStore();
            String nameStart = safeStationName.substring(0, maxSafeNameLen - 2);
            String safeSystemId = GATEWAY_ID_NOT_FOUND_VARIABLE_VALUE;
            for (int iterCnt = 1; iterCnt <= 99; ++iterCnt) {
                String nameCandidate = nameStart + iterCnt;
                try {
                    safeSystemId = String.format(systemIdTemplate, nameCandidate);
                    if (keyStore.isKeyEntry(this.getKeyStorePrefix() + safeSystemId)) continue;
                    return safeSystemId;
                }
                catch (Exception e) {
                    log.log(Level.WARNING, String.format("Unable to check for existing keystore entry %s", this.getKeyStorePrefix() + safeSystemId), log.isLoggable(Level.FINE) ? e : null);
                    break;
                }
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Unable to obtain the system keyStore", log.isLoggable(Level.FINE) ? e : null);
        }
        log.severe(String.format("Could not find safe station name for generating System ID for station %s", stationName));
        return String.format(systemIdTemplate, safeStationName.substring(0, 46 - Sys.getHostId().length()));
    }

    private void initialize(String systemClass) {
        if (systemClass == null || "N4".equals(systemClass)) {
            this.setSystemOwnershipCode(BRpkAuthenticator.makeSystemOwnershipCode(24));
            String stationName = Sys.isStation() ? Sys.getStation().getStationName() : "offline";
            this.setSystemId(this.getSafeSystemId(stationName, this.generateSystemIdTemplate()));
        } else if ("GUID".equals(systemClass)) {
            this.setSystemId(BRpkAuthenticator.generateGuidSystemId());
            this.setSystemOwnershipCode(BRpkAuthenticator.makeSystemOwnershipCode(24));
        } else {
            throw new IllegalArgumentException("Invalid systemClass for initializing RpkAuthenticator: " + systemClass);
        }
    }

    private static String makeSystemOwnershipCode(int numBytes) {
        byte[] b = new byte[numBytes];
        sRand.nextBytes(b);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numBytes; ++i) {
            sb.append(String.format("%02x", b[i]));
        }
        return sb.toString();
    }

    protected String rpkChallenge(String systemId, String systemType, String authenticationUrl) throws HttpStatusException, IOException, SystemAuthenticationException, InterruptedException, ExecutionException, TimeoutException {
        log.config("Starting RPK Challenge");
        long t0 = Clock.ticks();
        RpkChallengeParameters challengeRequestParams = new RpkChallengeParameters(systemId, systemType);
        String challParamStr = BRpkAuthenticator.getChallengeParameterString(challengeRequestParams);
        String rpkChallActivityId = UUID.randomUUID().toString();
        log.config(() -> String.format("Sending RPK Challenge request to URL %s: %s, with activity id %s", authenticationUrl + RPK_CHALLENGE_API, challParamStr, rpkChallActivityId));
        CompletableFuture rpkChallReplyFuture = new CompletableFuture();
        ForgeRpkChallengeRequest rpkChallRequest = new ForgeRpkChallengeRequest(challParamStr, new URL(authenticationUrl + RPK_CHALLENGE_API), Collections.singletonMap("x-activity-id", rpkChallActivityId));
        CompletableFuture reqFuture = AccessController.doPrivileged(() -> this.messagingChannel.sendAsync("HTTP", rpkChallRequest.toMessage(true)));
        reqFuture.whenComplete((resp, err) -> {
            if (err != null) {
                log.log(Level.FINEST, "RPK Challenge Request received an error ", (Throwable)err);
                rpkChallReplyFuture.completeExceptionally((Throwable)err);
            } else {
                try (HttpResponseMessage response = (HttpResponseMessage)resp;){
                    String responseStr = response.getBodyAsString();
                    log.finest(() -> "Received RPK Challenge response body " + responseStr);
                    ForgeRpkChallengeReply reply = new ForgeRpkChallengeReply(responseStr);
                    rpkChallReplyFuture.complete(reply);
                }
                catch (Exception ex) {
                    rpkChallReplyFuture.completeExceptionally(ex);
                }
            }
        });
        ForgeRpkChallengeReply challengeReply = (ForgeRpkChallengeReply)rpkChallReplyFuture.get(this.messagingChannel.getChannelConfig().getTransport("HTTP").getDefaultMessageTimeout().getMillis(), TimeUnit.MILLISECONDS);
        String challengeString = challengeReply.getRpkChallengeResponseString();
        RpkChallengeResponseParameters responseParams = this.generateRpkChallengeResponse(challengeString, systemId, systemType);
        String rpkChallRespStr = BRpkAuthenticator.getRpkChallengeResponseParameterString(responseParams);
        String rpkChallRespActivityId = UUID.randomUUID().toString();
        log.config(() -> String.format("Sending RPK Challenge Response to URL %s: %s, with activity id %s", authenticationUrl + RPK_CHALLENGE_RESPONSE_API, rpkChallRespStr, rpkChallRespActivityId));
        CompletableFuture rpkRespReplyFuture = new CompletableFuture();
        ForgeRpkResponseRequest rpkRespRequest = new ForgeRpkResponseRequest(rpkChallRespStr, new URL(authenticationUrl + RPK_CHALLENGE_RESPONSE_API), Collections.singletonMap("x-activity-id", rpkChallRespActivityId));
        CompletableFuture rspFuture = AccessController.doPrivileged(() -> this.messagingChannel.sendAsync("HTTP", rpkRespRequest.toMessage(true)));
        rspFuture.whenComplete((resp, err) -> {
            if (err != null) {
                log.log(Level.FINEST, "RPK Challenge Response received an error ", (Throwable)err);
                rpkRespReplyFuture.completeExceptionally((Throwable)err);
            } else {
                try (HttpResponseMessage response = (HttpResponseMessage)resp;){
                    log.finest(() -> "Received RPK Challenge Response (body not logged).");
                    ForgeRpkResponseReply reply = new ForgeRpkResponseReply(response.getBodyAsString());
                    rpkRespReplyFuture.complete(reply);
                }
                catch (Exception ex) {
                    rpkRespReplyFuture.completeExceptionally(ex);
                }
            }
        });
        ForgeRpkResponseReply responseReply = (ForgeRpkResponseReply)rpkRespReplyFuture.get(this.messagingChannel.getChannelConfig().getTransport("HTTP").getDefaultMessageTimeout().getMillis(), TimeUnit.MILLISECONDS);
        long time = Clock.ticks() - t0;
        log.config(() -> String.format("Completed RPK Challenge - %s ms", time));
        return responseReply.getIdentityJwt();
    }

    protected Map<String, ConnectionInfo> systemConnections(String bearerToken, String connectionInfoUrl) throws IOException, HttpStatusException, InterruptedException, ExecutionException, TimeoutException {
        log.config("Starting System Connections");
        long t0 = Clock.ticks();
        Map headers = CloudLinkUtils.makeBearerTokenAuthHeaderMap((String)bearerToken);
        String activityId = UUID.randomUUID().toString();
        headers.put("x-activity-id", activityId);
        log.config(() -> String.format("Sending System Connections request to URL %s, with activity id %s", connectionInfoUrl + SYSTEM_CONNECTIONS_API, activityId));
        CompletableFuture sysConnFuture = new CompletableFuture();
        ForgeSystemConnectionsRequest sysConnRequest = new ForgeSystemConnectionsRequest(new URL(connectionInfoUrl + SYSTEM_CONNECTIONS_API), headers);
        CompletableFuture reqFuture = AccessController.doPrivileged(() -> this.messagingChannel.sendAsync("HTTP", sysConnRequest.toMessage(true)));
        reqFuture.whenComplete((resp, err) -> {
            if (err != null) {
                log.log(Level.FINEST, "System Connections Request received an error ", (Throwable)err);
                sysConnFuture.completeExceptionally((Throwable)err);
            } else {
                try (HttpResponseMessage response = (HttpResponseMessage)resp;){
                    String responseStr = response.getBodyAsString();
                    log.finest(() -> "Received System Connections response body " + PASSWORD_PATTERN.matcher(responseStr).replaceAll("\"Password\": \"not logged\""));
                    ForgeSystemConnectionsReply reply = new ForgeSystemConnectionsReply(responseStr);
                    sysConnFuture.complete(reply);
                }
                catch (Exception ex) {
                    sysConnFuture.completeExceptionally(ex);
                }
            }
        });
        ForgeSystemConnectionsReply sysConnResponse = (ForgeSystemConnectionsReply)sysConnFuture.get(this.messagingChannel.getChannelConfig().getTransport("HTTP").getDefaultMessageTimeout().getMillis(), TimeUnit.MILLISECONDS);
        JSONArray connections = sysConnResponse.getConnectionsList();
        HashMap<String, ConnectionInfo> map = new HashMap<String, ConnectionInfo>(connections.length());
        for (int i = 0; i < connections.length(); ++i) {
            JSONObject info = connections.getJSONObject(i);
            if (!info.has("ServerType") || !info.has("UserName") || !info.has("Password") || !info.has("Path")) continue;
            map.put(info.getString("ServerType"), new ConnectionInfo(info.getString("UserName"), BPassword.make((String)info.getString("Password")), info.getString("Path")));
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config(String.format("Completed System Connections: %s ms", Clock.ticks() - t0));
        }
        return map;
    }

    private static String getChallengeParameterString(RpkChallengeParameters challengeParameters) {
        StringWriter sw = new StringWriter();
        JSONWriter jw = QuickJSONWriter.make((Appendable)sw);
        jw.object().key("SystemId").value((Object)challengeParameters.getSystemId()).key(SYSTEM_TYPE).value((Object)challengeParameters.getSystemType()).endObject();
        return sw.toString();
    }

    private static String getRpkChallengeResponseParameterString(RpkChallengeResponseParameters responseParameters) {
        StringWriter sw = new StringWriter();
        JSONWriter jw = QuickJSONWriter.make((Appendable)sw);
        jw.object().key("SystemId").value((Object)responseParameters.getSystemId()).key(SYSTEM_TYPE).value((Object)responseParameters.getSystemType()).key(CLIENT_RANDOM).value((Object)Base64.getEncoder().encodeToString(responseParameters.getClientRandom())).key(CLIENT_RANDOM_SIGNATURE).value((Object)Base64.getEncoder().encodeToString(responseParameters.getClientRandomSignature())).endObject();
        return sw.toString();
    }

    private RpkChallengeResponseParameters generateRpkChallengeResponse(String challengeString, String systemId, String systemType) throws SystemAuthenticationException {
        byte[] challenge = Base64.getDecoder().decode(challengeString);
        if (challenge == null || challenge.length != 32) {
            throw new SystemAuthenticationException("Server challenge is null or incorrect length");
        }
        byte[] clientRnd = new byte[8];
        sRand.nextBytes(clientRnd);
        byte[] buffer = new byte[40];
        System.arraycopy(challenge, 0, buffer, 0, 32);
        System.arraycopy(clientRnd, 0, buffer, 32, 8);
        try {
            byte[] signature = AccessController.doPrivileged(() -> this.keyHelper.sign(buffer));
            return new RpkChallengeResponseParameters(systemId, systemType, clientRnd, signature);
        }
        catch (PrivilegedActionException e) {
            throw new SystemAuthenticationException("Could not sign RPK challenge response:", (Throwable)e.getException());
        }
        catch (Exception e) {
            throw new SystemAuthenticationException("Could not sign RPK challenge response: ", (Throwable)e);
        }
    }

    protected String getKeyStorePrefix() {
        return "Cloud_";
    }

    protected IKeyStore getUserKeyStore() throws Exception {
        return CertManagerFactory.getInstance().getKeyStore();
    }

    protected void scheduleRenewal(int minutes, AuthenticationType type) {
        if (minutes <= 0) {
            return;
        }
        this.renewalFuture = this.getExecutor().schedule(() -> this.authSync(type), (long)minutes, TimeUnit.MINUTES);
        log.config(() -> "Next RpkAuthenticator token renewal scheduled for: " + ZonedDateTime.now().plusMinutes(minutes).format(SAS_DATE_FORMATTER));
    }

    protected void cancelRenewal() {
        if (this.renewalFuture != null) {
            if (!this.renewalFuture.isDone()) {
                this.renewalFuture.cancel(true);
            }
            this.renewalFuture = null;
        }
    }

    public BRelTime getRenewalInterval() {
        Property p = this.getProperty("renewalInterval");
        BRelTime interval = p != null && p.getType().is(BRelTime.TYPE) ? (BRelTime)this.get(p).as(BRelTime.class) : this.calculateRenewal();
        return interval;
    }

    public BRelTime getRenewalFailureInterval() {
        Property p = this.getProperty("renewalFailureInterval");
        BRelTime interval = p != null && p.getType().is(BRelTime.TYPE) ? (BRelTime)this.get(p).as(BRelTime.class) : this.calculateRenewal();
        return interval;
    }

    private BRelTime calculateRenewal() {
        BRelTime interval = BRelTime.make((long)0L);
        ConnectionInfo iotHubInfo = BRpkAuthenticator.getIotHubConnectionInfo(this.cachedConnectionInfoMap).orElse(null);
        if (iotHubInfo == null) {
            return interval;
        }
        try {
            String token = AccessController.doPrivileged(() -> iotHubInfo.getPasswordValue());
            Map<String, String> sasParams = BRpkAuthenticator.parseSasToken(token);
            String expEpochSecStr = sasParams.get(SAS_KEY_SE);
            if (expEpochSecStr != null) {
                long expEpochSec = Long.parseLong(expEpochSecStr);
                long intervalSec = expEpochSec - Instant.now().getEpochSecond();
                if (intervalSec > 1200L) {
                    interval = BRelTime.makeSeconds((int)Math.toIntExact(intervalSec / 2L));
                } else {
                    interval = BRelTime.makeMinutes((int)1);
                    ZonedDateTime expDateTime = ZonedDateTime.ofInstant(Instant.ofEpochSecond(expEpochSec), ZoneId.systemDefault());
                    log.warning(() -> "The Iot Hub connection token expires too soon for scheduled renewal: " + expDateTime.format(SAS_DATE_FORMATTER) + "  (" + expEpochSecStr + ')');
                }
            }
        }
        catch (Exception ex) {
            log.log(Level.CONFIG, "An error occurred while calculating the IoT Hub token renewal interval: ", log.isLoggable(Level.FINE) ? ex : null);
        }
        return interval;
    }

    private static Optional<ConnectionInfo> getIotHubConnectionInfo(Map<String, ConnectionInfo> connections) {
        if (connections == null) {
            return Optional.empty();
        }
        ConnectionInfo iotHubInfo = connections.get("IoTHub2");
        if (iotHubInfo == null) {
            iotHubInfo = connections.get("IoTHub");
        }
        return Optional.ofNullable(iotHubInfo);
    }

    private static Optional<Boolean> isSasTokenExpired(String token) {
        try {
            Map<String, String> sasParams;
            String sasValueSe;
            if (BRpkAuthenticator.isSasToken(token) && (sasValueSe = (sasParams = BRpkAuthenticator.parseSasToken(token)).get(SAS_KEY_SE)) != null) {
                long epochSec = Long.parseLong(sasValueSe);
                BAbsTime expirationTime = BAbsTime.make((long)((epochSec - jwtExpirationClockSkew) * 1000L));
                BAbsTime now = BAbsTime.now();
                log.config(() -> String.format("Expiration time from token: %s", expirationTime));
                return Optional.of(expirationTime.isBefore(now));
            }
        }
        catch (Exception e) {
            log.fine(() -> String.format("Could not determine expiration of token: %s", e));
        }
        return Optional.empty();
    }

    private static Optional<Boolean> isBearerTokenExpired(String token) {
        try {
            JSONObject claims = null;
            Matcher matcher = JWT_PATTERN.matcher(token);
            if (matcher.matches()) {
                String claimsStr = new String(Base64.getDecoder().decode(matcher.group(2)), StandardCharsets.UTF_8);
                claims = new JSONObject(claimsStr);
            }
            if (claims != null && claims.has("exp")) {
                log.config(() -> "Testing token for refresh");
                BAbsTime expirationTime = BAbsTime.make((long)((claims.getLong("exp") - jwtExpirationClockSkew) * 1000L));
                BAbsTime now = BAbsTime.now();
                log.config(() -> String.format("Expiration time from token: %s", expirationTime));
                return Optional.of(expirationTime.isBefore(now));
            }
        }
        catch (Exception e) {
            log.fine(() -> String.format("Could not determine expiration of token: %s", e));
        }
        return Optional.empty();
    }

    public static boolean isSasToken(String sasToken) {
        if (sasToken == null || sasToken.isEmpty()) {
            return false;
        }
        return sasToken.trim().startsWith(SAS_TOKEN_PREFIX);
    }

    private static Map<String, String> parseSasToken(String sasToken) {
        HashMap<String, String> sasParams = new HashMap<String, String>();
        if (sasToken == null || sasToken.isEmpty()) {
            return sasParams;
        }
        try {
            Matcher matcher = SAS_PATTERN.matcher(sasToken);
            while (matcher.find()) {
                String key = matcher.group(1);
                String value = matcher.group(2);
                if (key == null || key.isEmpty()) continue;
                value = value == null ? "unavailable" : URLDecoder.decode(value.trim(), "UTF-8");
                sasParams.put(key, value);
            }
        }
        catch (Exception ex) {
            log.log(Level.CONFIG, "An error occurred while parsing the SAS Token.", log.isLoggable(Level.FINE) ? ex : null);
        }
        return sasParams;
    }

    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    private void registerTransport() {
        this.getConnectionService().ifPresent(ccs -> {
            this.messagingChannel = (BMessagingChannel)ccs.getChannel("Messaging");
        });
        if (this.messagingChannel == null) {
            log.warning("Could not find messaging channel for use by the RPK Authenticator; will not be able to authenticate!");
        }
    }

    protected IKeyStoreHelper makeKeyStoreHelper(String alias, BPassword password, String subject) throws Exception {
        IKeyStore keyStore = this.loadUserKeyStore().orElseThrow(() -> new Exception(USER_KEY_STORE_NOT_FOUND));
        return this.makeUserKeyStoreHelper(keyStore, alias, password, subject);
    }

    protected IKeyStoreHelper makeKeyStoreHelper(String alias, BPassword password, String subject, BKeyStoreType type) throws Exception {
        IKeyStoreHelper keyStoreHelper;
        switch (type.getOrdinal()) {
            case 1: {
                Optional<KeyStore> hsmKeyStoreOpt = this.loadHsmKeyStore(Nre.getHsmManager(), BRpkAuthenticator.makeKeyStoreSupplier("NiagaraHsm"));
                KeyStore hsmkKeyStore = hsmKeyStoreOpt.orElseThrow(() -> new Exception(HSM_KEY_STORE_NOT_FOUND));
                keyStoreHelper = this.makeHsmKeyStoreHelper(hsmkKeyStore);
                break;
            }
            case 2: {
                IKeyStore userKeyStore = this.loadUserKeyStore().orElseThrow(() -> new Exception(USER_KEY_STORE_NOT_FOUND));
                if (userKeyStore.isKeyEntry(alias)) {
                    keyStoreHelper = this.makeUserKeyStoreHelper(userKeyStore, alias, password, subject);
                    break;
                }
                throw new Exception(SOFTWARE_KEY_NOT_FOUND);
            }
            default: {
                Optional<IKeyStore> userKeyStoreOpt = this.loadUserKeyStore();
                if (userKeyStoreOpt.isPresent() && userKeyStoreOpt.get().isKeyEntry(alias)) {
                    keyStoreHelper = this.makeUserKeyStoreHelper(userKeyStoreOpt.get(), alias, password, subject);
                    break;
                }
                Optional<KeyStore> hsmKeyStoreOpt = this.loadHsmKeyStore(Nre.getHsmManager(), BRpkAuthenticator.makeKeyStoreSupplier("NiagaraHsm"));
                KeyStore hsmkKeyStore = hsmKeyStoreOpt.orElseThrow(() -> new Exception(SOFTWARE_KEY_NOT_FOUND));
                keyStoreHelper = this.makeHsmKeyStoreHelper(hsmkKeyStore);
            }
        }
        return keyStoreHelper;
    }

    protected Optional<IKeyStore> loadUserKeyStore() {
        Optional<Object> keyStoreOpt;
        try {
            keyStoreOpt = Optional.of(this.getUserKeyStore());
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Failed to get the user keystore.", log.isLoggable(Level.FINE) ? ex : null);
            keyStoreOpt = Optional.empty();
        }
        return keyStoreOpt;
    }

    protected Optional<KeyStore> loadHsmKeyStore(HsmManager hsmManager, Supplier<KeyStore> keyStoreSupplier) {
        Optional hsmKeyStoreOpt;
        try {
            hsmKeyStoreOpt = HsmSignatureKeyStoreHelper.getHsmKeyStore((HsmManager)hsmManager, keyStoreSupplier);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Failed to get the hardware security module keystore.", log.isLoggable(Level.FINE) ? e : null);
            hsmKeyStoreOpt = Optional.empty();
        }
        return hsmKeyStoreOpt;
    }

    protected IKeyStoreHelper makeUserKeyStoreHelper(IKeyStore userKeyStore, String alias, BPassword password, String subject) throws Exception {
        SignatureSupplier sigSupplier = new SignatureSupplier("SHA256withECDSA");
        EcdsaKeyPairGeneratorSupplier kpGenSupplier = new EcdsaKeyPairGeneratorSupplier();
        SignatureKeyStoreHelper keyHelper = new SignatureKeyStoreHelper(userKeyStore, alias, password, subject, (Supplier)kpGenSupplier, (Supplier)sigSupplier);
        return keyHelper;
    }

    protected IKeyStoreHelper makeHsmKeyStoreHelper(KeyStore hsmKeyStore) throws Exception {
        SignatureSupplier sigSupplier = new SignatureSupplier("SHA256WITHECDSA.NiagaraHsm");
        HsmSignatureKeyStoreHelper hsmKeystoreHelper = new HsmSignatureKeyStoreHelper(hsmKeyStore, (Supplier)sigSupplier);
        return hsmKeystoreHelper;
    }

    private static Supplier<KeyStore> makeKeyStoreSupplier(String name) {
        return () -> {
            try {
                return KeyStore.getInstance(name);
            }
            catch (KeyStoreException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public void spy(SpyWriter out) throws Exception {
        PublicKey publicKey;
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"BRpkAuthenticator", 2);
        out.prop((Object)"executor", (Object)this.executor);
        out.prop((Object)"messagingChannel", (Object)this.messagingChannel);
        out.prop((Object)"jwtExpirationClockSkew", (double)jwtExpirationClockSkew);
        out.prop((Object)"renewalFuture", this.renewalFuture);
        if (this.renewalFuture != null) {
            out.prop((Object)"Time until renewal", (Object)BRelTime.make((long)this.renewalFuture.getDelay(TimeUnit.MILLISECONDS)));
        }
        Map<String, ConnectionInfo> connectionInfo = this.cachedConnectionInfoMap;
        out.prop((Object)"Connection Information Size", connectionInfo.size());
        out.endProps();
        for (Map.Entry<String, ConnectionInfo> entry : connectionInfo.entrySet()) {
            out.startProps("Connection Information: " + entry.getKey());
            String password = AccessController.doPrivileged(() -> ((ConnectionInfo)entry.getValue()).getPasswordValue());
            out.prop((Object)"User(guid)", (Object)entry.getValue().getUserName());
            out.prop((Object)"URL(path)", (Object)entry.getValue().getPath());
            if (BRpkAuthenticator.isSasToken(password)) {
                Map<String, String> sasParams = BRpkAuthenticator.parseSasToken(password);
                for (Map.Entry<String, String> stringStringEntry : sasParams.entrySet()) {
                    String sasValue = stringStringEntry.getValue();
                    StringBuilder sasValueStr = new StringBuilder(sasValue);
                    if (SAS_KEY_SE.equals(stringStringEntry.getKey())) {
                        try {
                            long epochSec = Long.parseLong(sasValue);
                            ZonedDateTime expDateTime = ZonedDateTime.ofInstant(Instant.ofEpochSecond(epochSec), ZoneId.systemDefault());
                            sasValueStr.append(expDateTime.format(SAS_DATE_FORMATTER)).append("  (").append(sasValue).append(')');
                        }
                        catch (Exception ex) {
                            log.log(Level.CONFIG, "An error occurred while formatting the SAS token expiration date: ", log.isLoggable(Level.FINE) ? ex : null);
                        }
                    } else if ("sig".equals(stringStringEntry.getKey())) continue;
                    out.prop((Object)stringStringEntry.getKey(), (Object)sasValueStr.toString());
                }
            } else {
                BearerTokenInfo tokenInfo = new BearerTokenInfo(password);
                out.prop((Object)"algorithm", tokenInfo.getSpecificClaim("alg"));
                out.prop((Object)"systemId", tokenInfo.getSpecificClaim("SystemId"));
                out.prop((Object)SYSTEM_TYPE, tokenInfo.getSpecificClaim(SYSTEM_TYPE));
                out.prop((Object)"issuer", tokenInfo.getSpecificClaim("iss"));
                out.prop((Object)"audience", tokenInfo.getSpecificClaim("aud"));
                out.prop((Object)"notBefore", tokenInfo.getSpecificClaim("nbf"));
                out.prop((Object)"expirationTime", tokenInfo.getSpecificClaim("exp"));
            }
            out.endProps();
        }
        out.startProps("Encryption Information");
        SecureRandom sr = sRand;
        out.prop((Object)"SecureRandom", (Object)BRpkAuthenticator.safeString(sr, "SecureRandom"));
        if (sr != null) {
            out.prop((Object)"SR algorithm", (Object)sr.getAlgorithm());
        }
        if ((publicKey = this.keyHelper.getPublicKey()) != null) {
            BRpkAuthenticator.spy(publicKey, out);
        }
        out.endProps();
    }

    static String safeString(Object o, String message) {
        return o == null ? "null" : (message != null ? message : o.getClass().toString());
    }

    private static void spy(PublicKey pubk, SpyWriter out) {
        out.prop((Object)"Public Key", (Object)Base64.getEncoder().encodeToString(pubk.getEncoded()));
        out.prop((Object)"Key algorithm", (Object)pubk.getAlgorithm());
        out.prop((Object)"Key format", (Object)pubk.getFormat());
    }

    private static /* synthetic */ String lambda$getConnectionInfo$9(BPassword password) {
        return password == null ? null : password.getValue();
    }

    static {
        try {
            sRand = SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException ex) {
            sRand = new SecureRandom();
            log.log(Level.CONFIG, ex.getMessage(), log.isLoggable(Level.FINE) ? ex : null);
        }
        PASSWORD_PATTERN = Pattern.compile("\"Password\":\\s*\"[^\"]*\"");
        HSM_KEY_STORE_NOT_FOUND = String.format(KEY_STORE_NOT_FOUND, "User");
        USER_KEY_STORE_NOT_FOUND = String.format(KEY_STORE_NOT_FOUND, "HSM");
        jwtExpirationClockSkew = Long.getLong("niagara.cloud.jwt.expiration.skew", BRelTime.HOUR.getSeconds());
    }

    public static enum AuthenticationType {
        INITIAL,
        RENEWAL;

    }

    public static final class ConnectionInfo {
        private final String userName;
        private final BPassword password;
        private final String path;

        public ConnectionInfo(String userName, BPassword password, String path) {
            this.userName = userName;
            this.password = password;
            this.path = path;
        }

        public String getUserName() {
            return this.userName;
        }

        public BPassword getPassword() {
            return this.password;
        }

        public String getPasswordValue() {
            return this.password == null ? null : this.password.getValue();
        }

        public String getPath() {
            return this.path;
        }
    }
}

