/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge;

import com.tridium.cloudLink.BAbstractCloudLinkHandlerFactory;
import com.tridium.cloudLink.azure.msg.AzureGetSasUrlHandler;
import com.tridium.cloudLink.azure.msg.AzureUpdateFileUploadStatusHandler;
import com.tridium.cloudLink.forge.msg.ForgeFileSendHistoriesBulkHandler;
import com.tridium.cloudLink.forge.msg.ForgeFileSendModelCloseHandler;
import com.tridium.cloudLink.forge.msg.ForgeFileSendModelEntitiesHandler;
import com.tridium.cloudLink.forge.msg.ForgeHttpGetHistoriesHandler;
import com.tridium.cloudLink.forge.util.ForgeUtils;
import com.tridium.cloudLink.msg.IGetHistoriesHandler;
import com.tridium.cloudLink.msg.ISendBulkHistoriesHandler;
import com.tridium.cloudLink.msg.ISendModelCloseHandler;
import com.tridium.cloudLink.msg.ISendModelEntitiesHandler;
import com.tridium.cloudLink.transport.HttpRequestMessage;
import com.tridium.cloudLink.transport.HttpResponseMessage;
import com.tridium.cloudLink.transport.IGetMessageKey;
import com.tridium.cloudLink.transport.IMessage;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BForgeHttpHandlerFactory
extends BAbstractCloudLinkHandlerFactory {
    public static final Type TYPE = Sys.loadType(BForgeHttpHandlerFactory.class);
    protected static final Logger log = Logger.getLogger("cloudLink.forge.msg");

    public Type getType() {
        return TYPE;
    }

    public String getPlatformType() {
        return "Forge";
    }

    public String getTransportType() {
        return "HTTP";
    }

    public IGetMessageKey<? extends IMessage> getMessageKeyHandler() {
        return new IGetMessageKey<HttpRequestMessage>(){

            public String getKey(HttpRequestMessage message) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public IGetMessageKey<? extends IMessage> getMessageCorrelationIdHandler() {
        return this.getMessageKeyHandler();
    }

    public Consumer<IMessage> getMessageLogger() {
        return message -> {
            if (!log.isLoggable(Level.FINEST)) {
                return;
            }
            StringBuilder logMessageBldr = new StringBuilder("Received HTTP message, ");
            if (message instanceof HttpResponseMessage) {
                logMessageBldr.append("status code: ");
                logMessageBldr.append(((HttpResponseMessage)message).getStatusCode());
                logMessageBldr.append(", ");
            }
            logMessageBldr.append("headers: ");
            logMessageBldr.append(ForgeUtils.makeHeaderString(message.getMetadata()));
            logMessageBldr.append("payload not logged");
            log.finest(logMessageBldr.toString());
        };
    }

    protected void registerHandlers() {
        this.messageHandlerTypes.put(AzureGetSasUrlHandler.class, AzureGetSasUrlHandler.class);
        this.messageHandlerTypes.put(AzureUpdateFileUploadStatusHandler.class, AzureUpdateFileUploadStatusHandler.class);
        this.messageHandlerTypes.put(IGetHistoriesHandler.class, ForgeHttpGetHistoriesHandler.class);
        this.messageHandlerTypes.put(ISendBulkHistoriesHandler.class, ForgeFileSendHistoriesBulkHandler.class);
        this.messageHandlerTypes.put(ISendModelCloseHandler.class, ForgeFileSendModelCloseHandler.class);
        this.messageHandlerTypes.put(ISendModelEntitiesHandler.class, ForgeFileSendModelEntitiesHandler.class);
    }
}

