/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.ncs.msg;

import com.tridium.cloudLink.auth.BFederatedIdentityAuthenticator;
import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.file.IFileUploadInfo;
import com.tridium.cloudLink.msg.IStartFileUploadHandler;
import com.tridium.cloudLink.ncs.channel.BNcsBackupChannelConfig;
import com.tridium.cloudLink.ncs.msg.NcsHttpStartBackupResult;
import com.tridium.cloudLink.transport.HttpRequestMessage;
import com.tridium.cloudLink.transport.HttpResponseMessage;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.cloudLink.transport.IMessageResponse;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.security.BCertificateAliasAndPassword;

public class NcsHttpStartBackupHandler
implements IStartFileUploadHandler {
    private final String host;
    private final BCertificateAliasAndPassword certAliasAndPass;
    private final Map<String, Object> requestProps;
    private final BNcsBackupChannelConfig config;
    private static final Logger log = Logger.getLogger("cloudLink.channel.backup");

    public NcsHttpStartBackupHandler(BChannelConfig channelConfig) {
        this.config = (BNcsBackupChannelConfig)channelConfig;
        this.host = ((BFederatedIdentityAuthenticator)this.config.getAuthenticator(IStartFileUploadHandler.getOperationId())).getRegistrationHost();
        this.requestProps = this.config.getRequestProps();
        this.certAliasAndPass = (BCertificateAliasAndPassword)this.requestProps.remove("certAliasAndPassword");
    }

    public int add(String value) {
        return 0;
    }

    public CompletableFuture<IMessageResponse> getFuture(CompletableFuture<IFileUploadInfo> channelFuture, IMessage message) {
        CompletableFuture<IMessageResponse> reqFuture = new CompletableFuture<IMessageResponse>();
        reqFuture.whenComplete((resp, err) -> {
            if (err != null) {
                channelFuture.completeExceptionally((Throwable)err);
            } else {
                try (HttpResponseMessage response = (HttpResponseMessage)resp;){
                    NcsHttpStartBackupResult startBackupResult = new NcsHttpStartBackupResult(response.getBodyAsString());
                    channelFuture.complete(startBackupResult);
                }
                catch (Exception ex) {
                    channelFuture.completeExceptionally(ex);
                }
            }
        });
        return reqFuture;
    }

    public IMessage toMessage(boolean isFinal) {
        URL url = null;
        try {
            url = new URI("https://" + this.host + "/api/v1/recover/backups").toURL();
        }
        catch (MalformedURLException | URISyntaxException ex) {
            log.log(Level.WARNING, "Unable to build URL for start backup request", log.isLoggable(Level.FINE) ? ex : null);
        }
        HttpRequestMessage msg = new HttpRequestMessage.HttpRequestMessageBuilder(HttpRequestMessage.HttpMethod.POST, url, this.requestProps).certificateAliasAndPassword(this.certAliasAndPass).build();
        return msg;
    }
}

