/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.ncs.msg;

import com.tridium.cloudLink.auth.BFederatedIdentityAuthenticator;
import com.tridium.cloudLink.azure.file.AzureFileUploadStatus;
import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.file.IFileUploadStatus;
import com.tridium.cloudLink.msg.IEndFileUploadHandler;
import com.tridium.cloudLink.ncs.channel.BNcsBackupChannelConfig;
import com.tridium.cloudLink.transport.HttpRequestMessage;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.cloudLink.transport.IMessageResponse;
import com.tridium.json.JSONWriter;
import com.tridium.json.quick.QuickJSONWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.security.BCertificateAliasAndPassword;

public class NcsHttpEndBackupHandler
implements IEndFileUploadHandler {
    private String backupID;
    private StringWriter stringWriter;
    private JSONWriter jsonSerializer;
    private final String host;
    private final BCertificateAliasAndPassword certAliasAndPass;
    private final Map<String, Object> requestProps;
    private final BNcsBackupChannelConfig config;
    private static final int MSG_END_SIZE = 1;
    private static final Logger log = Logger.getLogger("cloudLink.channel.backup");

    public NcsHttpEndBackupHandler(BChannelConfig channelConfig) {
        this.config = (BNcsBackupChannelConfig)channelConfig;
        this.host = ((BFederatedIdentityAuthenticator)this.config.getAuthenticator(IEndFileUploadHandler.getOperationId())).getRegistrationHost();
        this.requestProps = this.config.getRequestProps();
        this.certAliasAndPass = (BCertificateAliasAndPassword)this.requestProps.remove("certAliasAndPassword");
        this.initializeMessage();
    }

    public int add(IFileUploadStatus value) {
        this.backupID = value.getInfo().getCorrelationId();
        if (value instanceof AzureFileUploadStatus) {
            Map backupMetadata = ((AzureFileUploadStatus)value).getRequest().getMetadata();
            this.jsonSerializer.key("initiator").value(backupMetadata.get("initiator"));
            this.jsonSerializer.key("notes").value(backupMetadata.get("notes"));
            this.jsonSerializer.key("algorithm").value(backupMetadata.get("algorithm"));
        }
        return this.stringWriter.getBuffer().length() + 1;
    }

    public CompletableFuture<IMessageResponse> getFuture(CompletableFuture<Void> channelFuture, IMessage message) {
        CompletableFuture<IMessageResponse> reqFuture = new CompletableFuture<IMessageResponse>();
        reqFuture.whenComplete((resp, err) -> {
            if (err != null) {
                channelFuture.completeExceptionally((Throwable)err);
            } else {
                channelFuture.complete(null);
            }
        });
        return reqFuture;
    }

    public IMessage toMessage(boolean isFinal) {
        URL url = null;
        try {
            url = new URI("https://" + this.host + "/api/v1/recover/backups" + '/' + this.backupID).toURL();
        }
        catch (MalformedURLException | URISyntaxException ex) {
            log.log(Level.WARNING, "Unable to build URL for end backup request", log.isLoggable(Level.FINE) ? ex : null);
        }
        this.jsonSerializer.endObject();
        this.stringWriter.flush();
        HttpRequestMessage msg = new HttpRequestMessage.HttpRequestMessageBuilder(HttpRequestMessage.HttpMethod.POST, url, this.requestProps).mimeType("application/json").body(this.stringWriter.toString()).certificateAliasAndPassword(this.certAliasAndPass).build();
        return msg;
    }

    protected void initializeMessage() {
        this.stringWriter = new StringWriter();
        this.jsonSerializer = QuickJSONWriter.make((Appendable)this.stringWriter);
        this.jsonSerializer.object();
    }
}

