/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.clUtils.job;

import com.tridium.clUtils.BModelDiscoverer;
import com.tridium.clUtils.BModelDiscoveryService;
import com.tridium.util.CompUtil;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import java.util.zip.ZipOutputStream;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.job.BJob;
import javax.baja.job.BSimpleJob;
import javax.baja.job.JobCancelException;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
public class BModelDiscoveryJob
extends BSimpleJob {
    public static final Type TYPE = Sys.loadType(BModelDiscoveryJob.class);
    protected static final Lexicon lex = Lexicon.make((String)"clUtils");
    BModelDiscoveryService service;

    public Type getType() {
        return TYPE;
    }

    public BModelDiscoveryJob() {
        try {
            this.service = (BModelDiscoveryService)Sys.getService((Type)BModelDiscoveryService.TYPE);
        }
        catch (ServiceNotFoundException e) {
            this.service = null;
        }
    }

    public BModelDiscoveryJob(BModelDiscoveryService service) {
        this.service = service;
    }

    public void checkCancel() {
        if (!this.isAlive()) {
            this.log().message(lex.getText("modelDiscovery.canceled"));
            throw new JobCancelException(lex.getText("modelDiscovery.canceled"));
        }
    }

    public void progress(int progres) {
        int progress = this.getProgress();
        if (progres > progress) {
            super.progress(progres);
        } else {
            this.heartbeat();
        }
    }

    public void progress(int count, int size, int start, int end) {
        int prog = start + (int)((float)count / (float)size * (float)(end - start));
        this.progress(prog);
    }

    public void run(Context cx) throws Exception {
        Objects.requireNonNull(this.service, "Model Discovery Service not configured");
        this.discoverModelInfo(cx);
        this.service.fireModelDiscoveryComplete((BValue)BBoolean.TRUE);
    }

    public ZipOutputStream createModelFile() throws IOException {
        Objects.requireNonNull(this.service, "Model Discovery Service not configured");
        BOrd fileOrd = this.service.getModelFile();
        BIFile modelFile = BFileSystem.INSTANCE.makeFile((FilePath)fileOrd.parse()[0]);
        OutputStream fOut = modelFile.getOutputStream();
        ZipOutputStream zOut = new ZipOutputStream(new BufferedOutputStream(fOut));
        return zOut;
    }

    public void discoverModelInfo(Context cx) throws Exception {
        BDeviceNetwork[] networks = (BDeviceNetwork[])CompUtil.getDescendants((BComponent)Sys.getStation(), BDeviceNetwork.class);
        int netslen = networks.length;
        int netsdone = 0;
        try (ZipOutputStream out = this.createModelFile();){
            for (BDeviceNetwork network : networks) {
                this.checkCancel();
                this.progress(netsdone, netslen, 0, 100);
                BDevice[] devices = (BDevice[])CompUtil.getDescendants((BComponent)network, BDevice.class);
                boolean discoveredByNetwork = false;
                AgentList netAgents = network.getAgents().filter(AgentFilter.is((Type)BModelDiscoverer.TYPE));
                if (netAgents.size() > 0) {
                    AgentInfo netInfo = netAgents.getDefault();
                    BModelDiscoverer netDiscoverer = (BModelDiscoverer)netInfo.getInstance().as(BModelDiscoverer.class);
                    netDiscoverer.addNetworkEntry(out, network, devices);
                    try {
                        discoveredByNetwork = netDiscoverer.discoverModelInfo(out, network, (BJob)this);
                    }
                    catch (Exception modelDiscoveryException) {
                        if (modelDiscoveryException instanceof JobCancelException) {
                            this.log().message(lex.getText("modelDiscovery.canceled"));
                            throw modelDiscoveryException;
                        }
                        this.log().message(lex.getText("modelDiscovery.network.exception", new Object[]{network.getName(), network.getType(), modelDiscoveryException}));
                    }
                } else {
                    this.log().message(lex.getText("modelDiscovery.network.noDiscoverer", new Object[]{network.getName(), network.getTypeDisplayName(cx)}));
                }
                if (discoveredByNetwork) {
                    this.log().success(lex.getText("modelDiscovery.network.success", new Object[]{network.getName()}));
                } else {
                    this.log().message(lex.getText("modelDiscovery.network.failure", new Object[]{network.getName()}));
                    int devslen = devices.length;
                    int devsdone = 0;
                    for (BDevice device : devices) {
                        block28: {
                            this.checkCancel();
                            this.progress(devsdone, devslen, (int)((double)netsdone * 100.0 / (double)netslen), (int)((double)(netsdone + 1) * 100.0 / (double)netslen));
                            AgentList devAgents = device.getAgents().filter(AgentFilter.is((Type)BModelDiscoverer.TYPE));
                            if (devAgents.size() > 0) {
                                AgentInfo devInfo = devAgents.getDefault();
                                BModelDiscoverer devDiscoverer = (BModelDiscoverer)devInfo.getInstance().as(BModelDiscoverer.class);
                                devDiscoverer.addDeviceEntry(out, device);
                                try {
                                    boolean discoveredByDevice = devDiscoverer.discoverModelInfo(out, device, (BJob)this);
                                    if (discoveredByDevice) {
                                        this.log().success(lex.getText("modelDiscovery.device.success", new Object[]{device.getName()}));
                                        break block28;
                                    }
                                    this.log().message(lex.getText("modelDiscovery.device.failure", new Object[]{device.getName()}));
                                }
                                catch (Exception modelDiscoveryException) {
                                    this.log().failed(lex.getText("modelDiscovery.device.exception", new Object[]{device.getName(), device.getType(), modelDiscoveryException}), (Throwable)modelDiscoveryException);
                                }
                            } else {
                                this.log().failed(lex.getText("modelDiscovery.device.noDiscoverer", new Object[]{device.getName(), device.getTypeDisplayName(cx)}));
                            }
                        }
                        ++devsdone;
                    }
                }
                ++netsdone;
            }
        }
        catch (Exception e) {
            this.log().failed(lex.getText("modelDiscovery.exception"), (Throwable)e);
        }
    }
}

