/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.clUtils;

import com.tridium.clUtils.CloudIdException;
import com.tridium.clUtils.ModelDiscoveryConstants;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComplex;
import javax.baja.sys.BIObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.tag.BIEntity;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Tag;
import javax.baja.tag.Tags;

public final class DiscoveryTagUtils {
    public static final Predicate<BValue> filterByExcludedTag = v -> {
        if (v instanceof Entity) {
            Tags tags = ((Entity)v).tags();
            return tags.contains(ModelDiscoveryConstants.EXCLUDED_TAG_ID);
        }
        return false;
    };
    private static final Logger log = Logger.getLogger("cloudLink.modelDiscovery");

    private DiscoveryTagUtils() {
    }

    public static Optional<BIDataValue> getTag(BIEntity entity, Id tagId) {
        if (entity == null) {
            return Optional.empty();
        }
        Tags tags = entity.tags();
        if (tags == null || !tags.contains(tagId)) {
            return Optional.empty();
        }
        return tags.get(tagId);
    }

    public static Optional<BIDataValue> getCloudId(BIEntity entity) {
        return DiscoveryTagUtils.getTag(entity, ModelDiscoveryConstants.ID_CLOUD_ID);
    }

    public static boolean hasTag(BIEntity entity, Id tagId) {
        return DiscoveryTagUtils.getTag(entity, tagId).isPresent();
    }

    public static boolean hasCloudId(BIEntity entity) {
        return DiscoveryTagUtils.getCloudId(entity).isPresent();
    }

    public static boolean addTag(BIEntity entity, Id tagId, BIDataValue tagValue) {
        if (entity == null) {
            return false;
        }
        try {
            if (!DiscoveryTagUtils.hasTag(entity, tagId)) {
                Tags tags = entity.tags();
                Tag tag = new Tag(tagId, tagValue);
                tags.set(tag);
                return true;
            }
        }
        catch (Exception ex) {
            log.log(Level.INFO, String.format("Error adding tag %s to entity %s: %s", tagId.toString(), entity, ex.getMessage()), log.isLoggable(Level.FINE) ? ex : null);
            return false;
        }
        return false;
    }

    public static Optional<String> getCloudIdString(BIObject object) {
        Optional<BIDataValue> cloudId;
        if (object instanceof BIEntity && (cloudId = DiscoveryTagUtils.getCloudId((BIEntity)object)).isPresent()) {
            try {
                return Optional.of(cloudId.get().encodeToString());
            }
            catch (IOException ex) {
                log.log(Level.INFO, "Error getting cloud id value", log.isLoggable(Level.FINE) ? ex : null);
            }
        }
        return Optional.empty();
    }

    public static String getOrAddCloudId(BIEntity entity) {
        BComplex complex;
        Property cloudIdProp;
        Objects.requireNonNull(entity);
        if (DiscoveryTagUtils.hasCloudId(entity)) {
            return DiscoveryTagUtils.getCloudIdString((BIObject)entity).orElseThrow(DiscoveryTagUtils.makeCloudIdExceptionSupplier(entity));
        }
        String uuid = UUID.randomUUID().toString();
        if (!DiscoveryTagUtils.addTag(entity, ModelDiscoveryConstants.ID_CLOUD_ID, (BIDataValue)BString.make((String)uuid))) {
            throw DiscoveryTagUtils.makeCloudIdExceptionSupplier(entity).get();
        }
        if (entity instanceof BComplex && (cloudIdProp = (complex = ((BComplex)entity).asComplex()).getProperty(ModelDiscoveryConstants.ESCAPED_CLOUD_ID_TAG)) != null) {
            complex.setFlags((Slot)cloudIdProp, 24577);
        }
        return uuid;
    }

    protected static Supplier<CloudIdException> makeCloudIdExceptionSupplier(BIEntity entity) {
        return () -> {
            Optional ordOpt = entity.getOrdToEntity();
            String msg = "nc:cloudId tag was not found";
            if (ordOpt.isPresent()) {
                msg = msg + " on entity: " + ((BOrd)ordOpt.get()).encodeToString();
            }
            return new CloudIdException(msg);
        };
    }
}

