/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Ashutosh Chaturvedi
 */

/**
 * API Status: **Private**
 * @module nmodule/cloudLink/rc/history/model/CloudHistoryExportMgrModel
 */
define(['baja!', 'lex!cloudLink', 'baja!cloudLink:CloudHistoryExportConfig', 'nmodule/webEditors/rc/wb/table/model/Column', 'nmodule/webEditors/rc/wb/mgr/model/MgrModel', 'nmodule/webEditors/rc/wb/mgr/MgrTypeInfo', 'nmodule/webEditors/rc/wb/mgr/model/columns/IconMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/NameMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn', 'nmodule/webEditors/rc/wb/table/model/source/ContainerComponentSource'], function (baja, lexs, types, Column, MgrModel, MgrTypeInfo, IconMgrColumn, NameMgrColumn, PropertyMgrColumn, ContainerComponentSource) {
  'use strict';

  var CLOUD_CONFIG_EXPORT_OBJECT_TYPE = baja.lt('cloudLink:CloudHistoryExportConfig'),
      cloudLinkLex = lexs[0],
      EDITABLE = Column.flags.EDITABLE,
      UNSEEN = Column.flags.UNSEEN;

  function makeColumns() {
    return [new IconMgrColumn(), new NameMgrColumn({
      flags: EDITABLE
    }), new PropertyMgrColumn('enabled', {
      displayName: cloudLinkLex.get('cloudHistoryExportConfig.enabled'),
      flags: EDITABLE,
      type: CLOUD_CONFIG_EXPORT_OBJECT_TYPE
    }), new PropertyMgrColumn('executionTime', {
      displayName: cloudLinkLex.get('cloudHistoryExportConfig.executionTime'),
      flags: EDITABLE,
      type: CLOUD_CONFIG_EXPORT_OBJECT_TYPE
    }), new PropertyMgrColumn('lastSuccess', {
      displayName: cloudLinkLex.get('cloudHistoryExportConfig.lastSuccess'),
      type: CLOUD_CONFIG_EXPORT_OBJECT_TYPE
    }), new PropertyMgrColumn('lastFailure', {
      displayName: cloudLinkLex.get('cloudHistoryExportConfig.lastFailure'),
      type: CLOUD_CONFIG_EXPORT_OBJECT_TYPE
    }), new PropertyMgrColumn('faultCause', {
      displayName: cloudLinkLex.get('cloudHistoryExportConfig.faultCause'),
      type: CLOUD_CONFIG_EXPORT_OBJECT_TYPE
    }), new PropertyMgrColumn('lastAttempt', {
      displayName: cloudLinkLex.get('cloudHistoryExportConfig.lastAttempt'),
      flags: UNSEEN,
      type: CLOUD_CONFIG_EXPORT_OBJECT_TYPE
    }), new PropertyMgrColumn('status', {
      displayName: cloudLinkLex.get('cloudHistoryExportConfig.status'),
      flags: UNSEEN,
      type: CLOUD_CONFIG_EXPORT_OBJECT_TYPE
    })];
  }
  /**
   * @private
   * @exports nmodule/cloudLink/rc/history/model/CloudHistoryExportMgrModel
   */


  var exports = {};
  /**
   * Create a `CloudHistoryExportMgrModel` instance with the appropriate columns.
   * Filter the rows to allow only CloudHistoryExportConfig type to get displayed.
   * @param {baja.Component} component component being loaded into the manager
   * @returns {Promise.<module:nmodule/webEditors/rc/wb/mgr/model/MgrModel>}
   */

  exports.make = function (component) {
    return MgrTypeInfo.make(['cloudLink:CloudHistoryExportConfig']).then(function (newTypes) {
      return new MgrModel({
        columns: makeColumns(),
        newTypes: newTypes,
        componentSource: new ContainerComponentSource({
          container: component,
          filter: [CLOUD_CONFIG_EXPORT_OBJECT_TYPE]
        })
      });
    });
  };

  return exports;
});
