/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.ncs.msg;

import com.tridium.cloudLink.auth.BFederatedIdentityAuthenticator;
import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.msg.IGetModelIngestionStatusHandler;
import com.tridium.cloudLink.msg.IModelIngestStatusResult;
import com.tridium.cloudLink.ncs.channel.BNcsModelChannelConfig;
import com.tridium.cloudLink.ncs.msg.NcsModelIngestStatusResult;
import com.tridium.cloudLink.transport.HttpRequestMessage;
import com.tridium.cloudLink.transport.HttpResponseMessage;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.cloudLink.transport.IMessageResponse;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NcsHttpGetModelIngestionStatusHandler
implements IGetModelIngestionStatusHandler {
    private String deviceId;
    private final String host;
    private final String certAlias;
    private final Map<String, Object> requestProps;
    private final BNcsModelChannelConfig config;
    private static final Logger log = Logger.getLogger("cloudLink.channel.model");

    public NcsHttpGetModelIngestionStatusHandler(BChannelConfig channelConfig) {
        this.config = (BNcsModelChannelConfig)channelConfig;
        this.host = ((BFederatedIdentityAuthenticator)this.config.getAuthenticator(IGetModelIngestionStatusHandler.getOperationId())).getRegistrationHost();
        this.requestProps = this.config.getRequestProps();
        this.certAlias = (String)this.requestProps.remove("cert-alias");
    }

    public int add(String deviceId) {
        this.deviceId = deviceId;
        return 0;
    }

    public CompletableFuture<IMessageResponse> getFuture(CompletableFuture<IModelIngestStatusResult> channelFuture, IMessage message) {
        CompletableFuture<IMessageResponse> reqFuture = new CompletableFuture<IMessageResponse>();
        reqFuture.whenComplete((resp, err) -> {
            if (err != null) {
                channelFuture.completeExceptionally((Throwable)err);
            } else {
                try (HttpResponseMessage response = (HttpResponseMessage)resp;){
                    NcsModelIngestStatusResult result = new NcsModelIngestStatusResult(response.getBodyAsString());
                    channelFuture.complete(result);
                }
                catch (Exception exc) {
                    channelFuture.completeExceptionally(exc);
                }
            }
        });
        return reqFuture;
    }

    public IMessage toMessage(boolean isFinal) {
        URL url = null;
        try {
            url = new URI("https://" + this.host + "/api/v1/entitymodel/ingestion/status" + '/' + this.deviceId + "?iteration=" + this.config.getExportId()).toURL();
        }
        catch (MalformedURLException | URISyntaxException ex) {
            log.log(Level.INFO, "Unable to build URL for get model ingestion status request", log.isLoggable(Level.FINE) ? ex : null);
        }
        HttpRequestMessage msg = new HttpRequestMessage.HttpRequestMessageBuilder(HttpRequestMessage.HttpMethod.GET, url, this.requestProps).mimeType("application/json").certAlias(this.certAlias).build();
        return msg;
    }
}

