/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.azure.msg;

import com.tridium.cloudLink.CloudLinkUtils;
import com.tridium.cloudLink.azure.file.AzureFileUploadInfo;
import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.file.IFileUploadInfo;
import com.tridium.cloudLink.file.IUploadChannelConfig;
import com.tridium.cloudLink.msg.ISensitiveMessageBuilder;
import com.tridium.cloudLink.msg.IStartFileUploadHandler;
import com.tridium.cloudLink.transport.HttpRequestMessage;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.cloudLink.transport.IMessageResponse;
import com.tridium.cloudLink.util.IValueWrapper;
import com.tridium.cloudLink.util.PasswordWrapper;
import com.tridium.cloudLink.util.StringWrapper;
import com.tridium.json.JSONObject;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AzureGetSasUrlHandler
implements IStartFileUploadHandler,
ISensitiveMessageBuilder {
    private final BChannelConfig config;
    private String blobName;
    private Map<String, IValueWrapper<?>> connectionInfo;
    protected static final Logger log = Logger.getLogger("cloudLink.file.upload");
    private static final String AZURE_FILE_UPLOAD_URL_TEMPLATE = "https://%s/devices/%s/files?api-version=2020-03-13";
    private static final String AZURE_FILE_UPLOAD_BODY_TEMPLATE = "{\"blobName\":\"%s\"}";

    public AzureGetSasUrlHandler(BChannelConfig config) {
        if (!(config instanceof IUploadChannelConfig)) {
            log.info("unable to get authentication info identifier for file upload");
            throw new RuntimeException("unable to get authentication info identifier for file upload");
        }
        this.config = config;
    }

    public void loadSensitives() {
        this.connectionInfo = this.config.getAuthenticator(IStartFileUploadHandler.getOperationId()).getConnectionInfo(((IUploadChannelConfig)this.config).getConnectionInfoName());
    }

    public IMessage toMessage(boolean isFinal) {
        HttpRequestMessage message;
        String uploadEndpoint = "";
        if (this.connectionInfo == null || this.connectionInfo.isEmpty()) {
            throw new RuntimeException("Connection information unavailable");
        }
        try {
            uploadEndpoint = String.format(AZURE_FILE_UPLOAD_URL_TEMPLATE, StringWrapper.getString(this.connectionInfo.get("hostName")), StringWrapper.getString(this.connectionInfo.get("id")));
            String token = AccessController.doPrivileged(() -> PasswordWrapper.getPasswordValue(this.connectionInfo.get("token")));
            Map requestHeaders = CloudLinkUtils.makeSasTokenAuthHeaderMap((String)token);
            String requestBody = String.format(AZURE_FILE_UPLOAD_BODY_TEMPLATE, this.blobName);
            message = new HttpRequestMessage.HttpRequestMessageBuilder(HttpRequestMessage.HttpMethod.POST, new URL(uploadEndpoint), requestHeaders).mimeType("application/json").body(requestBody).build();
            log.finest(() -> String.format("Http message - headers: %s, payload [%s]", requestHeaders, requestBody));
        }
        catch (MalformedURLException urlExcept) {
            String logMsg = "An error occurred while creating the URL " + uploadEndpoint;
            log.log(Level.WARNING, logMsg, log.isLoggable(Level.FINE) ? urlExcept : null);
            throw new RuntimeException(logMsg, urlExcept);
        }
        finally {
            this.connectionInfo = null;
        }
        return message;
    }

    public CompletableFuture<IMessageResponse> getFuture(CompletableFuture<IFileUploadInfo> fut, IMessage message) {
        CompletableFuture<IMessageResponse> future = new CompletableFuture<IMessageResponse>();
        future.whenComplete((resp, err) -> {
            if (err != null) {
                fut.completeExceptionally((Throwable)err);
            } else {
                AzureFileUploadInfo response = new AzureFileUploadInfo(new JSONObject(new String(resp.getPayload(), StandardCharsets.UTF_8)));
                fut.complete(response);
            }
        });
        return future;
    }

    public int add(String value) {
        this.blobName = value;
        return 0;
    }

    protected final void finalize() throws Throwable {
    }
}

