/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.azure.file;

import com.tridium.cloudLink.CloudLinkConstants;
import com.tridium.cloudLink.auth.BAbstractClientAuthenticator;
import com.tridium.cloudLink.azure.file.AzureCrc64;
import com.tridium.cloudLink.channel.BAbstractClientChannel;
import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.msg.IStartFileUploadHandler;
import com.tridium.cloudLink.transport.BAbstractTransport;
import com.tridium.cloudLink.transport.HttpRequestMessage;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.cloudLink.transport.IMessageResponse;
import com.tridium.cloudLink.transport.MessageWrapper;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BNumber;
import javax.baja.sys.BValue;

public class AzureBlobOutputStream
extends OutputStream {
    private int offsetInBlock;
    private boolean open;
    private final byte[] block;
    private final Map<String, Object> metadata;
    private final String contentType;
    private final String baseQueryString;
    private final String baseUrl;
    private final List<String> blockIds;
    private final List<CompletableFuture<IMessageResponse>> futures;
    private final BAbstractClientChannel channel;
    private static final int MIN_BLOCK_SIZE = 8192;
    private static final int MAX_BLOCK_SIZE = 0x10000000;
    private static final int DEFAULT_TIMEOUT = 5;
    private static final String CRC = "x-ms-content-crc64";
    private static final String DATE = "Date";
    private static final String METADATA_PREFIX = "x-ms-meta-";
    private static final String TIMEOUT_PROPERTY = "uploadTimeout";
    private static final String VERSION_HEADER = "x-ms-version";
    private static final String VERSION_VALUE = "2021-08-06";
    private static final Logger log = Logger.getLogger("cloudLink.file.upload");

    public AzureBlobOutputStream(String endpoint, int blockSize, String contentType, Map<String, Object> metadata, BAbstractClientChannel channel) {
        Objects.requireNonNull(endpoint, "endpoint cannot be null");
        Objects.requireNonNull(channel, "channel cannot be null");
        if (blockSize < 8192) {
            blockSize = 8192;
        } else if (blockSize > 0x10000000) {
            blockSize = 0x10000000;
        }
        this.channel = channel;
        this.block = new byte[blockSize];
        this.contentType = contentType;
        this.blockIds = new ArrayList<String>();
        this.futures = new ArrayList<CompletableFuture<IMessageResponse>>();
        int queryIndex = endpoint.indexOf(63);
        if (queryIndex > -1) {
            this.baseUrl = endpoint.substring(0, queryIndex);
            this.baseQueryString = endpoint.substring(queryIndex + 1);
        } else {
            this.baseUrl = endpoint;
            this.baseQueryString = "";
        }
        this.metadata = metadata != null ? Collections.unmodifiableMap(metadata) : Collections.emptyMap();
        this.open = true;
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        Objects.requireNonNull(buffer, "write buffer cannot be null");
        if (offset < 0 || offset > buffer.length || length < 0 || offset + length > buffer.length || offset + length < 0) {
            throw new IndexOutOfBoundsException(String.format("invalid length and offset combination, offset: %d, length: %d", offset, length));
        }
        if (length == 0) {
            return;
        }
        int start = offset;
        while (this.offsetInBlock + length - start > this.block.length) {
            System.arraycopy(buffer, start, this.block, this.offsetInBlock, this.block.length - this.offsetInBlock);
            start += this.block.length - this.offsetInBlock;
            this.offsetInBlock = this.block.length;
            this.sendBlock();
        }
        System.arraycopy(buffer, start, this.block, this.offsetInBlock, length - start);
        this.offsetInBlock += length - start;
    }

    @Override
    public void write(int b) throws IOException {
        this.block[this.offsetInBlock++] = (byte)b;
        if (this.offsetInBlock == this.block.length) {
            this.sendBlock();
        }
    }

    @Override
    public void close() {
        if (!this.open) {
            return;
        }
        if (this.offsetInBlock > 0) {
            this.sendBlock();
        }
        try {
            if (!this.futures.isEmpty()) {
                int timeout = 5;
                BValue timeoutValue = this.channel.getChannelConfig().get(TIMEOUT_PROPERTY);
                if (timeoutValue instanceof BNumber) {
                    timeout = ((BNumber)timeoutValue).getInt();
                }
                log.info(() -> String.format("Channel with name \"%s\" of type \"%s\" is uploading data to %s", this.channel.getName(), this.channel.getChannelType(), this.baseUrl));
                CompletableFuture.allOf(this.futures.toArray(CloudLinkConstants.EMPTY_COMP_FUTURE_ARRAY)).get(timeout, TimeUnit.MINUTES);
                this.commitIds().get(timeout, TimeUnit.MINUTES);
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException ex) {
            throw new RuntimeException(ex);
        }
        this.open = false;
    }

    private void sendBlock() {
        String blockId = Base64.getEncoder().encodeToString(UUID.randomUUID().toString().getBytes(StandardCharsets.UTF_8));
        this.blockIds.add(blockId);
        URL url = null;
        try {
            url = new URL(String.format("%s?comp=block&blockid=%s%s", this.baseUrl, blockId, !this.baseQueryString.isEmpty() ? '&' + this.baseQueryString : ""));
        }
        catch (MalformedURLException ex) {
            log.log(Level.WARNING, "Unable to build URL for file upload block message", log.isLoggable(Level.FINE) ? ex : null);
        }
        Map<String, Object> headers = this.makeHeaders(this.offsetInBlock, false);
        headers.put(CRC, Base64.getEncoder().encodeToString(AzureCrc64.hash(this.block, this.offsetInBlock)));
        BChannelConfig config = this.channel.getChannelConfig();
        BAbstractClientAuthenticator authenticator = config.getAuthenticator(IStartFileUploadHandler.getOperationId());
        HashMap props = new HashMap();
        AccessController.doPrivileged(() -> {
            authenticator.addMessageHandlerProperties(config.getTransport(IStartFileUploadHandler.getOperationId()), null, (Map)props);
            return null;
        });
        HttpRequestMessage message = new HttpRequestMessage.HttpRequestMessageBuilder(HttpRequestMessage.HttpMethod.PUT, url, headers).mimeType(this.contentType).body(this.block).certAlias((String)props.get("cert-alias")).build();
        this.offsetInBlock = 0;
        BAbstractTransport transport = config.getTransport(IStartFileUploadHandler.getOperationId());
        CompletableFuture future = new CompletableFuture();
        MessageWrapper wrapper = new MessageWrapper((IMessage)message, future, transport.getMessageRetries());
        AccessController.doPrivileged(() -> {
            config.blockingEnqueueMessage(IStartFileUploadHandler.getOperationId(), wrapper);
            return null;
        });
        this.futures.add(future);
        transport.notifyPending();
    }

    private Map<String, Object> makeHeaders(int contentLength, boolean addMetadata) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put(DATE, BAbsTime.now().encodeToString());
        headers.put(VERSION_HEADER, VERSION_VALUE);
        headers.put("Content-Length", contentLength);
        if (addMetadata) {
            for (Map.Entry<String, Object> entry : this.metadata.entrySet()) {
                headers.put(METADATA_PREFIX + entry.getKey(), this.encodeMetadata(entry.getValue().toString()));
            }
        }
        return headers;
    }

    protected String encodeMetadata(String value) {
        boolean changed = false;
        StringBuilder out = new StringBuilder(value.length());
        for (int lcv = 0; lcv < value.length(); ++lcv) {
            char character = value.charAt(lcv);
            if (character < '\u0080') {
                out.append(character);
                continue;
            }
            changed = true;
        }
        return changed ? out.toString() : value;
    }

    private CompletableFuture<IMessageResponse> commitIds() {
        StringBuilder stringBuilder = new StringBuilder("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<BlockList>\n");
        for (String blockId : this.blockIds) {
            stringBuilder.append("<Latest>");
            stringBuilder.append(blockId);
            stringBuilder.append("</Latest>\n");
        }
        stringBuilder.append("</BlockList>\n");
        URL url = null;
        try {
            url = new URL(String.format("%s?comp=blocklist%s", this.baseUrl, !this.baseQueryString.isEmpty() ? '&' + this.baseQueryString : ""));
        }
        catch (MalformedURLException ex) {
            log.log(Level.WARNING, "Unable to build URL for file upload commit blocks message", log.isLoggable(Level.FINE) ? ex : null);
        }
        byte[] body = stringBuilder.toString().getBytes(StandardCharsets.UTF_8);
        BChannelConfig config = this.channel.getChannelConfig();
        BAbstractClientAuthenticator authenticator = config.getAuthenticator(IStartFileUploadHandler.getOperationId());
        HashMap props = new HashMap();
        AccessController.doPrivileged(() -> {
            authenticator.addMessageHandlerProperties(config.getTransport(IStartFileUploadHandler.getOperationId()), null, (Map)props);
            return null;
        });
        HttpRequestMessage message = new HttpRequestMessage.HttpRequestMessageBuilder(HttpRequestMessage.HttpMethod.PUT, url, this.makeHeaders(body.length, true)).mimeType("application/xml").body(body).certAlias((String)props.get("cert-alias")).build();
        BAbstractTransport transport = config.getTransport(IStartFileUploadHandler.getOperationId());
        CompletableFuture<IMessageResponse> future = new CompletableFuture<IMessageResponse>();
        MessageWrapper wrapper = new MessageWrapper((IMessage)message, future, transport.getMessageRetries());
        AccessController.doPrivileged(() -> {
            config.enqueueMessage(IStartFileUploadHandler.getOperationId(), wrapper);
            return null;
        });
        transport.notifyPending();
        return future;
    }
}

