/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.azure.file;

import com.tridium.cloudLink.azure.file.AzureBlobOutputStream;
import com.tridium.cloudLink.azure.file.AzureFileUploadStatus;
import com.tridium.cloudLink.channel.BAbstractClientChannel;
import com.tridium.cloudLink.file.FileUploadRequest;
import com.tridium.cloudLink.file.FileUploader;
import com.tridium.cloudLink.file.IFileUploadInfo;
import com.tridium.cloudLink.file.IFileUploadStatus;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import javax.baja.sys.BNumber;
import javax.baja.sys.BValue;

public abstract class AzureBlobFileUploader
extends FileUploader {
    private static final String BLOCK_SIZE_PROPERTY = "uploadBlockSize";
    private static final int DEFAULT_BLOCK_SIZE = 0x400000;

    protected AzureBlobFileUploader(BAbstractClientChannel channel) {
        super(channel);
    }

    protected CompletableFuture<IFileUploadStatus> doUpload(FileUploadRequest request, IFileUploadInfo uploadInfo) {
        CompletableFuture<IFileUploadStatus> statusFuture = new CompletableFuture<IFileUploadStatus>();
        AzureFileUploadStatus status = new AzureFileUploadStatus(request, uploadInfo);
        try {
            AccessController.doPrivileged(() -> {
                block14: {
                    try (AzureBlobOutputStream outStream = this.createUploadStream(uploadInfo, request.getMetadata(), this.channel);){
                        request.upload((OutputStream)outStream);
                        outStream.flush();
                    }
                    catch (RuntimeException ex) {
                        Throwable cause = ex.getCause();
                        log.log(Level.WARNING, "Error uploading file to Azure: " + (cause != null ? cause.getMessage() : ""), log.isLoggable(Level.FINE) ? cause : null);
                        statusFuture.completeExceptionally(ex);
                        if (!(cause instanceof InterruptedException)) break block14;
                        throw ex;
                    }
                }
                return null;
            });
        }
        catch (PrivilegedActionException ex) {
            log.log(Level.WARNING, String.format("Error uploading file %s.", request.getFileName()), log.isLoggable(Level.FINE) ? ex.getCause() : null);
            statusFuture.completeExceptionally(ex.getCause());
        }
        if (!statusFuture.isCompletedExceptionally()) {
            statusFuture.complete(status);
        }
        return statusFuture;
    }

    private AzureBlobOutputStream createUploadStream(IFileUploadInfo uploadInfo, Map<String, Object> metadata, BAbstractClientChannel channel) {
        int blockSize = 0x400000;
        BValue blockSizeValue = channel.getChannelConfig().get(BLOCK_SIZE_PROPERTY);
        if (blockSizeValue instanceof BNumber) {
            blockSize = ((BNumber)blockSizeValue).getInt();
        }
        return new AzureBlobOutputStream(uploadInfo.getUrl(), blockSize, "application/octet-stream", metadata, channel);
    }
}

