/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.niagararemoteclient;

import com.tridium.niagararemoteclient.NiagaraRemoteConstants;
import com.tridium.niagararemoteclient.NiagaraRemoteWebsocketAdapter;
import io.github.resilience4j.core.IntervalFunction;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.RetryRegistry;
import java.net.URI;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;

public class NiagaraRemoteClient {
    private static final Logger LOGGER = Logger.getLogger(NiagaraRemoteClient.class.getName());
    private final URI serverUri;
    private final WebSocketClient wsClient;
    private final ScheduledExecutorService executor;
    private final Retry retry;
    private final List<StatusCallback> statusCallbacks = new ArrayList<StatusCallback>();
    private final Map<String, String> requestHeaders;
    private final Map<Integer, Integer> portMapping;
    private final X509Certificate pinnedCertificate;
    private volatile State state = State.STOPPED;

    public NiagaraRemoteClient(WebSocketClient wsClient, String serverUrl, Map<String, String> requestHeaders, X509Certificate pinnedCertificate, Map<Integer, Integer> portMapping) throws Exception {
        this(wsClient, serverUrl, requestHeaders, pinnedCertificate, portMapping, NiagaraRemoteConstants.RETRY_INITIAL_INTERVAL, NiagaraRemoteConstants.RETRY_MAX_INTERVAL, 2.0, 0.9);
    }

    public NiagaraRemoteClient(WebSocketClient wsClient, String serverUrl, Map<String, String> requestHeaders, X509Certificate pinnedCertificate, Map<Integer, Integer> portMapping, Duration retryInitialInterval, Duration retryMaxInterval, double retryMultiplier, double retryRandomizationFactor) throws Exception {
        ThreadFactory threadFactory = r -> {
            Thread thread = Executors.defaultThreadFactory().newThread(r);
            thread.setName(NiagaraRemoteConstants.CONNECTOR_THREAD_NAME);
            return thread;
        };
        this.executor = Executors.newSingleThreadScheduledExecutor(threadFactory);
        this.retry = this.configureRemoteClientRetry(retryInitialInterval, retryMaxInterval, retryMultiplier, retryRandomizationFactor);
        if (portMapping == null) {
            LOGGER.warning("Port mapping not specified. All ports will be mapped to their default port without restrictions.");
            this.portMapping = null;
        } else {
            this.portMapping = Collections.unmodifiableMap(portMapping);
        }
        this.requestHeaders = requestHeaders;
        this.wsClient = wsClient;
        wsClient.setConnectTimeout(NiagaraRemoteConstants.CONNECT_TIMEOUT);
        wsClient.setMaxIdleTimeout(NiagaraRemoteConstants.IDLE_TIMEOUT);
        this.serverUri = new URI(serverUrl);
        this.pinnedCertificate = pinnedCertificate;
    }

    public void addStatusCallback(StatusCallback callback) {
        this.statusCallbacks.add(callback);
    }

    public synchronized void start() throws Exception {
        this.state = State.STARTING;
        this.wsClient.start();
        this.connectToClientWithRetryConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() {
        try {
            NiagaraRemoteClient niagaraRemoteClient = this;
            synchronized (niagaraRemoteClient) {
                if (!this.isRunning()) {
                    return;
                }
                NiagaraRemoteWebsocketAdapter websocket = new NiagaraRemoteWebsocketAdapter(this);
                ClientUpgradeRequest upgradeRequest = new ClientUpgradeRequest();
                if (this.requestHeaders != null) {
                    for (Map.Entry<String, String> header : this.requestHeaders.entrySet()) {
                        upgradeRequest.setHeader(header.getKey(), header.getValue());
                    }
                }
                this.wsClient.connect((Object)websocket, this.serverUri, upgradeRequest).get();
                LOGGER.fine("Niagara Remote client connected.");
                this.state = State.STARTED;
            }
            this.connectionSuccess();
        }
        catch (Exception e) {
            this.connectionFailed(e);
            LOGGER.log(Level.WARNING, "Error connecting Niagara Remote client. Scheduling retry.", LOGGER.isLoggable(Level.FINE) ? e : null);
            throw new RuntimeException("Niagara Remote client connection was not established.", e);
        }
    }

    public synchronized void stop() throws Exception {
        this.state = State.STOPPING;
        this.executor.shutdownNow();
        this.wsClient.stop();
        this.state = State.STOPPED;
    }

    public boolean isRunning() {
        return this.state == State.STARTED || this.state == State.STARTING;
    }

    protected byte[] getCertPublicKeyHashBytes() throws NoSuchAlgorithmException {
        LOGGER.fine("Hashing Public Key");
        byte[] publicKeyBytes = this.pinnedCertificate.getPublicKey().getEncoded();
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        return digest.digest(publicKeyBytes);
    }

    Map<Integer, Integer> getPortMapping() {
        return this.portMapping;
    }

    void websocketClosed(String reason) {
        if (this.isRunning()) {
            this.connectionClosed(reason);
            LOGGER.fine("Websocket closed. Retrying connection...");
            this.connectToClientWithRetryConfig();
        }
    }

    private Retry configureRemoteClientRetry(Duration retryInitialInterval, Duration retryMaxInterval, double retryMultiplier, double retryRandomizationFactor) {
        RetryConfig retryConfig = RetryConfig.custom().maxAttempts(Integer.MAX_VALUE).intervalFunction(IntervalFunction.ofExponentialRandomBackoff(retryInitialInterval, retryMultiplier, retryRandomizationFactor, retryMaxInterval)).retryOnException(e -> e instanceof Exception).build();
        RetryRegistry retryRegistry = RetryRegistry.of(retryConfig);
        return retryRegistry.retry("attemptNiagaraRemoteClientConnection");
    }

    private void connectToClientWithRetryConfig() {
        Supplier supplier = () -> CompletableFuture.runAsync(this::connect, this.executor);
        this.retry.executeCompletionStage(this.executor, supplier);
    }

    private void connectionFailed(Throwable throwable) {
        this.statusCallbacks.forEach(sc -> sc.connectionFailed(throwable));
    }

    private void connectionSuccess() {
        this.statusCallbacks.forEach(StatusCallback::connectionSuccess);
    }

    private void connectionClosed(String reason) {
        this.statusCallbacks.forEach(sc -> sc.connectionClosed(reason));
    }

    void sessionOpened(UUID sessionQualifier) {
        this.statusCallbacks.forEach(sc -> sc.sessionOpened(sessionQualifier));
    }

    private static enum State {
        STARTING,
        STARTED,
        STOPPING,
        STOPPED;

    }

    public static interface StatusCallback {
        default public void connectionSuccess() {
        }

        default public void connectionFailed(Throwable cause) {
        }

        default public void connectionClosed(String reason) {
        }

        default public void sessionOpened(UUID sessionQualifier) {
        }
    }
}

