/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.util;

import com.tridium.cloudLink.util.IResettableDecompressionStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;

public final class ResettableGZIPInputStream
extends GZIPInputStream
implements IResettableDecompressionStream {
    private Method readHeaderMethod;
    private static final Logger log = Logger.getLogger("cloudLink.util");

    public ResettableGZIPInputStream(InputStream in, int size) throws IOException {
        super(in, size);
        this.init();
    }

    public ResettableGZIPInputStream(InputStream in) throws IOException {
        super(in);
        this.init();
    }

    public ResettableGZIPInputStream(byte[] inBytes, int size) throws IOException {
        this((InputStream)new ByteArrayInputStream(inBytes), size);
    }

    public ResettableGZIPInputStream(byte[] inBytes) throws IOException {
        this(new ByteArrayInputStream(inBytes));
    }

    private void init() {
        try {
            this.readHeaderMethod = GZIPInputStream.class.getDeclaredMethod("readHeader", InputStream.class);
            AccessController.doPrivileged(() -> {
                this.readHeaderMethod.setAccessible(true);
                return this.readHeaderMethod;
            });
        }
        catch (NoSuchMethodException | PrivilegedActionException ex) {
            log.log(Level.INFO, "unable to initialize ResettableGZIPInputStream", log.isLoggable(Level.FINE) ? ex : null);
        }
    }

    @Override
    public void close() throws IOException {
        this.eos = true;
        this.in.close();
    }

    @Override
    public void reset(byte[] inBytes) throws IOException {
        this.reset(new ByteArrayInputStream(inBytes));
    }

    @Override
    public void reset(InputStream inStream) throws IOException {
        this.eos = false;
        this.crc.reset();
        this.inf.reset();
        this.in = inStream;
        try {
            this.readHeaderMethod.invoke((Object)this, this.in);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            log.log(Level.INFO, "unable to reset ResettableGZIPInputStream", log.isLoggable(Level.FINE) ? ex : null);
        }
    }

    public static String getContentTypeExtension() {
        return "+gzip";
    }
}

