/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.util;

import com.tridium.sys.license.NLicenseManager;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.license.LicenseDatabaseException;
import javax.baja.status.BStatus;
import javax.baja.sys.Sys;
import javax.baja.util.Lexicon;

public interface LicenseLimit {
    public static final Lexicon lexicon = Lexicon.make((String)"cloudLink");
    public static final Logger log = Logger.getLogger("cloudLink.licenseLimit");
    public static final String LICENSE_FEATURE_NAME = "cloudLink";
    public static final String SMA_EXEMPT_ATTRIBUTE = "sma.exempt";
    public static final String NO_LIC_MSG = "Cloud Link not licensed. Please ensure you have the cloudLink feature and an active Software Maintenance Agreement.";
    public static final String EXPIRED_SMA_MSG = lexicon.getText("smaExpired");

    public void setStatus(BStatus var1);

    public void setFaultCause(String var1);

    default public void initLicenseProperty() {
        try {
            LicenseLimit.checkLicense();
        }
        catch (FeatureNotLicensedException e) {
            this.setStatus(BStatus.fault);
            this.setFaultCause(lexicon.get("unlicensedWarning"));
            log.log(Level.WARNING, NO_LIC_MSG, log.isLoggable(Level.FINE) ? e : null);
            return;
        }
        try {
            LicenseLimit.checkSma();
            this.setStatus(BStatus.ok);
            this.setFaultCause("");
        }
        catch (FeatureNotLicensedException e) {
            this.setStatus(BStatus.fault);
            this.setFaultCause(e.getMessage());
            log.log(Level.WARNING, e.getMessage(), log.isLoggable(Level.FINE) ? e : null);
        }
    }

    public static void checkSmaAndLicense() {
        LicenseLimit.checkLicense();
        LicenseLimit.checkSma();
    }

    public static Feature checkLicense() {
        log.finest(() -> "Checking License");
        return Sys.getLicenseManager().getFeature("tridium", LICENSE_FEATURE_NAME);
    }

    public static void checkSmaAndLicenseAttribute(String attributeName) {
        if (!LicenseLimit.checkLicenseAttribute(attributeName)) {
            throw new FeatureNotLicensedException(String.format("CloudLink license attribute %s missing", attributeName));
        }
        LicenseLimit.checkSma();
    }

    public static boolean isSmaExempt() {
        return LicenseLimit.checkLicenseAttribute(SMA_EXEMPT_ATTRIBUTE);
    }

    public static boolean checkLicenseAttribute(String attribute) {
        try {
            return LicenseLimit.checkLicense().getb(attribute, false);
        }
        catch (FeatureNotLicensedException fnle) {
            log.info("Feature disabled by current license: " + attribute);
        }
        catch (LicenseDatabaseException unexpected) {
            log.log(Level.WARNING, "Unexpected error checking license attribute: " + attribute, log.isLoggable(Level.FINE) ? unexpected : null);
        }
        return false;
    }

    public static void checkSma() {
        Optional<Long> sma;
        if (!LicenseLimit.isSmaExempt() && (!(sma = LicenseLimit.getSmaExpiration()).isPresent() || sma.isPresent() && sma.get() < System.currentTimeMillis())) {
            throw new FeatureNotLicensedException(EXPIRED_SMA_MSG);
        }
    }

    public static Optional<Long> getSmaExpiration() {
        NLicenseManager licenseManager = (NLicenseManager)Sys.getLicenseManager();
        Optional sma = licenseManager.getLicenseMaintenanceExpiration(Sys.getBajaVendor());
        return sma;
    }
}

