/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.transport;

import com.tridium.cloudLink.CloudLinkUtils;
import com.tridium.cloudLink.audit.BCloudAuditRecord;
import com.tridium.cloudLink.transport.BAbstractConnectedTransport;
import com.tridium.cloudLink.transport.BTransportsFolder;
import com.tridium.cloudLink.transport.IConnectionCallback;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.cloudLink.transport.MessageWrapper;
import com.tridium.cloudLink.util.BCompressionMode;
import com.tridium.cloudLink.util.BICachingCertificateConsumer;
import com.tridium.cloudLink.util.IValueWrapper;
import com.tridium.cloudLink.util.LruLinkedHashMap;
import com.tridium.cloudLink.util.StringWrapper;
import com.tridium.crypto.core.cert.NX509CertificateEntry;
import com.tridium.crypto.core.io.CertSelectorListener;
import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.crypto.core.io.ICoreKeyStore;
import com.tridium.crypto.core.io.ICoreTrustStore;
import com.tridium.crypto.core.io.RecallPKIXBuilderParameters;
import com.tridium.crypto.core.io.RecallX509CertSelector;
import com.tridium.niagararemoteclient.NiagaraRemoteClient;
import com.tridium.nre.security.ISecurityInfoProvider;
import com.tridium.nre.security.SecurityInitializer;
import java.io.IOException;
import java.security.AccessController;
import java.security.Key;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.SecureRandom;
import java.security.cert.CertPathParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.security.TlsCipherSuiteGroup;
import javax.baja.nre.security.TlsParameters;
import javax.baja.nre.util.SecurityUtil;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.ExecutorUtil;
import javax.baja.web.BWebServer;
import javax.baja.web.BWebService;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.client.WebSocketClient;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="messageRetries", type="int", defaultValue="DEFAULT_MESSAGE_RETRIES", flags=4, facets={@Facet(name="BFacets.MIN", value="0"), @Facet(name="BFacets.MAX", value="MAX_MESSAGE_RETRIES")}, override=true), @NiagaraProperty(name="compression", type="BCompressionMode", defaultValue="BCompressionMode.none", flags=4, override=true), @NiagaraProperty(name="messageThrottlingLimit", type="int", defaultValue="0", flags=4, facets={@Facet(name="BFacets.MIN", value="0"), @Facet(name="BFacets.MAX", value="Integer.MAX_VALUE")}, override=true), @NiagaraProperty(name="defaultMessageTimeout", type="BRelTime", defaultValue="BRelTime.make(DEFAULT_MESSAGE_TIMEOUT)", flags=4, facets={@Facet(name="BFacets.MIN", value="BRelTime.make(MIN_MESSAGE_TIMEOUT)"), @Facet(name="BFacets.MAX", value="BRelTime.make(MAX_MESSAGE_TIMEOUT)")}, override=true), @NiagaraProperty(name="webServerState", type="String", defaultValue="", flags=6)})
@NiagaraAction(name="certificateUpdate", parameterType="BString", defaultValue="BString.DEFAULT", returnType="BBoolean", flags=4)
public class BNiagaraRemoteTransport
extends BAbstractConnectedTransport
implements NiagaraRemoteClient.StatusCallback,
BIRestrictedComponent,
BICachingCertificateConsumer {
    public static final Property messageRetries = BNiagaraRemoteTransport.newProperty((int)4, (int)2, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)0), (BFacets)BFacets.make((String)"max", (int)10)));
    public static final Property compression = BNiagaraRemoteTransport.newProperty((int)4, (BValue)BCompressionMode.none, null);
    public static final Property messageThrottlingLimit = BNiagaraRemoteTransport.newProperty((int)4, (int)0, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)0), (BFacets)BFacets.make((String)"max", (int)Integer.MAX_VALUE)));
    public static final Property defaultMessageTimeout = BNiagaraRemoteTransport.newProperty((int)4, (BValue)BRelTime.make((long)60000L), (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)1000L)), (BFacets)BFacets.make((String)"max", (BIDataValue)BRelTime.make((long)300000L))));
    public static final Property webServerState = BNiagaraRemoteTransport.newProperty((int)6, (String)"", null);
    public static final Action certificateUpdate = BNiagaraRemoteTransport.newAction((int)4, (BValue)BString.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BNiagaraRemoteTransport.class);
    private NiagaraRemoteClient client;
    private ScheduledFuture<?> reconnectFuture;
    private CompletableFuture<Boolean> clientConnectFuture;
    private X509Certificate webServiceCertificate;
    private final Set<UUID> sessionSet = Collections.newSetFromMap(new LruLinkedHashMap(10));
    private static SecureRandom secureRandom;
    private static final int DEFAULT_HTTPS_PORT = 443;
    private static final String NEW_REMOTE_SESSION = "Niagara Remote session opened";
    private static final String PATH = "/api/v1/nctunnel/";
    private static final String WEBSERVER_STATE_LINK = "webServerStateLink";
    private static final String WSS = "wss://";
    private static final Logger log;

    public String getWebServerState() {
        return this.getString(webServerState);
    }

    public void setWebServerState(String v) {
        this.setString(webServerState, v, null);
    }

    public BBoolean certificateUpdate(BString parameter) {
        return (BBoolean)this.invoke(certificateUpdate, (BValue)parameter, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    @Override
    protected void fwChanged(Property prop) {
        super.fwChanged(prop);
        if (!this.isRunning()) {
            return;
        }
        if (webServerState.equals(prop)) {
            if (("stopped".equals(this.getWebServerState()) || "failed".equals(this.getWebServerState())) && this.isConnected()) {
                this.disconnect();
            } else if ("started".equals(this.getWebServerState()) && !this.getStatus().isDisabled() && !this.isConnected()) {
                this.webServiceCertificate = BNiagaraRemoteTransport.getWebServiceCertificate();
                this.connect();
            }
        }
    }

    @Override
    public void descendantsStarted() throws Exception {
        if (this.getConnectionService().map(c -> c.isFatalFault()).orElse(true).booleanValue()) {
            return;
        }
        this.executor = ExecutorUtil.newSingleThreadBackgroundScheduledExecutor((String)this.getThreadName(), (long)2L, (TimeUnit)TimeUnit.MINUTES);
        this.getConnectionService().ifPresent(ccs -> ccs.registerForConnectionServiceReady(() -> {
            BWebService webService = (BWebService)Sys.getService((Type)BWebService.TYPE);
            BWebServer webServer = webService.getWebServer();
            if (Sys.isStationStarted()) {
                webServer.doRestart(null);
            }
            this.webServiceCertificate = BNiagaraRemoteTransport.getWebServiceCertificate();
            BLink link = new BLink((BComponent)webServer, (Slot)BWebServer.serverState, (Slot)webServerState);
            this.add(WEBSERVER_STATE_LINK, (BValue)link, 6);
        }));
    }

    public final void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        CloudLinkUtils.checkParentForDuplicates(parent, (BComponent)this, BTransportsFolder.TYPE, false, cx);
    }

    @Override
    protected Logger getLogger() {
        return log;
    }

    @Override
    public boolean isConnected() {
        return this.client != null && this.client.isRunning();
    }

    @Override
    public CompletableFuture<?> connect() {
        if (!this.isOperational()) {
            this.connectFail(false, "transport.nonoperational");
            return CompletableFuture.completedFuture(false);
        }
        if (this.authenticator == null) {
            this.connectFail(false, "transport.noAuthenticator");
            return CompletableFuture.completedFuture(false);
        }
        try {
            return AccessController.doPrivileged(() -> {
                try {
                    String certAlias;
                    Map<String, IValueWrapper<?>> connectionInfo;
                    log.info("Connecting Niagara Remote");
                    this.setStatusMessage(lex.getText("transport.connecting"));
                    if (this.client != null) {
                        log.config("Connect called while CloudLink Niagara Remote client is not null, this should never happen.");
                        this.client.stop();
                        this.client = null;
                    }
                    if (this.clientConnectFuture != null) {
                        this.clientConnectFuture.completeExceptionally(new Exception("reconnecting"));
                        this.clientConnectFuture = null;
                    }
                    if ((connectionInfo = this.authenticator.getConnectionInfo(this.getConnectionInfoName())).isEmpty()) {
                        this.reconnectFuture = this.connectFail(true, "transport.noConnectionInfo");
                        return CompletableFuture.completedFuture(false);
                    }
                    Map<String, String> headers = null;
                    if (this.webServiceCertificate == null) {
                        this.webServiceCertificate = BNiagaraRemoteTransport.getWebServiceCertificate();
                        if (this.webServiceCertificate == null) {
                            return CompletableFuture.completedFuture(false);
                        }
                    }
                    certAlias = (certAlias = StringWrapper.getString(connectionInfo.get("token"))).isEmpty() ? null : certAlias;
                    SslContextFactory sslContextFactory = this.getSslContextFactory(certAlias);
                    HttpClient httpClient = new HttpClient(sslContextFactory);
                    WebSocketClient wsClient = new WebSocketClient(httpClient);
                    this.client = this.makeNiagaraRemoteClient(wsClient, BNiagaraRemoteTransport.makeServerUrl(connectionInfo), headers, this.webServiceCertificate, Collections.singletonMap(443, BNiagaraRemoteTransport.getWebServicePort()));
                    this.client.addStatusCallback(this);
                    this.clientConnectFuture = new CompletableFuture();
                    this.client.start();
                    return this.clientConnectFuture;
                }
                catch (Exception ex) {
                    this.setStatus(BStatus.makeDown((BStatus)this.getStatus(), (boolean)true));
                    this.reconnectFuture = this.connectFail(true, "transport.connectionFailure", ex, ex.getMessage());
                    if (this.client != null) {
                        this.client.stop();
                        this.client = null;
                    }
                    CompletableFuture future = new CompletableFuture();
                    future.completeExceptionally(ex);
                    return future;
                }
            });
        }
        catch (PrivilegedActionException err) {
            this.connectFail(false, "transport.permissionFail");
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally(err.getCause());
            return future;
        }
    }

    @Override
    public boolean disconnect() {
        if (this.reconnectFuture != null) {
            this.reconnectFuture.cancel(true);
            this.reconnectFuture = null;
        }
        if (this.isConnected()) {
            try {
                log.info("Disconnecting Niagara Remote");
                BStatus status = this.getStatus();
                if (status.isDisabled()) {
                    this.client.stop();
                }
                this.setStatus(BStatus.makeDown((BStatus)status, (boolean)true));
                this.setStatusMessage(lex.getText("transport.disconnected"));
                if (!status.isDisabled()) {
                    this.client.stop();
                }
                this.client = null;
            }
            catch (Exception ex) {
                log.log(Level.INFO, "Disconnect unable to stop client", log.isLoggable(Level.FINE) ? ex : null);
                return false;
            }
        }
        return true;
    }

    @Override
    public void setupInboundMessaging() {
    }

    @Override
    protected String getThreadName() {
        return "cloudLink.transport.niagaraRemote";
    }

    @Override
    public String getTransportType() {
        return "NIAGARA_REMOTE";
    }

    @Override
    public void send(MessageWrapper<? extends IMessage> payload) throws IOException {
        throw new UnsupportedOperationException("Direct messaging not supported by Niagara Remote transport");
    }

    @Override
    public void connectionSuccess() {
        if (this.clientConnectFuture != null) {
            this.clientConnectFuture.complete(true);
            this.clientConnectFuture = null;
        }
        this.setStatus(BStatus.makeDown((BStatus)this.getStatus(), (boolean)false));
        this.setStatusMessage(lex.getText("transport.connected"));
        for (IConnectionCallback cc : this.connectCallbacks) {
            cc.onConnect();
        }
    }

    @Override
    public void connectionFailed(Throwable throwable) {
        if (this.clientConnectFuture != null) {
            this.clientConnectFuture.completeExceptionally(throwable);
            this.clientConnectFuture = null;
        }
        this.setStatus(BStatus.makeDown((BStatus)this.getStatus(), (boolean)true));
        this.setStatusMessage(lex.getText("transport.connectionFailure", new Object[]{throwable.getLocalizedMessage()}));
        for (IConnectionCallback cc : this.connectCallbacks) {
            cc.onDisconnect();
        }
    }

    @Override
    public void connectionClosed(String reason) {
        this.setStatus(BStatus.makeDown((BStatus)this.getStatus(), (boolean)true));
        if (reason == null || reason.isEmpty()) {
            reason = lex.getText("transport.closed");
        }
        this.setStatusMessage(lex.getText("transport.connectionLost", new Object[]{reason}));
        for (IConnectionCallback cc : this.connectCallbacks) {
            cc.onDisconnect();
        }
    }

    @Override
    public void sessionOpened(UUID sessionQualifier) {
        if (sessionQualifier != null && !this.sessionSet.contains(sessionQualifier)) {
            this.getConnectionService().ifPresent(ccs -> ccs.getCloudAuditHistorySource().audit(new BCloudAuditRecord(BAbsTime.now(), NEW_REMOTE_SESSION, "", "", sessionQualifier.toString(), "")));
            this.sessionSet.add(sessionQualifier);
        }
    }

    private static X509Certificate getWebServiceCertificate() {
        BWebService webService = (BWebService)Sys.getService((Type)BWebService.TYPE);
        String alias = webService.getHttpsCert();
        ICoreKeyStore keyStore = CoreCryptoManager.get().getKeyStore();
        X509Certificate cert = null;
        try {
            cert = keyStore.getCertificate(alias);
        }
        catch (Exception ex) {
            log.log(Level.INFO, "error retrieving certificate", log.isLoggable(Level.FINE) ? ex : null);
        }
        if (cert == null) {
            log.info(() -> "unable to obtain certificate '" + alias + "', trying '" + "tridium" + '\'');
            try {
                cert = keyStore.getCertificate("tridium");
            }
            catch (Exception ex) {
                log.log(Level.INFO, log.isLoggable(Level.FINE) ? ex : null, () -> "error retrieving certificate with alias 'tridium'");
            }
        }
        return cert;
    }

    private static String makeServerUrl(Map<String, IValueWrapper<?>> connectionInfo) {
        return WSS + StringWrapper.getString(connectionInfo.get("hostName")) + PATH;
    }

    private static int getWebServicePort() {
        BWebService webService = (BWebService)Sys.getService((Type)BWebService.TYPE);
        return webService.getHttpsPort().getPublicServerPort();
    }

    private SslContextFactory getSslContextFactory(String certAlias) throws Exception {
        ClientTlsParameters tlsParams = new ClientTlsParameters(this.getSslProtocol().getDisplayTag(null), certAlias);
        SslContextFactory factory = CoreCryptoManager.get().getSslContextFactory((TlsParameters)tlsParams);
        SSLContext sslContext = SSLContext.getInstance(this.getSslProtocol().getDisplayTag(null));
        sslContext.init(BNiagaraRemoteTransport.makeKeyManagers(certAlias), BNiagaraRemoteTransport.makeTrustManagers(), null);
        factory.setSslContext(sslContext);
        return factory;
    }

    private static KeyManager[] makeKeyManagers(String certAlias) throws Exception {
        if (certAlias != null && !certAlias.isEmpty()) {
            ICoreKeyStore coreKeyStore = CoreCryptoManager.get().getKeyStore();
            Key key = coreKeyStore.getKey(certAlias, null);
            if (key != null) {
                byte[] tempPassBytes = new byte[32];
                secureRandom.nextBytes(tempPassBytes);
                char[] tempPassChars = SecurityUtil.toHexChars((byte[])tempPassBytes);
                KeyStore tempKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                tempKeyStore.load(null, null);
                tempKeyStore.setKeyEntry(certAlias, key, tempPassChars, coreKeyStore.getCertificateChain(certAlias));
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("PKIX");
                keyManagerFactory.init(tempKeyStore, tempPassChars);
                return keyManagerFactory.getKeyManagers();
            }
            log.config(() -> "cert alias [" + certAlias + "] not found");
        }
        return null;
    }

    private static TrustManager[] makeTrustManagers() throws Exception {
        NX509CertificateEntry certificateEntry;
        HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
        ISecurityInfoProvider securityInfoProvider = SecurityInitializer.getInstance().getSecurityInfoProvider();
        CoreCryptoManager coreCryptoManager = CoreCryptoManager.get((ISecurityInfoProvider)securityInfoProvider);
        ICoreTrustStore userTrustStore = coreCryptoManager.getUserTrustStore();
        ICoreTrustStore systemTrustStore = coreCryptoManager.getSystemTrustStore();
        Enumeration certificateEntries = systemTrustStore.getCertificates();
        while (certificateEntries.hasMoreElements()) {
            certificateEntry = (NX509CertificateEntry)certificateEntries.nextElement();
            trustAnchors.add(new TrustAnchor(certificateEntry.getCertificate(0).getCertificate(), null));
        }
        certificateEntries = userTrustStore.getCertificates();
        while (certificateEntries.hasMoreElements()) {
            certificateEntry = (NX509CertificateEntry)certificateEntries.nextElement();
            trustAnchors.add(new TrustAnchor(certificateEntry.getCertificate(0).getCertificate(), null));
        }
        TrustManagerFactory factory = TrustManagerFactory.getInstance("PKIX");
        RecallPKIXBuilderParameters pkixParameters = new RecallPKIXBuilderParameters(trustAnchors, new RecallX509CertSelector(new CertSelectorListener()));
        pkixParameters.setRevocationEnabled(false);
        factory.init(new CertPathTrustManagerParameters((CertPathParameters)pkixParameters));
        return factory.getTrustManagers();
    }

    protected NiagaraRemoteClient makeNiagaraRemoteClient(WebSocketClient wsClient, String serverUrl, Map<String, String> headers, X509Certificate webServiceCertificate, Map<Integer, Integer> portMapping) throws Exception {
        return new NiagaraRemoteClient(wsClient, serverUrl, headers, webServiceCertificate, portMapping);
    }

    @Override
    public Action getCertificateUpdateAction() {
        return certificateUpdate;
    }

    public final BBoolean doCertificateUpdate(BString alias) {
        if (this.isConnected()) {
            this.reconnect();
            return BBoolean.TRUE;
        }
        return BBoolean.FALSE;
    }

    static {
        try {
            secureRandom = SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException ex) {
            secureRandom = new SecureRandom();
        }
        log = Logger.getLogger("cloudLink.transport.niagaraRemote");
    }

    private class ClientTlsParameters
    extends TlsParameters {
        public ClientTlsParameters(String minTlsProtocol, String certAlias) {
            this.setMinTlsProtocol(minTlsProtocol);
            this.setCertAlias(certAlias);
            this.setTlsCipherSuiteGroup(TlsCipherSuiteGroup.recommended);
        }
    }
}

