/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.transport;

import com.tridium.cloudLink.BAbstractCloudLinkHandlerFactory;
import com.tridium.cloudLink.transport.AmqpMessage;
import com.tridium.cloudLink.transport.AmqpResponse;
import com.tridium.cloudLink.transport.BAbstractConnectedTransport;
import com.tridium.cloudLink.transport.BAmqpConnectionType;
import com.tridium.cloudLink.transport.IConnectionCallback;
import com.tridium.cloudLink.transport.IGetMessageKey;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.cloudLink.transport.IMessageCallback;
import com.tridium.cloudLink.transport.MessageWrapper;
import com.tridium.cloudLink.transport.internal.AmqpClient;
import com.tridium.cloudLink.transport.internal.IAmqpCallbacks;
import com.tridium.cloudLink.util.IValueWrapper;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.engine.Delivery;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="connectionType", type="BAmqpConnectionType", defaultValue="BAmqpConnectionType.amqpWs"), @NiagaraProperty(name="trustAnchors", type="BVector", defaultValue="new BVector()", flags=7, facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")})})
public class BAmqpTransport
extends BAbstractConnectedTransport
implements IAmqpCallbacks {
    public static final Property connectionType = BAmqpTransport.newProperty((int)0, (BValue)BAmqpConnectionType.amqpWs, null);
    public static final Property trustAnchors = BAmqpTransport.newProperty((int)7, (BValue)new BVector(), (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    public static final Type TYPE = Sys.loadType(BAmqpTransport.class);
    private AmqpClient client;
    private IGetMessageKey<AmqpMessage> keyGetter;
    private IGetMessageKey<AmqpMessage> correlationIdGetter;
    private Consumer<IMessage> messageLogger;
    private ScheduledFuture<?> reconnectFuture;
    private boolean immediateReconnect;
    private static final Logger log = Logger.getLogger("cloudLink.transport.amqp");

    public BAmqpConnectionType getConnectionType() {
        return (BAmqpConnectionType)this.get(connectionType);
    }

    public void setConnectionType(BAmqpConnectionType v) {
        this.set(connectionType, (BValue)v, null);
    }

    public BVector getTrustAnchors() {
        return (BVector)this.get(trustAnchors);
    }

    public void setTrustAnchors(BVector v) {
        this.set(trustAnchors, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    @Override
    protected String getThreadName() {
        return "cloudLink.transport.amqp";
    }

    @Override
    protected Logger getLogger() {
        return log;
    }

    @Override
    public boolean isConnected() {
        return this.client != null && this.client.isConnected();
    }

    @Override
    public CompletableFuture<?> connect() {
        if (!this.isOperational()) {
            this.connectFail(false, "transport.nonoperational");
            return CompletableFuture.completedFuture(false);
        }
        if (this.authenticator == null) {
            this.connectFail(false, "transport.noAuthenticator");
            return CompletableFuture.completedFuture(false);
        }
        try {
            return AccessController.doPrivileged(() -> {
                try {
                    Map<String, IValueWrapper<?>> connectionInfo;
                    this.setStatusMessage(lex.getText("transport.connecting"));
                    if (this.client != null) {
                        log.config("Connect called while AMQP client is not null, this should never happen.");
                        this.client.disconnect();
                        this.client = null;
                    }
                    if ((connectionInfo = this.authenticator.getConnectionInfo(this.getConnectionInfoName())).isEmpty()) {
                        this.reconnectFuture = this.connectFail(true, "transport.noConnectionInfo");
                        return CompletableFuture.completedFuture(false);
                    }
                    this.client = new AmqpClient(this.getConnectionType().equals((Object)BAmqpConnectionType.amqpWs), this.getSslProtocol().getDisplayTag(null));
                    return this.client.connect(this, connectionInfo).whenComplete((ignore, err) -> {
                        if (err != null) {
                            this.connectFail(false, "transport.connectionFailure", (Throwable)err, err.getMessage());
                        } else {
                            this.immediateReconnect = true;
                            this.connectSuccess();
                        }
                        this.updateStatus();
                    });
                }
                catch (Exception ex) {
                    this.reconnectFuture = this.connectFail(true, "transport.connectionFailure", ex, ex.getMessage());
                    if (this.client != null) {
                        this.client.disconnect();
                        this.client = null;
                    }
                    CompletableFuture future = new CompletableFuture();
                    future.completeExceptionally(ex);
                    return future;
                }
            });
        }
        catch (PrivilegedActionException err) {
            this.connectFail(false, "transport.permissionFail");
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally(err.getException());
            return future;
        }
    }

    @Override
    public boolean disconnect() {
        if (this.reconnectFuture != null) {
            this.reconnectFuture.cancel(true);
            this.reconnectFuture = null;
        }
        if (this.isConnected()) {
            for (IConnectionCallback cc : this.connectCallbacks) {
                cc.onDisconnect();
            }
            this.client.disconnect();
        }
        this.client = null;
        this.setStatusMessage(lex.getText("transport.disconnected"));
        return true;
    }

    @Override
    public void setupInboundMessaging() {
        BAbstractCloudLinkHandlerFactory factory = this.getConnectionService().orElseThrow(() -> new IllegalStateException("Unable to locate Cloud Connection Service.")).getMessageHandlerFactory(this.getTransportType()).orElseThrow(() -> new IllegalStateException("Unable to locate message handler factory."));
        this.keyGetter = factory.getMessageKeyHandler();
        this.correlationIdGetter = factory.getMessageCorrelationIdHandler();
        this.messageLogger = factory.getMessageLogger();
    }

    @Override
    public String getTransportType() {
        return "AMQP";
    }

    @Override
    public void send(MessageWrapper<? extends IMessage> payload) throws IOException {
        try {
            if (!this.canSend()) {
                throw new IOException("CloudLink AMQP transport not connected");
            }
            if (!(payload.getMessage() instanceof AmqpMessage)) {
                throw new IllegalArgumentException("Invalid message type for CloudLink AMQP transport " + payload.getMessage().getClass().getName());
            }
            AccessController.doPrivileged(() -> {
                AmqpMessage message = (AmqpMessage)payload.getMessage();
                this.client.send(message).whenComplete((result, err) -> {
                    if (err != null) {
                        payload.getTransportFuture().completeExceptionally((Throwable)err);
                    } else {
                        payload.getTransportFuture().complete(new AmqpResponse((Delivery)result));
                    }
                });
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            Exception inner = e.getException();
            payload.getTransportFuture().completeExceptionally(inner);
        }
    }

    @Override
    public void onMessageReceived(IMessage message, Throwable err) {
        log.config("Received AMQP message, messageId = " + ((AmqpMessage)message).getAmqpProperties().getMessageId());
        this.metricHelper.messageReceived(message.getLength());
        if (message.getMetadata().get("MessageContentType") != null) {
            String contentType = message.getMetadata().get("MessageContentType").toString();
            for (String type : this.decompressorTypeMap.keySet()) {
                if (!contentType.endsWith(type)) continue;
                byte[] payload = this.uncompressData(type, message.getPayload(), ((AmqpMessage)message).getMessage().getMessageId().toString());
                Binary binary = new Binary(payload);
                Data section = new Data(binary);
                ((AmqpMessage)message).getMessage().setBody(section);
            }
        }
        this.messageLogger.accept(message);
        if (this.correlationIdGetter == null) {
            log.config("CloudLink AMQP Message received when correlationIdGetter is null");
        } else {
            String correlationId = this.correlationIdGetter.getKey((AmqpMessage)message);
            if (correlationId != null && !correlationId.isEmpty()) {
                if (this.messageResponseCallbacks.containsKey(correlationId)) {
                    ((IMessageCallback)this.messageResponseCallbacks.get(correlationId)).onMessage(message);
                    this.messageResponseCallbacks.remove(correlationId);
                } else {
                    log.fine(() -> String.format("Message with correlation id [%s] received which has no pending callback.", correlationId));
                }
                return;
            }
        }
        if (this.keyGetter == null) {
            log.config("CloudLink AMQP Message received when keyGetter is null");
            return;
        }
        String key = this.keyGetter.getKey((AmqpMessage)message);
        if (!this.messageCallbacks.containsKey(key)) {
            log.finest(() -> String.format("Message with key [%s] received which has no callbacks registered.", key));
            return;
        }
        for (IMessageCallback messageCallback : (Set)this.messageCallbacks.get(key)) {
            messageCallback.onMessage(message);
        }
    }

    @Override
    public void onConnectionLost(AmqpClient client, Throwable err) {
        block9: {
            if (client != this.client) {
                log.log(Level.FINE, "onConnectionLost called by client that is not the current client " + client, log.isLoggable(Level.FINE) ? err : null);
                return;
            }
            for (IConnectionCallback cc : this.connectCallbacks) {
                cc.onDisconnect();
            }
            if (this.immediateReconnect) {
                this.immediateReconnect = false;
                try {
                    this.connect();
                }
                catch (Exception reconnectExc) {
                    if (this.reconnectFuture == null || this.reconnectFuture.isDone()) {
                        this.reconnectFuture = this.connectFail(true, "transport.connectionLost", reconnectExc, reconnectExc.getMessage());
                        break block9;
                    }
                    this.connectFail(false, "transport.connectionLostNoRetry", reconnectExc, reconnectExc.getMessage());
                }
            } else if (this.reconnectFuture == null || this.reconnectFuture.isDone()) {
                this.reconnectFuture = this.connectFail(true, "transport.connectionLost", err, err.getMessage());
            } else {
                this.connectFail(false, "transport.connectionLostNoRetry", err, err.getMessage());
            }
        }
    }

    @Override
    public void spy(SpyWriter out) throws Exception {
        out.startProps();
        out.trTitle((Object)"BAmqpTransport", 2);
        out.prop((Object)"client", (Object)this.client);
        out.prop((Object)"reconnectFuture", this.reconnectFuture);
        out.prop((Object)"immediateReconnect", this.immediateReconnect);
        out.prop((Object)"keyGetter", this.keyGetter);
        out.prop((Object)"correlationIdGetter", this.correlationIdGetter);
        out.prop((Object)"messageLogger", this.messageLogger);
        out.endProps();
        super.spy(out);
    }
}

