/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.transport;

import com.tridium.cloudLink.auth.BAbstractClientAuthenticator;
import com.tridium.cloudLink.transport.BAbstractTransport;
import com.tridium.cloudLink.transport.BTlsVersion;
import com.tridium.cloudLink.transport.IConnectionCallback;
import com.tridium.cloudLink.transport.IMessageCallback;
import com.tridium.cloudLink.util.BCompletableFutureWrapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.BNameMap;
import javax.baja.util.ExecutorUtil;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="authenticatorId", type="BString", defaultValue="BString.DEFAULT", flags=1), @NiagaraProperty(name="statusMessage", type="String", defaultValue="Disconnected", flags=259), @NiagaraProperty(name="connectionInfoName", type="BString", defaultValue="BString.make(\"IoTHub2\")", flags=5), @NiagaraProperty(name="connectRetryInterval", type="BRelTime", defaultValue="BRelTime.makeSeconds(20)", facets={@Facet(value="BFacets.make(BFacets.MIN, BRelTime.makeSeconds(5))")}), @NiagaraProperty(name="maxConnectRetryInterval", type="BRelTime", defaultValue="BRelTime.makeHours(1)"), @NiagaraProperty(name="sslProtocol", type="BTlsVersion", defaultValue="BTlsVersion.TLSv1_2", flags=5, facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")})})
@NiagaraAction(name="reconnect", returnType="BCompletableFutureWrapper", flags=256)
public abstract class BAbstractConnectedTransport
extends BAbstractTransport {
    public static final Property authenticatorId = BAbstractConnectedTransport.newProperty((int)1, (BValue)BString.DEFAULT, null);
    public static final Property statusMessage = BAbstractConnectedTransport.newProperty((int)259, (String)"Disconnected", null);
    public static final Property connectionInfoName = BAbstractConnectedTransport.newProperty((int)5, (BValue)BString.make((String)"IoTHub2"), null);
    public static final Property connectRetryInterval = BAbstractConnectedTransport.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)20), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)5)));
    public static final Property maxConnectRetryInterval = BAbstractConnectedTransport.newProperty((int)0, (BValue)BRelTime.makeHours((int)1), null);
    public static final Property sslProtocol = BAbstractConnectedTransport.newProperty((int)5, (BValue)BTlsVersion.TLSv1_2, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    public static final Action reconnect = BAbstractConnectedTransport.newAction((int)256, null);
    public static final Type TYPE = Sys.loadType(BAbstractConnectedTransport.class);
    protected BAbstractClientAuthenticator authenticator;
    protected ScheduledExecutorService executor;
    protected MetricHelper metricHelper;
    protected final List<IConnectionCallback> connectCallbacks = new CopyOnWriteArrayList<IConnectionCallback>();
    protected final Map<String, Set<IMessageCallback>> messageCallbacks = new ConcurrentHashMap<String, Set<IMessageCallback>>();
    protected final Map<String, IMessageCallback> messageResponseCallbacks = new ConcurrentHashMap<String, IMessageCallback>();
    protected static final Lexicon lex = Lexicon.make(BAbstractConnectedTransport.class);
    private static final String DISPLAY_NAMES_PROP = "displayNames";
    private static final long BACKOFF_FACTOR = 2L;
    private static final long MIN_RETRY_INTERVAL_MILLIS = 5000L;
    protected int connectFailureCount;
    protected long nextRetryIntervalMillis;

    public String getAuthenticatorId() {
        return this.getString(authenticatorId);
    }

    public void setAuthenticatorId(String v) {
        this.setString(authenticatorId, v, null);
    }

    public String getStatusMessage() {
        return this.getString(statusMessage);
    }

    public void setStatusMessage(String v) {
        this.setString(statusMessage, v, null);
    }

    public String getConnectionInfoName() {
        return this.getString(connectionInfoName);
    }

    public void setConnectionInfoName(String v) {
        this.setString(connectionInfoName, v, null);
    }

    public BRelTime getConnectRetryInterval() {
        return (BRelTime)this.get(connectRetryInterval);
    }

    public void setConnectRetryInterval(BRelTime v) {
        this.set(connectRetryInterval, (BValue)v, null);
    }

    public BRelTime getMaxConnectRetryInterval() {
        return (BRelTime)this.get(maxConnectRetryInterval);
    }

    public void setMaxConnectRetryInterval(BRelTime v) {
        this.set(maxConnectRetryInterval, (BValue)v, null);
    }

    public BTlsVersion getSslProtocol() {
        return (BTlsVersion)this.get(sslProtocol);
    }

    public void setSslProtocol(BTlsVersion v) {
        this.set(sslProtocol, (BValue)v, null);
    }

    public BCompletableFutureWrapper reconnect() {
        return (BCompletableFutureWrapper)this.invoke(reconnect, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    protected void fwStarted() {
        super.fwStarted();
        if (this.getConnectionService().map(c -> c.isFatalFault()).orElse(true).booleanValue()) {
            return;
        }
        this.metricHelper = new MetricHelper();
        this.addConnectionCallback(this.metricHelper);
        this.initializeAuthenticator();
        this.setupInboundMessaging();
        this.ensureDisplayNameMap();
        this.nextRetryIntervalMillis = this.getBaseConnectRetryInterval().getMillis();
    }

    @Override
    protected void fwChanged(Property prop) {
        super.fwChanged(prop);
        if (!this.isRunning() || this.getConnectionService().map(c -> c.isFatalFault()).orElse(true).booleanValue()) {
            return;
        }
        if (prop.equals(status)) {
            if (!this.getStatus().isDisabled() && !this.isConnected()) {
                this.connect().whenComplete((res, err) -> {
                    if (err != null) {
                        log.log(Level.WARNING, "unable to connect when transport enabled", log.isLoggable(Level.FINE) ? err : null);
                    }
                });
            } else if (this.getStatus().isDisabled() && this.isConnected()) {
                this.disconnect();
            }
        } else if (prop.equals(authenticatorId)) {
            this.initializeAuthenticator();
        }
    }

    public void descendantsStarted() throws Exception {
        if (this.getConnectionService().map(c -> c.isFatalFault()).orElse(true).booleanValue()) {
            return;
        }
        this.executor = ExecutorUtil.newSingleThreadBackgroundScheduledExecutor((String)this.getThreadName(), (long)2L, (TimeUnit)TimeUnit.MINUTES);
        this.getConnectionService().ifPresent(ccs -> ccs.registerForConnectionServiceReady(() -> {
            if (this.canConnect()) {
                this.doReconnect();
            }
        }));
    }

    @Override
    public void stopped() throws Exception {
        super.stopped();
        this.disconnect();
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    public abstract boolean isConnected();

    public boolean canConnect() {
        return this.authenticator != null && this.isOperational();
    }

    public abstract CompletableFuture<?> connect();

    public BCompletableFutureWrapper doReconnect() {
        try {
            if (this.isConnected()) {
                this.disconnect();
            }
            return BCompletableFutureWrapper.make(this.connect());
        }
        catch (Exception ex) {
            this.getLogger().log(Level.WARNING, "reconnect failed", this.getLogger().isLoggable(Level.FINE) ? ex : null);
            this.setStatusMessage(ex.getLocalizedMessage());
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally(ex);
            return BCompletableFutureWrapper.make(future);
        }
    }

    public abstract boolean disconnect();

    protected void connectSuccess() {
        log.info(() -> String.format("CloudLink %s transport connected", this.getTransportType()));
        this.setStatusMessage(lex.getText("transport.connected"));
        this.connectFailureCount = 0;
        this.nextRetryIntervalMillis = this.getBaseConnectRetryInterval().getMillis();
        for (IConnectionCallback cc : this.connectCallbacks) {
            cc.onConnect();
        }
    }

    protected ScheduledFuture<?> connectFail(boolean retryable, String reasonKey, Throwable throwable, Object ... args) {
        String message = lex.getText(reasonKey, args);
        this.setStatusMessage(message);
        if (retryable) {
            log.log(Level.INFO, log.isLoggable(Level.FINE) ? throwable : null, () -> String.format("CloudLink %s transport failed to connect [%s], scheduling retry", this.getTransportType(), message));
            ++this.connectFailureCount;
            return this.executor.schedule(this::connect, this.computeRetryInterval(), TimeUnit.MILLISECONDS);
        }
        log.log(Level.INFO, log.isLoggable(Level.FINE) ? throwable : null, () -> String.format("CloudLink %s transport connection failed: %s", this.getTransportType(), message));
        return null;
    }

    protected ScheduledFuture<?> connectFail(boolean retryable, String reasonKey) {
        return this.connectFail(retryable, reasonKey, null, "");
    }

    public void addConnectionCallback(IConnectionCallback callback) {
        this.connectCallbacks.add(callback);
    }

    public void removeConnectionCallback(IConnectionCallback callback) {
        this.connectCallbacks.remove(callback);
    }

    public void addMessageCallback(String key, IMessageCallback callback) {
        if (!this.messageCallbacks.containsKey(key)) {
            this.messageCallbacks.put(key, new CopyOnWriteArraySet());
        }
        this.messageCallbacks.get(key).add(callback);
    }

    public void removeMessageCallback(String key, IMessageCallback callback) {
        if (!this.messageCallbacks.containsKey(key)) {
            this.getLogger().config(() -> String.format("Attempt to remove callback for unknown key [%s]", key));
            return;
        }
        this.messageCallbacks.get(key).remove(callback);
    }

    public void setMessageResponseCallback(String correlationId, IMessageCallback callback) {
        this.messageResponseCallbacks.put(correlationId, callback);
    }

    public abstract void setupInboundMessaging();

    @Override
    public boolean canSend() {
        return this.isConnected() && this.isOperational();
    }

    public void initializeAuthenticator() {
        this.getConnectionService().ifPresent(srv -> {
            this.authenticator = srv.getAuthenticator(this.getAuthenticatorId());
        });
    }

    private void ensureDisplayNameMap() {
        Property displayNamesProp = this.getProperty(DISPLAY_NAMES_PROP);
        if (displayNamesProp == null) {
            HashMap<String, BFormat> map = new HashMap<String, BFormat>();
            map.put("connectRetryInterval", BFormat.make((String)lex.get("transport.baseConnectRetryInterval")));
            this.add(DISPLAY_NAMES_PROP, (BValue)BNameMap.make(map), 4);
        } else {
            BValue displayNames = this.get(displayNamesProp);
            if (displayNames instanceof BNameMap) {
                this.set(DISPLAY_NAMES_PROP, (BValue)BNameMap.make((BNameMap)((BNameMap)displayNames), (String)"connectRetryInterval", (String)lex.get("transport.baseConnectRetryInterval")));
            } else {
                HashMap<String, BFormat> map = new HashMap<String, BFormat>();
                map.put("connectRetryInterval", BFormat.make((String)lex.get("transport.baseConnectRetryInterval")));
                this.set(DISPLAY_NAMES_PROP, (BValue)BNameMap.make(map));
            }
        }
    }

    protected long computeRetryInterval() {
        long interval = this.nextRetryIntervalMillis = Math.max(this.nextRetryIntervalMillis, 5000L);
        this.nextRetryIntervalMillis *= 2L;
        this.nextRetryIntervalMillis = Math.min(this.nextRetryIntervalMillis, this.getMaxConnectRetryInterval().getMillis());
        return interval;
    }

    public BRelTime getBaseConnectRetryInterval() {
        return this.getConnectRetryInterval();
    }

    @Override
    public void spy(SpyWriter out) throws Exception {
        out.startProps();
        out.trTitle((Object)"BAbstractConnectedTransport", 2);
        out.prop((Object)"executor", (Object)this.executor);
        out.prop((Object)"authenticator", (Object)this.authenticator);
        out.prop((Object)"connectFailureCount", this.connectFailureCount);
        out.prop((Object)"nextRetryIntervalMillis", (double)this.nextRetryIntervalMillis);
        out.prop((Object)"connectCallbacks", this.connectCallbacks);
        out.endProps();
        out.startProps("messageCallbacks");
        this.messageCallbacks.forEach((key, value) -> out.prop(key, value));
        out.endProps();
        out.startProps("messageResponseCallbacks");
        this.messageResponseCallbacks.forEach((key, value) -> out.prop(key, value));
        out.endProps();
        this.metricHelper.spy(out);
        super.spy(out);
    }

    protected abstract String getThreadName();

    protected abstract Logger getLogger();

    @Override
    public void doResetMetrics() {
        super.doResetMetrics();
        this.metricHelper.reset();
    }

    protected class MetricHelper
    implements IConnectionCallback {
        private long connectionCount;
        private long lastConnectionTime;
        private long lastDisconnectionTime;
        private long messagesReceivedCount;
        private long bytesReceivedCount;
        private long lastMessagesReceivedTime;

        protected MetricHelper() {
        }

        @Override
        public void onConnect() {
            ++this.connectionCount;
            this.lastConnectionTime = System.currentTimeMillis();
        }

        @Override
        public void onDisconnect() {
            this.lastDisconnectionTime = System.currentTimeMillis();
        }

        public void messageReceived(int length) {
            ++this.messagesReceivedCount;
            this.bytesReceivedCount += (long)length;
            this.lastMessagesReceivedTime = System.currentTimeMillis();
        }

        public void spy(SpyWriter out) {
            out.startProps("Connections");
            out.trTitle((Object)"General", 2);
            out.prop((Object)"Client Connection Count", (double)this.connectionCount);
            out.prop((Object)"Last Client Connection Time", (Object)BAbstractConnectedTransport.this.toDateTimeString(this.lastConnectionTime));
            out.prop((Object)"Last Client Disconnect Time", (Object)BAbstractConnectedTransport.this.toDateTimeString(this.lastDisconnectionTime));
            out.trTitle((Object)"Messages Received", 2);
            out.prop((Object)"Total Messages Received Count", (double)this.messagesReceivedCount);
            out.prop((Object)"Total Bytes Received Count", (double)this.bytesReceivedCount);
            out.prop((Object)"Last Message Received Time", (Object)BAbstractConnectedTransport.this.toDateTimeString(this.lastMessagesReceivedTime));
        }

        public void reset() {
            this.connectionCount = 0L;
            this.lastConnectionTime = 0L;
            this.lastDisconnectionTime = 0L;
            this.messagesReceivedCount = 0L;
            this.bytesReceivedCount = 0L;
            this.lastMessagesReceivedTime = 0L;
        }
    }
}

