/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.transport;

import com.tridium.cloudLink.CloudLinkConstants;
import com.tridium.cloudLink.transport.IMessage;
import java.util.Arrays;
import java.util.Map;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.message.Message;

public class AmqpMessage
implements IMessage {
    private final Message message;
    private Delivery delivery;

    public AmqpMessage(Message message, Delivery delivery) {
        this.message = message;
        this.delivery = delivery;
    }

    public AmqpMessage(byte[] payload, Map<String, Object> metadata) {
        this.message = Proton.message();
        Binary binary = new Binary(payload);
        Data section = new Data(binary);
        this.message.setBody(section);
        this.message.setApplicationProperties(new ApplicationProperties(metadata));
    }

    @Override
    public int getLength() {
        Section body = this.message.getBody();
        if (body instanceof Data) {
            Binary payload = ((Data)body).getValue();
            return payload.getLength();
        }
        return 0;
    }

    @Override
    public byte[] getPayload() {
        Section body = this.message.getBody();
        if (body instanceof Data) {
            Binary payload = ((Data)body).getValue();
            if (payload.getArrayOffset() == 0) {
                return payload.getArray();
            }
            return Arrays.copyOfRange(payload.getArray(), payload.getArrayOffset(), payload.getLength());
        }
        return CloudLinkConstants.EMPTY_BYTES;
    }

    @Override
    public Map<String, Object> getMetadata() {
        return this.message.getApplicationProperties().getValue();
    }

    public Properties getAmqpProperties() {
        return this.message.getProperties();
    }

    public Delivery getDelivery() {
        return this.delivery;
    }

    public Message getMessage() {
        return this.message;
    }
}

