/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.history;

import com.tridium.cloudLink.channel.BHistoriesChannel;
import com.tridium.cloudLink.channel.BIHistoryChannelConfig;
import com.tridium.cloudLink.history.BCloudHistoryExportConfigContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.BSourceState;
import javax.baja.category.BCategoryMask;
import javax.baja.data.BIDataValue;
import javax.baja.driver.util.BAbstractDescriptor;
import javax.baja.driver.util.BDescriptorState;
import javax.baja.history.BHistoryId;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="historyIds", type="BVector", defaultValue="new BVector()", flags=1), @NiagaraProperty(name="alarmOnFailure", type="boolean", defaultValue="true"), @NiagaraProperty(name="alarmSourceInfo", type="BAlarmSourceInfo", defaultValue="initAlarmSourceInfo()"), @NiagaraProperty(name="initialRetryInterval", type="int", defaultValue="1", facets={@Facet(value="BFacets.make(BFacets.MIN, BInteger.make(1))")}), @NiagaraProperty(name="maxRetryInterval", type="int", defaultValue="96")})
@NiagaraAction(name="ackAlarm", parameterType="BAlarmRecord", defaultValue="new BAlarmRecord()", returnType="BBoolean", flags=4)
public class BCloudHistoryExportConfig
extends BAbstractDescriptor
implements BIAlarmSource {
    public static final Property historyIds = BCloudHistoryExportConfig.newProperty((int)1, (BValue)new BVector(), null);
    public static final Property alarmOnFailure = BCloudHistoryExportConfig.newProperty((int)0, (boolean)true, null);
    public static final Property alarmSourceInfo = BCloudHistoryExportConfig.newProperty((int)0, (BValue)BCloudHistoryExportConfig.initAlarmSourceInfo(), null);
    public static final Property initialRetryInterval = BCloudHistoryExportConfig.newProperty((int)0, (int)1, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)1)));
    public static final Property maxRetryInterval = BCloudHistoryExportConfig.newProperty((int)0, (int)96, null);
    public static final Action ackAlarm = BCloudHistoryExportConfig.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Type TYPE = Sys.loadType(BCloudHistoryExportConfig.class);
    protected static final Logger log = Logger.getLogger("cloudLink.channel.history");
    private AlarmSupport alarmSupport;
    private int retryFailuresCount;
    private int retryInterval = 1;
    private static final int BACKOFF_FACTOR = 2;

    public BVector getHistoryIds() {
        return (BVector)this.get(historyIds);
    }

    public void setHistoryIds(BVector v) {
        this.set(historyIds, (BValue)v, null);
    }

    public boolean getAlarmOnFailure() {
        return this.getBoolean(alarmOnFailure);
    }

    public void setAlarmOnFailure(boolean v) {
        this.setBoolean(alarmOnFailure, v, null);
    }

    public BAlarmSourceInfo getAlarmSourceInfo() {
        return (BAlarmSourceInfo)this.get(alarmSourceInfo);
    }

    public void setAlarmSourceInfo(BAlarmSourceInfo v) {
        this.set(alarmSourceInfo, (BValue)v, null);
    }

    public int getInitialRetryInterval() {
        return this.getInt(initialRetryInterval);
    }

    public void setInitialRetryInterval(int v) {
        this.setInt(initialRetryInterval, v, null);
    }

    public int getMaxRetryInterval() {
        return this.getInt(maxRetryInterval);
    }

    public void setMaxRetryInterval(int v) {
        this.setInt(maxRetryInterval, v, null);
    }

    public BBoolean ackAlarm(BAlarmRecord parameter) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final boolean isParentLegal(BComponent parent) {
        return parent instanceof BCloudHistoryExportConfigContainer;
    }

    public void started() {
        this.alarmSupport = new AlarmSupport((BIAlarmSource)this, this.getAlarmSourceInfo());
        this.retryFailuresCount = 0;
        this.retryInterval = 1;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(enabled) && this.getEnabled() && !this.getStatus().isDisabled()) {
            this.getHistoriesChannel().ifPresent(h -> h.notifyExportConfigEnabled());
        }
    }

    public final BCategoryMask getCategoryMask() {
        return this.getParent() == null ? super.getCategoryMask() : this.getParent().asComponent().getCategoryMask();
    }

    public final BCategoryMask getAppliedCategoryMask() {
        return this.getParent() == null ? super.getAppliedCategoryMask() : this.getParent().asComponent().getAppliedCategoryMask();
    }

    public void updateStatus() {
        int newStatus = this.getStatus().getBits();
        Optional<BHistoriesChannel> channel = this.getHistoriesChannel();
        newStatus = !this.getEnabled() || channel.map(c -> c.getStatus().isDisabled()).orElse(false).booleanValue() ? (newStatus |= 1) : (newStatus &= 0xFFFFFFFE);
        newStatus = !this.getLastFailure().isNull() && this.getLastFailure().isAfter(this.getLastSuccess()) ? (newStatus |= 2) : (newStatus &= 0xFFFFFFFD);
        if (newStatus == this.getStatus().getBits()) {
            return;
        }
        this.setStatus(BStatus.make((int)newStatus));
    }

    protected IFuture postExecute(Action action, BValue arg, Context cx) {
        ((BCloudHistoryExportConfigContainer)this.getParent().as(BCloudHistoryExportConfigContainer.class)).asyncWorkQueue.enqueue((Object)new Invocation((BComponent)this, action, arg, cx));
        return null;
    }

    public void doExecute() {
        try {
            if (!this.isRunning()) {
                this.setState(BDescriptorState.idle);
                return;
            }
            Optional<BHistoriesChannel> optChannel = this.getHistoriesChannel();
            if (optChannel.map(h -> ((BIHistoryChannelConfig)h.getChannelConfig().as(BIHistoryChannelConfig.class)).getOnboarding()).orElse(true).booleanValue()) {
                log.info(() -> String.format("Skipping export of policy %s because history channel is in onboarding mode.", this.getPropertyInParent().getName()));
                this.setState(BDescriptorState.idle);
                return;
            }
            if (optChannel.map(h -> h.getPaused()).orElse(true).booleanValue()) {
                log.info(() -> String.format("Skipping export of policy %s because history channel is not in proper state.", this.getPropertyInParent().getName()));
                this.setState(BDescriptorState.idle);
                return;
            }
            this.executeInProgress();
            if (BCloudHistoryExportConfigContainer.LOGGER.isLoggable(Level.FINE)) {
                BCloudHistoryExportConfigContainer.LOGGER.fine("doExecute on " + this.getName());
            }
            ArrayList<BHistoryId> historyList = new ArrayList<BHistoryId>(this.getHistoryIdSet());
            int response = optChannel.get().sendHistories(historyList).get(10L, TimeUnit.MINUTES);
            if (response >= 0) {
                this.executeOk();
            } else {
                this.executeFail("Records not stored in the cloud");
            }
        }
        catch (CompletionException compExc) {
            this.executeFail("Exception while sending history ids: " + compExc.getMessage());
            BCloudHistoryExportConfigContainer.LOGGER.warning("Exception while sending history ids: " + compExc.getMessage());
        }
        catch (Exception exc) {
            this.executeFail("Exception while sending history ids: " + exc.getMessage());
        }
    }

    public Set<BHistoryId> getHistoryIdSet() {
        return new HashSet<Object>(Arrays.asList(this.getHistoryIds().getChildren(BHistoryId.class)));
    }

    public void executeOk() {
        this.setFaultCause("");
        this.setLastSuccess(Clock.time());
        this.setState(BDescriptorState.idle);
        this.retryInterval = this.getInitialRetryInterval();
        this.retryFailuresCount = 0;
        if (this.getStatus().isAlarm()) {
            BCloudHistoryExportConfig.processAlarmNormal(this.alarmSupport);
            this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)8, (boolean)false));
        }
        this.updateStatus();
    }

    public final void executeFail(String reason) {
        if (reason == null) {
            reason = "";
        }
        this.setLastFailure(Clock.time());
        this.setFaultCause(reason);
        this.setState(BDescriptorState.idle);
        if (this.getAlarmOnFailure() && !this.getStatus().isAlarm()) {
            boolean ackRequired = BCloudHistoryExportConfig.processAlarmOffnormal(this.alarmSupport, this.getAlarmSourceInfo(), reason);
            int newStatus = this.getStatus().getBits();
            newStatus |= 8;
            if (ackRequired) {
                newStatus |= 0x80;
            }
            this.setStatus(BStatus.make((int)newStatus));
        }
        this.updateStatus();
    }

    boolean retryReady() {
        if (++this.retryFailuresCount % this.retryInterval == 0) {
            this.retryInterval *= 2;
            if (this.retryInterval > this.getMaxRetryInterval()) {
                this.retryInterval = this.getMaxRetryInterval();
            }
            this.retryFailuresCount = 0;
            return true;
        }
        return false;
    }

    static void processAlarmNormal(AlarmSupport support) {
        try {
            support.toNormal(null);
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Cannot process normal alarm:" + ex.getLocalizedMessage(), log.isLoggable(Level.FINE) ? ex : null);
        }
    }

    static boolean processAlarmOffnormal(AlarmSupport support, BAlarmSourceInfo info, String reason) {
        boolean ackRequired = false;
        try {
            ackRequired = support.isAckRequired(BSourceState.offnormal);
            BFacets alarmData = info.makeAlarmData(BSourceState.offnormal);
            String msgText = alarmData.gets("msgText", "");
            alarmData = BFacets.make((BFacets)alarmData, (String)"msgText", (BIDataValue)BString.make((String)(msgText + '\n' + reason)));
            support.newOffnormalAlarm(alarmData);
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Cannot process off normal alarm:" + ex.getLocalizedMessage(), log.isLoggable(Level.FINE) ? ex : null);
        }
        return ackRequired;
    }

    public final BBoolean doAckAlarm(BAlarmRecord ackRequest) {
        BBoolean alarmAck = BBoolean.make((boolean)BCloudHistoryExportConfig.processAlarmAck(this.alarmSupport, ackRequest));
        if (alarmAck.getBoolean()) {
            this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)128, (boolean)false));
        }
        return alarmAck;
    }

    static boolean processAlarmAck(AlarmSupport support, BAlarmRecord ackRequest) {
        try {
            return support.ackAlarm(ackRequest);
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Cannot process off alarm ack:" + ex.getLocalizedMessage(), log.isLoggable(Level.FINE) ? ex : null);
            return false;
        }
    }

    public Optional<BHistoriesChannel> getHistoriesChannel() {
        BComplex channel = this.getParent();
        if (channel != null && (channel = channel.getParent()) instanceof BHistoriesChannel) {
            return Optional.of((BHistoriesChannel)channel);
        }
        return Optional.empty();
    }

    public void addHistoryId(BHistoryId historyId) {
        this.getHistoryIds().add(SlotPath.escape((String)historyId.toString()), (BValue)historyId);
    }

    public void addHistoryIds(List<BHistoryId> historyIds) {
        for (BHistoryId historyId : historyIds) {
            this.addHistoryId(historyId);
        }
    }

    private static BAlarmSourceInfo initAlarmSourceInfo() {
        BAlarmSourceInfo asi = new BAlarmSourceInfo();
        asi.setSourceName(BFormat.make((String)"CloudLink %parent.parent.parent.displayName% %parent.displayName%"));
        asi.setToOffnormalText(BFormat.make((String)"%lexicon(cloudLink:history.export.failure)%"));
        asi.setToNormalText(BFormat.make((String)"%lexicon(cloudLink:history.export.success)%"));
        return asi;
    }
}

