/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.file;

import com.tridium.nre.security.PBEDecryptingInputStream;
import com.tridium.nre.security.SecretChars;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.baja.agent.AgentList;
import javax.baja.file.BDataFile;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.FileExt;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.FileUtil;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(ext={@FileExt(name="edist2")})
public class BEncryptedDistributionFile
extends BDataFile {
    public static final Type TYPE = Sys.loadType(BEncryptedDistributionFile.class);
    private static final Pattern EDIST_PATTERN = Pattern.compile("\\.edist2$", 2);
    private static final Logger log = Logger.getLogger("cloudLink.channel.backup");
    private static final BIcon ICON = BIcon.std((String)"modules.png");
    private static final String MIME_TYPE = "application/vnd.tridium.baja.v0+edist2";

    public Type getType() {
        return TYPE;
    }

    public BEncryptedDistributionFile(BIFileStore store) {
        super(store);
    }

    public BEncryptedDistributionFile() {
    }

    public String getMimeType() {
        return MIME_TYPE;
    }

    public BIcon getIcon() {
        return ICON;
    }

    public AgentList getAgents(Context cx) {
        AgentList agents = super.getAgents(cx);
        agents.toBottom("web:FileDownloadView");
        return agents;
    }

    @NiagaraRpc(permissions="R", isSecure=true, transports={@Transport(type=TransportType.box)})
    public boolean isDistFileAvailable(Context cx) {
        return this.getFileSpace().findFile(this.getDistFilePath()) != null;
    }

    private FilePath getDistFilePath() {
        return this.getFilePath().getParent().merge(BEncryptedDistributionFile.toDistFileName(this.getFilePath().getName()));
    }

    private FilePath getTmpFilePath() {
        return this.getFilePath().getParent().merge(BEncryptedDistributionFile.toTmpFileName(this.getFilePath().getName()));
    }

    public static String toDistFileName(String eDistFileName) {
        return EDIST_PATTERN.matcher(eDistFileName.trim()).replaceFirst(".dist");
    }

    private static String toTmpFileName(String eDistFileName) {
        return EDIST_PATTERN.matcher(eDistFileName.trim()).replaceFirst(".tmp");
    }

    @NiagaraRpc(permissions="RW", isSecure=true, transports={@Transport(type=TransportType.box)})
    public String decryptToDist(String passphrase, Context cx) {
        BIFile newFile = null;
        try {
            log.fine("Attempting to decrypt a DIST file");
            FilePath distFilePath = this.getDistFilePath();
            FilePath tmpFilePath = this.getTmpFilePath();
            newFile = this.getFileSpace().makeFile(tmpFilePath);
            try (SecretChars secret = new SecretChars(passphrase.toCharArray(), false);
                 PBEDecryptingInputStream in = new PBEDecryptingInputStream(this.getInputStream(), secret);
                 BufferedOutputStream out = new BufferedOutputStream(newFile.getOutputStream());){
                FileUtil.pipe((InputStream)in, (OutputStream)out);
            }
            log.fine("Successfully decrypted to temporary DIST file: " + newFile.getNavOrd());
            BIFile oldDistFile = this.getFileSpace().findFile(distFilePath);
            if (oldDistFile != null) {
                log.fine("Attempting to delete old DIST file");
                oldDistFile.delete();
            }
            this.getFileSpace().move(tmpFilePath, distFilePath);
            BIFile finishedFile = this.getFileSpace().findFile(distFilePath);
            if (finishedFile == null) {
                return "";
            }
            BOrd ord = finishedFile.getOrdInSession();
            if (ord == null) {
                return "";
            }
            return ord.toString();
        }
        catch (IOException | SecurityException ex) {
            log.log(Level.INFO, "Unable to decrypt backup", log.isLoggable(Level.FINE) ? ex : null);
            try {
                if (newFile != null) {
                    newFile.delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return "";
        }
    }
}

