/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.command;

import com.tridium.cloudLink.CloudLinkUtils;
import com.tridium.cloudLink.command.BCommand;
import javax.baja.control.BControlPoint;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.Context;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public abstract class BSubscribePointCommand
extends BCommand {
    public static final Type TYPE = Sys.loadType(BSubscribePointCommand.class);
    private static final CloudPointSubscriber cloudPointSubscriber = new CloudPointSubscriber();

    @Override
    public Type getType() {
        return TYPE;
    }

    protected Boolean subscribePoint(String messageId, String pointId, Context cx) {
        BControlPoint point = CloudLinkUtils.findPoint(messageId, pointId);
        if (point != null && CloudLinkUtils.isPointReadAllowed(point, cx)) {
            cloudPointSubscriber.subscribe((BComponent)point);
            return true;
        }
        return false;
    }

    protected Boolean unSubscribePoint(String messageId, String pointId, Context cx) {
        BControlPoint point = CloudLinkUtils.findPoint(messageId, pointId);
        if (point != null && CloudLinkUtils.isPointReadAllowed(point, cx)) {
            cloudPointSubscriber.unsubscribe((BComponent)point);
            return true;
        }
        return false;
    }

    static class CloudPointSubscriber
    extends Subscriber {
        CloudPointSubscriber() {
        }

        public void event(BComponentEvent bComponentEvent) {
        }
    }
}

