/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.command;

import com.tridium.cloudLink.CloudLinkUtils;
import com.tridium.cloudLink.command.BCloudWriteInfo;
import com.tridium.cloudLink.command.BCommand;
import javax.baja.control.BControlPoint;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public abstract class BClearPointCommand
extends BCommand {
    public static final Type TYPE = Sys.loadType(BClearPointCommand.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    protected boolean clearPoint(String messageId, String pointId, int priority, Context cx) {
        if (priority < 2 || priority > 16) {
            log.info("Attempt to clear point with invalid priority, aborting " + messageId);
            return false;
        }
        BControlPoint point = CloudLinkUtils.findPoint(messageId, pointId);
        if (point == null || !CloudLinkUtils.isPointWriteAllowed(point, cx)) {
            log.info("Insufficient permissions to clear point, aborting " + messageId);
            return false;
        }
        String targetName = "In" + priority;
        String name = "cloudWrite" + targetName;
        Property property = point.getProperty(name);
        if (property == null) {
            log.info("Attempt to clear point at priority level that is not set " + messageId);
            return false;
        }
        BValue value = point.get(property);
        if (!(value instanceof BCloudWriteInfo)) {
            log.info(() -> String.format("Unexpected object type %s in cloud write property %s", value.getType().getDisplayName(null), messageId));
            return false;
        }
        ((BCloudWriteInfo)value).doClearCloudWrite();
        actionLog.config(() -> String.format("Message id %s: point id %s is being cleared at %s by %s", messageId, pointId, targetName, cx.getUser().getUsername()));
        return true;
    }
}

