/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.command;

import com.tridium.cloudLink.alarm.BCloudAlarmAcknowledger;
import com.tridium.cloudLink.command.BCommand;
import com.tridium.cloudLink.msg.AckAlarmResult;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.BUuid;

@NiagaraType
@NiagaraProperty(name="acknowledger", type="BCloudAlarmAcknowledger", defaultValue="new BCloudAlarmAcknowledger()", flags=5)
public abstract class BAckAlarmCommand
extends BCommand {
    public static final Property acknowledger = BAckAlarmCommand.newProperty((int)5, (BValue)new BCloudAlarmAcknowledger(), null);
    public static final Type TYPE = Sys.loadType(BAckAlarmCommand.class);
    private static final String ackAppId = "CloudAcknowledgerAppID";
    private static final String ackAppName = "CloudAcknowledgerName";

    public BCloudAlarmAcknowledger getAcknowledger() {
        return (BCloudAlarmAcknowledger)this.get(acknowledger);
    }

    public void setAcknowledger(BCloudAlarmAcknowledger v) {
        this.set(acknowledger, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.getAcknowledger().setAckAlarmsFromSameSource(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AckAlarmResult acknowledgeAlarm(String messageId, String alarmId, String appId, String appName, Context cx) {
        String string;
        BUuid uuid;
        try {
            uuid = BUuid.make((String)alarmId);
        }
        catch (Exception e) {
            log.warning(() -> String.format("Unable to ack alarm, invalid alarm id format %s %s", alarmId, messageId));
            return new AckAlarmResult(false, "The alarm with id " + alarmId + " has invalid format");
        }
        int totalFailures = this.getAcknowledger().getTotalAlarmAckedFailures();
        BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        BUser user = cx.getUser();
        try (AlarmDbConnection conn = alarmService.getAlarmDb().getDbConnection(null);){
            BAlarmRecord rec = conn.getRecord(uuid);
            if (rec == null) {
                log.info(() -> String.format("Unable to ack alarm, Could not find alarm with id %s, message id %s", alarmId, messageId));
                AckAlarmResult ackAlarmResult = new AckAlarmResult(false, "Could not find alarm with id " + alarmId);
                return ackAlarmResult;
            }
            if (!BAckAlarmCommand.hasAlarmAckPermissions(alarmService, rec, user)) {
                log.warning(() -> String.format("Failure to acknowledge alarm with ID %s due to insufficient permission for user %s, message id %s", alarmId, user.getUsername(), messageId));
                AckAlarmResult ackAlarmResult = new AckAlarmResult(false, String.format("Insufficient permission to acknowledge alarm with ID %s", alarmId));
                return ackAlarmResult;
            }
            if (!rec.isAcknowledged()) {
                rec = (BAlarmRecord)rec.newCopy(true);
                BFacets ackFacets = BFacets.make((String)ackAppId, (BIDataValue)BString.make((String)appId), (String)ackAppName, (BIDataValue)BString.make((String)appName));
                rec.setAlarmData(BFacets.make((BFacets)rec.getAlarmData(), (BFacets)ackFacets));
                conn.update(rec);
                this.getAcknowledger().handleAlarm(uuid, user.getName());
                actionLog.config(() -> String.format("Message id %s: Alarm id %s is being acknowledged by %s", messageId, alarmId, user.getUsername()));
            }
        }
        catch (Exception ex) {
            log.warning(() -> String.format("Failure to acknowledge alarm (%s) %s %s", alarmId, ex, messageId));
            return new AckAlarmResult(false, String.format("Unable to ack alarm with ID %s, %s", alarmId, ex.getMessage()));
        }
        Boolean success = this.getAcknowledger().getTotalAlarmAckedFailures() == totalFailures;
        StringBuilder stringBuilder = new StringBuilder();
        if (success.booleanValue()) {
            string = "Acknowledged";
            return new AckAlarmResult(success, stringBuilder.append(string).append(" alarm with id ").append(alarmId).toString());
        }
        string = "Unable to acknowledge";
        return new AckAlarmResult(success, stringBuilder.append(string).append(" alarm with id ").append(alarmId).toString());
    }

    private static boolean hasAlarmAckPermissions(BAlarmService alarmService, BAlarmRecord alarmRec, BUser user) {
        BAlarmClass alarmClass = alarmService.lookupAlarmClass(alarmRec.getAlarmClass());
        BPermissions permissions = user.getPermissionsFor((BIProtected)alarmClass);
        return permissions.hasOperatorWrite() || permissions.hasAdminWrite();
    }
}

