/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.channel;

import com.tridium.cloudLink.auth.BAbstractClientAuthenticator;
import com.tridium.cloudLink.auth.BNullClientAuthenticator;
import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.channel.BTransportConfig;
import com.tridium.cloudLink.transport.BAbstractTransport;
import com.tridium.cloudLink.transport.BNullTransport;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.cloudLink.transport.MessageWrapper;
import com.tridium.util.CompUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public abstract class BMultiTransportChannelConfig
extends BChannelConfig {
    public static final Type TYPE = Sys.loadType(BMultiTransportChannelConfig.class);
    protected Map<String, BTransportConfig> operationMap = new HashMap<String, BTransportConfig>();
    protected static final Logger log = Logger.getLogger("cloudLink.channel.base");

    @Override
    public Type getType() {
        return TYPE;
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 11: {
                this.fwStarted();
                break;
            }
            case 2: {
                this.fwChanged((Property)a);
            }
        }
        return super.fw(x, a, b, c, d);
    }

    protected void fwStarted() {
        this.registerOps();
    }

    protected void fwChanged(Property prop) {
        if (!this.isRunning()) {
            return;
        }
        if (prop.getType() instanceof BTransportConfig) {
            this.registerOps();
        }
    }

    @Override
    public boolean isOperationSupported(String operation) {
        return this.operationMap.containsKey(operation);
    }

    @Override
    public BAbstractTransport getTransport(String operation) {
        BTransportConfig transportConfig = this.operationMap.get(operation);
        if (transportConfig == null) {
            log.config(() -> "No transport configuration found for " + operation);
            return new BNullTransport();
        }
        return transportConfig.getTransport();
    }

    @Override
    public BAbstractClientAuthenticator getAuthenticator(String operation) {
        BTransportConfig transportConfig = this.operationMap.get(operation);
        if (transportConfig == null) {
            log.config(() -> "No transport configuration found for " + operation);
            return new BNullClientAuthenticator();
        }
        return transportConfig.getAuthenticator();
    }

    @Override
    public int getMaxMessageSize(String operation) {
        BTransportConfig transportConfig = this.operationMap.get(operation);
        if (transportConfig == null) {
            log.config(() -> "No transport configuration found for " + operation);
            return -1;
        }
        return transportConfig.getMaxMessageSize();
    }

    @Override
    public void enqueueMessage(String operation, MessageWrapper<IMessage> wrapper) {
        BTransportConfig transportConfig = this.operationMap.get(operation);
        if (transportConfig == null) {
            log.config(() -> "No transport configuration found for " + operation);
            return;
        }
        transportConfig.getChannelQueue().enqueueMessage(wrapper);
    }

    @Override
    public void blockingEnqueueMessage(String operation, MessageWrapper<IMessage> wrapper) {
        BTransportConfig transportConfig = this.operationMap.get(operation);
        if (transportConfig == null) {
            log.config(() -> "No transport configuration found for " + operation);
            return;
        }
        transportConfig.getChannelQueue().blockingEnqueueMessage(wrapper);
    }

    @Override
    public boolean isQueueFull(String operation) {
        BTransportConfig transportConfig = this.operationMap.get(operation);
        if (transportConfig == null) {
            log.config(() -> "No transport configuration found for " + operation);
            return true;
        }
        return transportConfig.getChannelQueue().isFull();
    }

    @Override
    public boolean isQueueEmpty(String operation) {
        BTransportConfig transportConfig = this.operationMap.get(operation);
        if (transportConfig == null) {
            log.config(() -> "No transport configuration found for " + operation);
            return true;
        }
        return transportConfig.getChannelQueue().isEmpty();
    }

    @Override
    public void validateConfiguration(String prefix, StringBuilder err) {
        for (BTransportConfig transportConfig : (BTransportConfig[])CompUtil.getDescendants((BComponent)this, BTransportConfig.class)) {
            transportConfig.validateConfiguration(prefix, err);
        }
    }

    protected BAbstractTransport getTransport(BTransportConfig transportConfig) {
        return transportConfig.getTransport();
    }

    protected BAbstractClientAuthenticator getAuthenticator(BTransportConfig transportConfig) {
        return transportConfig.getAuthenticator();
    }

    protected void registerOps() {
        this.operationMap.clear();
        for (Property prop : this.getProperties()) {
            if (!BTransportConfig.class.isAssignableFrom(prop.getType().getTypeClass())) continue;
            this.operationMap.put(prop.getName(), (BTransportConfig)this.get(prop).as(BTransportConfig.class));
        }
    }
}

