/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.channel;

import com.tridium.cloudLink.BAbstractCloudLinkHandlerFactory;
import com.tridium.cloudLink.BCloudConnectionService;
import com.tridium.cloudLink.CloudLinkConstants;
import com.tridium.cloudLink.channel.BAbstractClientChannel;
import com.tridium.cloudLink.channel.BAbstractModelChannelConfig;
import com.tridium.cloudLink.file.FileUploadRequest;
import com.tridium.cloudLink.file.FileUploader;
import com.tridium.cloudLink.model.BModelExportPolicy;
import com.tridium.cloudLink.model.BModelExportPolicyContainer;
import com.tridium.cloudLink.msg.ISendModelEntitiesHandler;
import com.tridium.cloudLink.msg.ISendModelResult;
import com.tridium.cloudLink.transport.BAbstractTransport;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.cloudLink.transport.IMessageResponse;
import com.tridium.cloudLink.transport.MessageWrapper;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import javax.baja.job.BJob;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="channelType", type="BString", defaultValue="BString.make(CLOUD_LINK_CHANNEL_MODEL)", flags=1, override=true), @NiagaraProperty(name="policies", type="BModelExportPolicyContainer", defaultValue="new BModelExportPolicyContainer()", flags=256)})
public class BModelChannel
extends BAbstractClientChannel {
    public static final Property channelType = BModelChannel.newProperty((int)1, (BValue)BString.make((String)"Model"), null);
    public static final Property policies = BModelChannel.newProperty((int)256, (BValue)new BModelExportPolicyContainer(), null);
    public static final Type TYPE = Sys.loadType(BModelChannel.class);
    private static final Logger log = Logger.getLogger("cloudLink.channel.model");
    public static final String CONTEXT_PROP = "context";
    public static final String POLICY_PROP = "policy";
    public static final String AD_HOC_TAGS_PROP = "adHocTag";
    public static final String AD_HOC_RELATION_PROP = "adHocRelation";
    public static final String STATION_NAME_PROP = "stationName";
    protected static int logUpdateMoreFreq = 10;
    protected static int logUpdateLessFreq = 100;

    public BModelExportPolicyContainer getPolicies() {
        return (BModelExportPolicyContainer)this.get(policies);
    }

    public void setPolicies(BModelExportPolicyContainer v) {
        this.set(policies, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public CompletableFuture<Map<String, Object>> sendModel(BModelExportPolicy policy) {
        BJob job = policy.getJob();
        Optional<String> errMsg = this.checkChannelConfig();
        if (errMsg.isPresent()) {
            CompletableFuture<Map<String, Object>> exFuture = new CompletableFuture<Map<String, Object>>();
            exFuture.completeExceptionally(new IllegalStateException(errMsg.get()));
            return exFuture;
        }
        BAbstractModelChannelConfig config = (BAbstractModelChannelConfig)this.getChannelConfig();
        Optional<BCloudConnectionService> ccsOpt = this.getConnectionService();
        if (!ccsOpt.isPresent()) {
            CompletableFuture<Map<String, Object>> exFuture = new CompletableFuture<Map<String, Object>>();
            exFuture.completeExceptionally(new IllegalStateException("Unable to locate Cloud Connection Service."));
            return exFuture;
        }
        BCloudConnectionService ccs = ccsOpt.get();
        Map<String, Object> modelProps = this.makeModelProperties(policy);
        return ((CompletableFuture)config.openModel(job, ccs, modelProps).thenCompose(r -> {
            modelProps.putAll((Map<String, Object>)r);
            return CompletableFuture.allOf(this.encodeEntities(job, ccs, modelProps, policy).toArray(CloudLinkConstants.EMPTY_COMP_FUTURE_ARRAY));
        })).thenComposeAsync(r -> config.closeModel(job, ccs, modelProps));
    }

    @Override
    public BIcon getIcon() {
        return BIcon.make((String)lex.getText("ModelChannel.icon"));
    }

    @Override
    protected void propagateStatus() {
        BModelExportPolicyContainer[] containers;
        super.propagateStatus();
        for (BModelExportPolicyContainer container : containers = (BModelExportPolicyContainer[])this.getChildren(BModelExportPolicyContainer.class)) {
            BModelExportPolicy[] modelExportPolicies;
            for (BModelExportPolicy modelExportPolicy : modelExportPolicies = (BModelExportPolicy[])container.getChildren(BModelExportPolicy.class)) {
                modelExportPolicy.updateStatus();
            }
        }
    }

    protected List<CompletableFuture<ISendModelResult>> encodeEntities(BJob job, BCloudConnectionService ccs, Map<String, Object> modelProperties, BModelExportPolicy policy) {
        ArrayList<CompletableFuture<ISendModelResult>> compFutures = new ArrayList<CompletableFuture<ISendModelResult>>();
        try {
            BAbstractTransport transport = this.getChannelConfig().getTransport(ISendModelEntitiesHandler.getOperationId());
            if (!transport.canSend()) {
                throw new IllegalStateException(lex.getText("model.transport.error"));
            }
            int maxMsgSize = this.getChannelConfig().getMaxMessageSize(ISendModelEntitiesHandler.getOperationId());
            BAbstractCloudLinkHandlerFactory msgFactory = ccs.getMessageHandlerFactory(this.getPlatformType(), transport.getTransportType()).orElseThrow(() -> new IllegalStateException("Unable to locate message handler factory."));
            try (ISendModelEntitiesHandler messageHandler = msgFactory.getMessageHandler(ISendModelEntitiesHandler.class, this.getChannelConfig());){
                messageHandler.setProperties(Collections.unmodifiableMap(modelProperties));
                BAbstractModelChannelConfig.checkJobStatus(job);
                job.log().message("cloudLink", "model.encoding.entities.start");
                int numEnt = 0;
                while (policy.hasNext()) {
                    int size = messageHandler.add(policy.next());
                    BModelChannel.logEntity(++numEnt, job);
                    if (size < maxMsgSize) continue;
                    compFutures.add(this.sendMessage(messageHandler, transport, !policy.hasNext()));
                    BAbstractModelChannelConfig.checkJobStatus(job);
                }
                if (messageHandler.hasData()) {
                    compFutures.add(this.sendMessage(messageHandler, transport, true));
                    BAbstractModelChannelConfig.checkJobStatus(job);
                }
            }
            job.log().message("cloudLink", "model.encoding.entities.finish");
        }
        catch (Exception ex) {
            compFutures.forEach(f -> f.cancel(true));
            compFutures.clear();
            CompletableFuture extFut = new CompletableFuture();
            extFut.completeExceptionally(ex);
            compFutures.add(extFut);
        }
        return compFutures;
    }

    protected Map<String, Object> makeModelProperties(BModelExportPolicy policy) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        Context ctx = policy.getContext();
        properties.put(CONTEXT_PROP, ctx);
        properties.put(POLICY_PROP, policy);
        properties.put(STATION_NAME_PROP, Sys.getStation().getStationDisplayName(ctx));
        return properties;
    }

    protected CompletableFuture<ISendModelResult> sendMessage(ISendModelEntitiesHandler modelHandler, BAbstractTransport transport, boolean isFinal) {
        CompletableFuture<ISendModelResult> channelFuture = new CompletableFuture<ISendModelResult>();
        if (!this.isOperational()) {
            log.config("Unable to send model because channel is not operational");
            channelFuture.completeExceptionally(new RuntimeException("Unable to send model because channel is not operational"));
            return channelFuture;
        }
        IMessage message = modelHandler.toMessage(isFinal);
        if (message == null) {
            modelHandler.getFuture(channelFuture, null);
        } else if (message instanceof FileUploadRequest) {
            Optional optUploader = this.getConnectionService().flatMap(c -> c.getFileUploader(this));
            if (!optUploader.isPresent()) {
                log.warning("Unable to get file uploader to upload model file.");
                channelFuture.completeExceptionally(new Exception("unable to get file uploader"));
                return channelFuture;
            }
            FileUploader uploader = (FileUploader)optUploader.get();
            CompletableFuture<IMessageResponse> messageFuture = modelHandler.getFuture(channelFuture);
            uploader.upload((FileUploadRequest)message).whenComplete((resp, err) -> {
                if (err != null) {
                    messageFuture.completeExceptionally((Throwable)err);
                } else {
                    messageFuture.complete(null);
                }
            });
        } else {
            MessageWrapper<IMessage> wrapper = new MessageWrapper<IMessage>(message, modelHandler.getFuture(channelFuture), transport.getMessageRetries());
            AccessController.doPrivileged(() -> {
                this.getChannelConfig().enqueueMessage(ISendModelEntitiesHandler.getOperationId(), wrapper);
                return null;
            });
            transport.notifyPending();
        }
        return channelFuture;
    }

    private Optional<String> checkChannelConfig() {
        StringBuilder err = this.checkChannelConfigCommon(lex.get("cloudLink.model.error"));
        return err.length() > 0 ? Optional.of(err.substring(0, err.length() - 1)) : Optional.empty();
    }

    protected static void logEntity(int numComp, BJob job) {
        int logFreq;
        int n = logFreq = numComp <= logUpdateLessFreq ? logUpdateMoreFreq : logUpdateLessFreq;
        if (numComp % logFreq == 0) {
            job.log().message("cloudLink", "model.encoding.entities.processed.number", String.valueOf(numComp));
        }
    }
}

