/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.channel;

import com.tridium.cloudLink.BAbstractCloudLinkHandlerFactory;
import com.tridium.cloudLink.BCloudConnectionService;
import com.tridium.cloudLink.channel.BAbstractClientChannel;
import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.msg.ISendHeartbeatHandler;
import com.tridium.cloudLink.transport.BAbstractConnectedTransport;
import com.tridium.cloudLink.transport.BAbstractTransport;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.cloudLink.transport.MessageWrapper;
import com.tridium.nre.util.NamedThreadFactory;
import java.security.AccessController;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="channelType", type="BString", defaultValue="BString.make(CLOUD_LINK_CHANNEL_HEARTBEAT)", flags=1, override=true), @NiagaraProperty(name="frequency", type="BRelTime", defaultValue="BRelTime.make(300000L)", facets={@Facet(value="BFacets.make(BFacets.MIN, BRelTime.makeMinutes(1), BFacets.MAX, BRelTime.makeMinutes(1440))")}), @NiagaraProperty(name="timeoutThreshold", type="int", defaultValue="3", flags=4, facets={@Facet(name="BFacets.MIN", value="1")})})
@NiagaraAction(name="sendHeartbeat")
public class BHeartbeatChannel
extends BAbstractClientChannel
implements Runnable,
Callable<Boolean> {
    public static final Property channelType = BHeartbeatChannel.newProperty((int)1, (BValue)BString.make((String)"Heartbeat"), null);
    public static final Property frequency = BHeartbeatChannel.newProperty((int)0, (BValue)BRelTime.make((long)300000L), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeMinutes((int)1), (String)"max", (BIDataValue)BRelTime.makeMinutes((int)1440)));
    public static final Property timeoutThreshold = BHeartbeatChannel.newProperty((int)4, (int)3, (BFacets)BFacets.make((String)"min", (int)1));
    public static final Action sendHeartbeat = BHeartbeatChannel.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BHeartbeatChannel.class);
    private static final Logger log = Logger.getLogger("cloudLink.channel.heartbeat");
    private static final String HEARTBEAT_ERROR = "Could not send heartbeat";
    private static final int HEARTBEAT_TIMEOUT_MINUTES = 2;
    private ScheduledThreadPoolExecutor executor;
    private ScheduledFuture<?> heartbeatTaskFuture;
    private int timeoutCount;
    private int reconnectCount;
    private long reconnectTime;

    public BRelTime getFrequency() {
        return (BRelTime)this.get(frequency);
    }

    public void setFrequency(BRelTime v) {
        this.set(frequency, (BValue)v, null);
    }

    public int getTimeoutThreshold() {
        return this.getInt(timeoutThreshold);
    }

    public void setTimeoutThreshold(int v) {
        this.setInt(timeoutThreshold, v, null);
    }

    public void sendHeartbeat() {
        this.invoke(sendHeartbeat, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    @Override
    protected void fwStarted() {
        super.fwStarted();
        Optional<BCloudConnectionService> ccsOpt = this.getConnectionService();
        if (!ccsOpt.isPresent() || ccsOpt.get().isFatalFault()) {
            return;
        }
        log.finest(() -> "Heartbeat channel started");
        BCloudConnectionService ccs = ccsOpt.get();
        this.startExecutor();
        ccs.registerForConnectionServiceReady(() -> {
            if (this.isOperational()) {
                this.startTask();
            } else {
                log.finest(() -> "Heartbeat task not started because channel is disabled");
            }
        });
    }

    @Override
    protected void fwChanged(Property prop) {
        super.fwChanged(prop);
        if (!this.isRunning()) {
            return;
        }
        if (prop.equals(status)) {
            log.finest(() -> "Heartbeat channel 'status' property changed");
            if (!this.isOperational()) {
                this.stopTask(false);
            } else {
                this.startTask();
            }
        } else if (prop.equals(frequency)) {
            log.finest(() -> "Heartbeat channel 'frequency' property changed");
            if (this.isOperational()) {
                this.stopTask(false);
                this.startTask();
            } else {
                log.finest(() -> "Heartbeat task not started because channel is not operating");
            }
        }
    }

    @Override
    protected void fwStopped() {
        log.finest(() -> "Heartbeat channel stopped");
        this.stopExecutor();
        super.fwStopped();
    }

    protected void startExecutor() {
        log.finest(() -> "Heartbeat channel executor started");
        this.executor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("cloudLink.channel.heartbeat"));
    }

    protected void stopExecutor() {
        if (this.executor != null) {
            log.finest(() -> "Heartbeat channel executor stopped");
            try {
                this.executor.shutdownNow();
            }
            finally {
                this.executor = null;
                this.heartbeatTaskFuture = null;
            }
        }
    }

    protected void startTask() {
        log.finest(() -> "Heartbeat channel task started");
        if (this.executor != null) {
            if (this.heartbeatTaskFuture == null) {
                int rate = this.getFrequency().getMinutes();
                this.heartbeatTaskFuture = this.executor.scheduleAtFixedRate(this, rate, rate, TimeUnit.MINUTES);
            } else {
                log.finest("Heartbeat task start requested but it was already running");
            }
        } else {
            log.warning("Heartbeat channel task failed to start, no task executor");
        }
    }

    protected void stopTask(boolean mayInterruptIfRunning) {
        log.finest(() -> "Heartbeat channel task stopped");
        if (this.heartbeatTaskFuture != null) {
            try {
                this.heartbeatTaskFuture.cancel(mayInterruptIfRunning);
            }
            finally {
                this.heartbeatTaskFuture = null;
            }
        } else {
            log.warning("Heartbeat stop task was skipped, no task was scheduled");
        }
    }

    public void doSendHeartbeat() {
        this.scheduleSingleHeartbeat();
    }

    private ScheduledFuture<Boolean> scheduleSingleHeartbeat() {
        if (this.executor != null) {
            log.finest(() -> "Heartbeat channel one-time task started");
            return this.executor.schedule(this, 1L, TimeUnit.SECONDS);
        }
        log.warning("Heartbeat channel one-time task failed to start, no task executor");
        return null;
    }

    public CompletableFuture<Boolean> heartbeat() {
        boolean registered = this.getChannelConfig().getAuthenticator(ISendHeartbeatHandler.getOperationId()).isRegistered();
        if (!registered) {
            return CompletableFuture.completedFuture(false);
        }
        Optional<String> errMsg = this.checkChannelConfig();
        if (errMsg.isPresent()) {
            CompletableFuture<Boolean> rv = new CompletableFuture<Boolean>();
            rv.completeExceptionally(new IllegalStateException(errMsg.get()));
            return rv;
        }
        BAbstractTransport transport = this.getChannelConfig().getTransport(ISendHeartbeatHandler.getOperationId());
        if (!transport.canSend()) {
            CompletableFuture<Boolean> rv = new CompletableFuture<Boolean>();
            rv.complete(false);
            log.warning("Heartbeat message not sent because transport cannot send messages");
            return rv;
        }
        BAbstractCloudLinkHandlerFactory msgFactory = this.getConnectionService().orElseThrow(() -> new IllegalStateException("Unable to locate Cloud Connection Service.")).getMessageHandlerFactory(this.getPlatformType(), transport.getTransportType()).orElseThrow(() -> new IllegalStateException("Unable to locate message handler factory."));
        BChannelConfig config = this.getChannelConfig();
        ISendHeartbeatHandler heartbeatHandler = msgFactory.getMessageHandler(ISendHeartbeatHandler.class, config);
        CompletableFuture<Boolean> rv = this.sendMessage(heartbeatHandler, transport);
        return rv;
    }

    private CompletableFuture<Boolean> sendMessage(ISendHeartbeatHandler heartbeatHandler, BAbstractTransport transport) {
        CompletableFuture<Boolean> responseFuture = new CompletableFuture<Boolean>();
        MessageWrapper<IMessage> wrapper = new MessageWrapper<IMessage>(heartbeatHandler.toMessage(true), heartbeatHandler.getFuture(responseFuture), transport.getMessageRetries());
        AccessController.doPrivileged(() -> {
            this.getChannelConfig().enqueueMessage(ISendHeartbeatHandler.getOperationId(), wrapper);
            return null;
        });
        transport.notifyPending();
        return responseFuture;
    }

    private Optional<String> checkChannelConfig() {
        StringBuilder err = this.checkChannelConfigCommon(HEARTBEAT_ERROR);
        return err.length() > 0 ? Optional.of(err.substring(0, err.length() - 1)) : Optional.empty();
    }

    @Override
    public void run() {
        CompletableFuture<Boolean> future = null;
        int timeout = this.getTimeout();
        try {
            future = this.heartbeat();
            Boolean result = future.get(timeout, TimeUnit.SECONDS);
            if (result.booleanValue()) {
                this.setStatus(BStatus.makeDown((BStatus)this.getStatus(), (boolean)false));
                this.setFaultCause("");
                this.timeoutCount = 0;
            } else {
                this.setStatus(BStatus.makeDown((BStatus)this.getStatus(), (boolean)true));
                this.setFaultCause("Heartbeat message failed.");
            }
        }
        catch (ExecutionException exExcept) {
            Throwable cause = exExcept.getCause();
            log.log(Level.WARNING, "Heartbeat send task failed with exception ", log.isLoggable(Level.FINE) ? cause : null);
            this.setStatus(BStatus.makeDown((BStatus)this.getStatus(), (boolean)true));
            this.setFaultCause(cause.getLocalizedMessage());
        }
        catch (InterruptedException interExcept) {
            log.warning("Heartbeat send task was interrupted");
            this.setStatus(BStatus.makeDown((BStatus)this.getStatus(), (boolean)true));
            this.setFaultCause("Heartbeat send task was interrupted");
        }
        catch (TimeoutException ex) {
            BAbstractTransport transport;
            log.warning(() -> "Heartbeat send task timed out, no response after" + timeout + " seconds");
            this.setStatus(BStatus.makeDown((BStatus)this.getStatus(), (boolean)true));
            this.setFaultCause("Heartbeat send task timed out, no response");
            if (future != null) {
                future.cancel(true);
            }
            if (++this.timeoutCount > this.getTimeoutThreshold() && (transport = this.getChannelConfig().getTransport(ISendHeartbeatHandler.getOperationId())) instanceof BAbstractConnectedTransport) {
                log.fine("exceeded threshold for heartbeat timeouts, reconnecting.");
                ((BAbstractConnectedTransport)transport).reconnect();
                this.timeoutCount = 0;
                ++this.reconnectCount;
                this.reconnectTime = BAbsTime.now().getMillis();
            }
        }
        catch (RuntimeException except) {
            log.log(Level.WARNING, "A runtime exception occurred while sending the Heartbeat message", log.isLoggable(Level.FINE) ? except : null);
            this.setStatus(BStatus.makeDown((BStatus)this.getStatus(), (boolean)true));
            this.setFaultCause(except.getLocalizedMessage());
        }
        catch (Error error) {
            log.log(Level.WARNING, "An error occurred while sending the Heartbeat message", log.isLoggable(Level.FINE) ? error : null);
            this.setStatus(BStatus.makeDown((BStatus)this.getStatus(), (boolean)true));
            this.setFaultCause(error.getLocalizedMessage());
        }
    }

    @Override
    public Boolean call() throws Exception {
        Boolean result;
        block6: {
            CompletableFuture<Boolean> future = null;
            result = false;
            try {
                future = this.heartbeat();
                result = future.get(2L, TimeUnit.MINUTES);
                if (result.booleanValue()) {
                    log.info("Heartbeat one-time send task was successful");
                } else {
                    log.warning("Heartbeat one-time send task failed");
                }
            }
            catch (ExecutionException exExcept) {
                Throwable cause = exExcept.getCause();
                log.log(Level.WARNING, "Heartbeat one-time send task failed with exception ", log.isLoggable(Level.FINE) ? cause : null);
            }
            catch (InterruptedException interExcept) {
                log.warning("Heartbeat one-time send task was interrupted");
            }
            catch (TimeoutException e) {
                log.warning(() -> "Heartbeat one-time send task timed out, no response after2 minutes");
                if (future == null) break block6;
                future.cancel(true);
            }
        }
        return result;
    }

    @Override
    public BIcon getIcon() {
        return BIcon.make((String)lex.getText("HeartbeatChannel.icon"));
    }

    public void spy(SpyWriter out) throws Exception {
        out.startProps("Heartbeat Channel");
        out.prop((Object)"Heartbeat timeout seconds", this.getTimeout());
        out.prop((Object)"Heartbeat timeouts", this.timeoutCount);
        out.prop((Object)"Timeout threshold", this.getTimeoutThreshold());
        out.prop((Object)"Timeout based reconnect attempts", this.reconnectCount);
        out.prop((Object)"Last reconnect attempt time", (Object)BAbsTime.make((long)this.reconnectTime).encodeToString());
        out.endProps();
        super.spy(out);
    }

    private int getTimeout() {
        return this.getFrequency().getSeconds() / 4 * 3;
    }
}

