/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.auth;

import com.tridium.nre.security.SecurityInitializer;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.function.Supplier;

public class RsaKeyPairGeneratorSupplier
implements Supplier<KeyPairGenerator> {
    protected static final String RSA_ALGORITHM = "RSA";
    protected static final int KEY_SIZE = 2048;

    @Override
    public KeyPairGenerator get() {
        KeyPairGenerator keyGen;
        try {
            Provider provider = SecurityInitializer.getInstance().getCryptoProvider().getProvider();
            keyGen = this.makeKeyPairGenerator(RSA_ALGORITHM, provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        keyGen.initialize(2048);
        return keyGen;
    }

    protected KeyPairGenerator makeKeyPairGenerator(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        return KeyPairGenerator.getInstance(algorithm, provider);
    }
}

