/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.auth;

import com.tridium.cloudLink.auth.AbstractKeyStoreHelper;
import java.nio.charset.StandardCharsets;
import java.security.KeyPairGenerator;
import java.util.UUID;
import java.util.function.Supplier;
import javax.baja.security.crypto.IKeyStore;
import org.jose4j.jws.JsonWebSignature;

public final class JwsKeyStoreHelper
extends AbstractKeyStoreHelper {
    private final String algorithm;

    public JwsKeyStoreHelper(IKeyStore keyStore, String alias, String subject, Supplier<KeyPairGenerator> keyPairGenSupplier, String signingAlgorithm) throws Exception {
        super(keyStore, alias, subject, keyPairGenSupplier);
        this.initialize();
        this.algorithm = signingAlgorithm;
    }

    @Override
    public byte[] sign(byte[] jwtClaims) throws Exception {
        this.initialize();
        log.fine("Creating a JWS signed with the software private key");
        JsonWebSignature jws = new JsonWebSignature();
        jws.setAlgorithmHeaderValue(this.algorithm);
        jws.setPayloadBytes(jwtClaims);
        jws.setKeyIdHeaderValue(UUID.randomUUID().toString());
        jws.setKey(this.keyStore.getKey(this.alias, EMPTY_CHARS));
        return jws.getCompactSerialization().getBytes(StandardCharsets.UTF_8);
    }
}

