/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.auth;

import com.tridium.cloudLink.auth.IKeyStoreHelper;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertificateException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.baja.nre.security.HsmManager;

public final class HsmSignatureKeyStoreHelper
implements IKeyStoreHelper {
    private static final Logger log = Logger.getLogger("cloudLink.auth.key");
    public static final String HSM_NAME = "NiagaraHsm";
    public static final String HSM_PUBLIC_KEY_ALIAS = "public_0";
    public static final String HSM_PRIVATE_KEY_ALIAS = "private_0";
    private final KeyStore keyStore;
    private final Supplier<Signature> signatureSupplier;
    private final PublicKey publicKey;

    public HsmSignatureKeyStoreHelper(KeyStore keyStore, Supplier<Signature> signatureSupplier) throws Exception {
        this.keyStore = keyStore;
        this.signatureSupplier = signatureSupplier;
        this.publicKey = (PublicKey)keyStore.getKey(HSM_PUBLIC_KEY_ALIAS, null);
    }

    @Override
    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public void deleteKeyEntry() throws Exception {
        log.config("Deleting a hardware security manager key pair is not supported");
    }

    @Override
    public byte[] sign(byte[] content) throws Exception {
        log.fine("Signing content with the hardware security manager private key");
        Signature signer = this.signatureSupplier.get();
        signer.initSign((PrivateKey)this.keyStore.getKey(HSM_PRIVATE_KEY_ALIAS, null));
        signer.update(content);
        return signer.sign();
    }

    public static Optional<KeyStore> getHsmKeyStore(HsmManager hsmManager, Supplier<KeyStore> keyStoreSupplier) throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException {
        Optional<KeyStore> keyStoreOpt;
        Objects.requireNonNull(hsmManager);
        Objects.requireNonNull(keyStoreSupplier);
        if (hsmManager.hasHsmEngine()) {
            KeyStore keyStore = keyStoreSupplier.get();
            keyStore.load(null, null);
            keyStoreOpt = Optional.of(keyStore);
            log.fine("Hardware security module support verified.");
        } else {
            keyStoreOpt = Optional.empty();
            log.fine("No hardware security module support.");
        }
        return keyStoreOpt;
    }
}

