/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.auth;

import com.tridium.cloudLink.BCloudConnectionService;
import com.tridium.cloudLink.msg.IMessageBuilder;
import com.tridium.cloudLink.transport.HttpRequestMessage;
import com.tridium.cloudLink.transport.IMessage;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FederatedIdentityDeviceProvisioningInfoRequest
implements IMessageBuilder {
    private final String eTag;
    private final String certAlias;
    private URL url;
    private static final Logger log = Logger.getLogger("cloudLink.auth.federated");
    private static final String IF_NONE_MATCH = "If-None-Match";
    private static final String API_PATH = "/api/v1/deviceprovisioning/versions/%s/manifests";

    public FederatedIdentityDeviceProvisioningInfoRequest(String server, String provisioningId, String certAlias) {
        try {
            this.url = new URL(String.format("https://" + server + API_PATH, BCloudConnectionService.TYPE.getVendorVersion().toString()));
        }
        catch (MalformedURLException ex) {
            log.log(Level.INFO, "Unable to build URL for device provisioning info request", log.isLoggable(Level.FINE) ? ex : null);
        }
        this.eTag = provisioningId;
        this.certAlias = certAlias;
    }

    @Override
    public IMessage toMessage(boolean isFinal) {
        String correlationId = UUID.randomUUID().toString();
        log.config(() -> "Sending device provisioning info request with correlation " + correlationId);
        HashMap<String, Object> requestHeaders = new HashMap<String, Object>();
        requestHeaders.put("x-activity-id", correlationId);
        if (this.eTag != null && !this.eTag.isEmpty()) {
            requestHeaders.put(IF_NONE_MATCH, this.eTag);
        }
        return new HttpRequestMessage.HttpRequestMessageBuilder(HttpRequestMessage.HttpMethod.GET, this.url, requestHeaders).certAlias(this.certAlias).build();
    }
}

