/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink;

import com.tridium.clUtils.DiscoveryUtils;
import com.tridium.util.EscUtil;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.baja.registry.TypeInfo;
import javax.baja.tag.BIEntity;
import javax.baja.tag.Id;
import javax.baja.util.BTypeSpec;

public final class CloudLinkConstants {
    public static final Function<BIEntity, String> CLOUD_ID_FUNCTION = e -> DiscoveryUtils.makeCloudId();
    public static final String CLOUD_LINK_TAG_DICT_NAMESPACE = "nc";
    public static final String CLOUD_LINK_TAG_DICT_PALETTE = "module://cloudLink/module.palette|slot:/Tag$20Dictionary/Niagara$20Cloud";
    public static final String CLOUD_LINK_TAG_DICT_VERSION = "1.0.3";
    public static final String CLOUD_ID_TAG_NAME = "cloudId";
    public static final String CLOUD_ID_TAG = "nc:cloudId";
    public static final Id CLOUD_ID = Id.newId((String)"nc:cloudId");
    public static final String ESCAPED_CLOUD_ID_TAG = EscUtil.slot.escape("nc:cloudId");
    public static final String EXCLUDED_TAG = "nc:excluded";
    public static final Id EXCLUDED = Id.newId((String)"nc:excluded");
    public static final String DATA_TYPE_TAG_NAME = "dataType";
    public static final String DATA_TYPE_TAG = "nc:dataType";
    public static final Id DATA_TYPE = Id.newId((String)"nc:dataType");
    public static final String ESCAPED_DATA_TYPE_TAG = EscUtil.slot.escape("nc:dataType");
    public static final String DATA_TYPE_NUMERIC = "numeric";
    public static final String DATA_TYPE_BOOLEAN = "boolean";
    public static final String DATA_TYPE_ENUM = "enum";
    public static final String DATA_TYPE_STRING = "string";
    public static final String DATA_TYPE_OTHER = "other";
    public static final String DRIVER_ID_RULE_TAG_NAME = "driverPointId";
    public static final String TELEMETRY_ID_TAG_NAME = "telemetryId";
    public static final String TELEMETRY_ID_TAG = "nc:telemetryId";
    public static final Id TELEMETRY_ID = Id.newId((String)"nc:telemetryId");
    public static final String ESCAPED_TELEMETRY_ID_TAG = EscUtil.slot.escape("nc:telemetryId");
    public static final String WRITABLE_LEVELS_TAG_NAME = "writableLevels";
    public static final String WRITABLE_LEVELS_TAG = "nc:writableLevels";
    public static final Id WRITABLE_LEVELS = Id.newId((String)"nc:writableLevels");
    public static final String EBI_POINT_TAG_RULE_NAME = "EBI$20Proxy$20Point$20Tags";
    public static final String EBI_HISTORY_TAG_RULE_NAME = "EBI$20History$20Import$20Tags";
    public static final String EBI_CONNECTOR_PROXY_EXT_TYPESPEC = "ebiConnector:EbiConnectorProxyExt";
    public static final String EBI_CLOUD_ID_RULE_SLOT_NAME_1 = "tagName";
    public static final String EBI_CLOUD_ID_RULE_SLOT_NAME_2 = "parameterName";
    public static final String EBI_CONNECTOR_HISTORY_IMPORT_TYPESPEC = "ebiConnector:EbiConnectorStandardHistoryImport";
    public static final String CLOUD_LINK_TRANSPORT_AMQP = "AMQP";
    public static final String CLOUD_LINK_TRANSPORT_HTTP = "HTTP";
    public static final String CLOUD_LINK_TRANSPORT_MQTT_V3 = "MQTT3";
    public static final String CLOUD_LINK_TRANSPORT_MQTT_V5 = "MQTT5";
    public static final String CLOUD_LINK_TRANSPORT_NIAGARA_REMOTE = "NIAGARA_REMOTE";
    public static final int DEFAULT_MIN_MESSAGE_SIZE = 10000;
    public static final int DEFAULT_MAX_MESSAGE_SIZE = 10000000;
    public static final int DEFAULT_MESSAGE_TIMEOUT = 60000;
    public static final int MIN_MESSAGE_TIMEOUT = 1000;
    public static final int MAX_MESSAGE_TIMEOUT = 300000;
    public static final int DEFAULT_MESSAGE_RETRIES = 2;
    public static final int MAX_MESSAGE_RETRIES = 10;
    public static final int DEFAULT_PENDING_MESSAGES = 50;
    public static final String CLOUD_LINK_CHANNEL_ALARM = "Alarm";
    public static final String CLOUD_LINK_CHANNEL_BACKUP = "Backup";
    public static final String CLOUD_LINK_CHANNEL_COMMAND = "Command";
    public static final String CLOUD_LINK_CHANNEL_EVENT = "Event";
    public static final String CLOUD_LINK_CHANNEL_HEARTBEAT = "Heartbeat";
    public static final String CLOUD_LINK_CHANNEL_HISTORY = "History";
    public static final String CLOUD_LINK_CHANNEL_MESSAGING = "Messaging";
    public static final String CLOUD_LINK_CHANNEL_MODEL = "Model";
    public static final String CLOUD_LINK_CHANNEL_NULL = "Null";
    public static final String CLOUD_LINK_CHANNEL_POINT = "Point";
    public static final String OP_ALARM_SEND = "sendAlarm";
    public static final String OP_COMMAND_REGISTER = "registerCommands";
    public static final String OP_COMMAND_RESPONSE = "commandResponse";
    public static final String OP_EVENT_SEND = "sendEvent";
    public static final String OP_FILE_END_UPLOAD = "endFileUpload";
    public static final String OP_FILE_START_UPLOAD = "startFileUpload";
    public static final String OP_HEARTBEAT_SEND = "sendHeartbeat";
    public static final String OP_HISTORY_GET_TIMESTAMP = "getLastTimestamp";
    public static final String OP_HISTORY_GET_DATA = "getHistoryData";
    public static final String OP_HISTORY_SEND_DATA = "sendHistoryData";
    public static final String OP_HISTORY_SEND_BULK_DATA = "sendHistoryBulkData";
    public static final String OP_POINT_SEND = "sendPoints";
    public static final String OP_UPLOAD_MODEL_FILE = "uploadModelFile";
    public static final String OP_MODEL_OPEN_SEND = "sendOpenModel";
    public static final String OP_MODEL_CLOSE_SEND = "sendCloseModel";
    public static final String OP_MODEL_SEND = "sendModel";
    public static final String OP_MODEL_DELETE = "deleteModel";
    public static final String OP_MODEL_GET_INGESTION_STATUS = "getModelIngestionStatus";
    public static final int COMMAND_OK = 100;
    public static final int COMMAND_DONE = 110;
    public static final int COMMAND_FAILURE = 120;
    public static final int COMMAND_TIMEOUT = 130;
    public static final int COMMAND_UNAVAILABLE = 140;
    public static final String MIME_TYPE_APPLICATION_JSON = "application/json";
    public static final String MIME_TYPE_APPLICATION_JSON_GZIP = "application/json+gzip";
    public static final String MIME_TYPE_APPLICATION_JSON_CHARSET_UTF8 = "application/json; charset=utf-8";
    public static final String MIME_TYPE_APPLICATION_FORM_URLENCODED = "application/x-www-form-urlencoded";
    public static final String MIME_TYPE_APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String MIME_TYPE_APPLICATION_XML = "application/xml";
    public static final String MIME_TYPE_APPLICATION_OCSP_REQUEST = "application/ocsp-request";
    public static final String HTTPS = "https://";
    public static final String ACTIVITY_ID = "x-activity-id";
    public static final String CERT_ALIAS = "cert-alias";
    public static final String CONTENT_TYPE = "content-type";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String MESSAGE_CONTENT_TYPE = "MessageContentType";
    public static final String RETRY_AFTER = "retry-after";
    public static final String SYSTEM_ID = "SystemId";
    public static final String NIAGARA_SYSTEM_ID_SEPARATOR = ":";
    public static final String AUTH_PLATFORM_TYPE_FEDERATED = "FederatedIdentity";
    public static final String AUTH_PLATFORM_TYPE_PASSWORD = "Password";
    public static final String AUTH_PLATFORM_TYPE_TOKEN = "Token";
    public static final String KEY_PREFIX = "Cloud_";
    public static final String CLIENT_ID = "clientId";
    public static final String HOST_NAME = "hostName";
    public static final String ID = "id";
    public static final String TOKEN = "token";
    public static final String FDA_BOOTSTRAP_KEY_PREFIX = "FedIdBootstrap_";
    public static final String FDA_ROLLING_KEY_PREFIX = "FedId_";
    public static final String NO_CONNECTION_SERVICE = "Unable to locate Cloud Connection Service.";
    public static final String NO_HANDLER_FACTORY = "Unable to locate message handler factory.";
    public static final String NO_CHANNEL = "Unable to locate channel: %s";
    public static final String JWT_ALGORITHM = "alg";
    public static final String JWT_ISSUER = "iss";
    public static final String JWT_AUDIENCE = "aud";
    public static final String JWT_EXPIRATION = "exp";
    public static final String JWT_NOT_BEFORE = "nbf";
    public static final String JWT_SYSTEM_TYPE = "SystemType";
    public static final String CLOUD_AUTHENTICATION_SCHEME = "cloudAuthenticationScheme";
    public static final String JWT_CLAIMS_DEVICE_ID = "deviceid";
    public static final String JWT_CLAIMS_CLOUD_ROLES = "cloudroles";
    public static final String JWT_CLAIMS_USERNAME = "username";
    public static final String JWT_CLAIMS_CUSTOM_ATTRIBUTES = "custom_attributes";
    public static final String ECDSA_SHA256_ALGORITHM = "SHA256withECDSA";
    public static final String ECDSA_SHA256_HSM_ALGORITHM = "SHA256WITHECDSA.NiagaraHsm";
    public static final String RSA_ALGORITHM = "RSA";
    public static final byte[] EMPTY_BYTES = new byte[0];
    public static final CompletableFuture<?>[] EMPTY_COMP_FUTURE_ARRAY = new CompletableFuture[0];
    public static final String ALARM_SOURCE_NAME = "CloudLink %parent.parent.parent.displayName% %parent.displayName%";
    public static final TypeInfo NIAGARA_SYSTEM_HISTORY_IMPORT_TYPEINFO = BTypeSpec.make((String)"niagaraDriver", (String)"NiagaraSystemHistoryImport").getTypeInfo();
    public static final int NOTE_MAX_CHARS = 1024;

    private CloudLinkConstants() {
    }
}

