/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.msg;

import com.tridium.cloudLink.auth.BFederatedIdentityAuthenticator;
import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.forge.channel.BForgeHistoryChannelConfig;
import com.tridium.cloudLink.forge.msg.ForgeHttpGetHistoriesResult;
import com.tridium.cloudLink.msg.GetHistoriesResult;
import com.tridium.cloudLink.msg.IGetHistoriesHandler;
import com.tridium.cloudLink.transport.HttpRequestMessage;
import com.tridium.cloudLink.transport.HttpResponseMessage;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.cloudLink.transport.IMessageResponse;
import com.tridium.json.JSONWriter;
import com.tridium.json.quick.QuickJSONWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.sys.BAbsTime;

public class ForgeHttpGetHistoriesHandler
implements IGetHistoriesHandler {
    private final String host;
    private final String certAlias;
    private final Map<String, Object> requestProps;
    private StringWriter stringWriter;
    private JSONWriter jsonSerializer;
    private boolean hasData;
    private final BForgeHistoryChannelConfig config;
    private static final Logger log = Logger.getLogger("cloudLink.channel.history");

    public ForgeHttpGetHistoriesHandler(BChannelConfig channelConfig) {
        this.config = (BForgeHistoryChannelConfig)channelConfig;
        this.host = ((BFederatedIdentityAuthenticator)this.config.getAuthenticator(IGetHistoriesHandler.getOperationId())).getRegistrationHost();
        this.requestProps = this.config.getRequestProps(IGetHistoriesHandler.getOperationId());
        this.certAlias = (String)this.requestProps.remove("cert-alias");
        this.initializeMessage();
    }

    public int add(String historyId, BAbsTime start, BAbsTime end, boolean descending, int maxRecordCount, boolean requestPrevRecord, boolean requestNextRecord) {
        if (this.hasData) {
            return this.stringWriter.getBuffer().length() + 1;
        }
        this.jsonSerializer.key("cloudId").array().value((Object)historyId).endArray();
        this.jsonSerializer.key("startTime").value((Object)start.encodeToString());
        this.jsonSerializer.key("endTime").value((Object)end.encodeToString());
        this.jsonSerializer.key("sortAscending").value(!descending);
        this.jsonSerializer.key("recordLimit").value((long)maxRecordCount);
        this.jsonSerializer.key("includePreRecord").value(requestPrevRecord);
        this.jsonSerializer.key("includePostRecord").value(requestNextRecord);
        this.hasData = true;
        return this.stringWriter.getBuffer().length() + 1;
    }

    public CompletableFuture<IMessageResponse> getFuture(CompletableFuture<GetHistoriesResult> channelFuture, IMessage message) {
        CompletableFuture<IMessageResponse> reqFuture = new CompletableFuture<IMessageResponse>();
        reqFuture.whenComplete((resp, err) -> {
            if (err != null) {
                channelFuture.completeExceptionally((Throwable)err);
            } else {
                try (HttpResponseMessage response = (HttpResponseMessage)resp;){
                    ForgeHttpGetHistoriesResult getHistoriesResult = new ForgeHttpGetHistoriesResult(response.getBodyAsString(), this.config);
                    channelFuture.complete(getHistoriesResult);
                }
                catch (Exception ex) {
                    channelFuture.completeExceptionally(ex);
                }
            }
        });
        return reqFuture;
    }

    private void initializeMessage() {
        this.stringWriter = new StringWriter();
        this.jsonSerializer = QuickJSONWriter.make((Appendable)this.stringWriter);
        this.jsonSerializer.object();
        this.hasData = false;
    }

    public IMessage toMessage(boolean isFinal) {
        this.jsonSerializer.endObject();
        this.stringWriter.flush();
        URL url = null;
        try {
            url = new URL("https://" + this.host + "/api/v1/egress/stationTelemetry");
        }
        catch (MalformedURLException ex) {
            log.log(Level.INFO, "Unable to build URL for get history data request", log.isLoggable(Level.FINE) ? ex : null);
        }
        HttpRequestMessage msg = new HttpRequestMessage.HttpRequestMessageBuilder(HttpRequestMessage.HttpMethod.POST, url, this.requestProps).mimeType("application/json").body(this.stringWriter.getBuffer().toString()).certAlias(this.certAlias).build();
        if (!isFinal) {
            this.initializeMessage();
        }
        return msg;
    }
}

