/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.msg;

import com.tridium.cloudLink.channel.BAbstractClientChannel;
import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.file.FileUploadRequest;
import com.tridium.cloudLink.file.FileUploader;
import com.tridium.cloudLink.forge.channel.BForgeModelChannelConfig;
import com.tridium.cloudLink.forge.model.DefaultValueDocEncoder;
import com.tridium.cloudLink.forge.model.ModelEncoderPlugin;
import com.tridium.cloudLink.msg.ISendModelCloseHandler;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.cloudLink.transport.IMessageResponse;
import com.tridium.cloudLink.util.ProtectedFileUtil;
import com.tridium.cloudLink.util.TeeOutputStream;
import com.tridium.json.JSONWriter;
import com.tridium.json.quick.QuickJSONWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.TagDictionary;
import javax.baja.tagdictionary.BTagDictionaryService;

public class ForgeFileSendModelCloseHandler
implements ISendModelCloseHandler {
    protected static final Logger log = Logger.getLogger("cloudLink.channel.model");
    public static final String CSOM_FILE_NAME_TEMPLATE = "%s_%s_csom.json.gz";
    private static final String FILE_TYPE = "filetype";
    public static final String N4_CSOM = "n4csom";
    private static final String MIME_TYPE = "mimetype";
    private static final String VERSION = "version";
    private static final String VERSION_VALUE = "1";
    public static final String NAME = "n";
    public static final String META_DATA = "metadata";
    public static final String AD_HOC_TAG_DICTIONARY = "adHocTagDictionary";
    public static final String TAG_DICTIONARY = "tagDictionaries";
    protected final BForgeModelChannelConfig config;
    protected final Map<String, Object> properties = new HashMap<String, Object>();
    private final boolean uploadModelFiles;
    private final boolean writeModelFilesToDisk;
    protected Map<String, Map<String, String>> adHocTagInfo;
    protected Map<String, Set<String>> adHocRelInfo;
    private OutputStream fileStream;
    private GZIPOutputStream compressedStream;
    private OutputStreamWriter writer;
    private CompletableFuture<Void> uploadCompleted;

    public ForgeFileSendModelCloseHandler(BChannelConfig channelConfig) {
        this.config = (BForgeModelChannelConfig)channelConfig;
        this.uploadModelFiles = this.config.getUploadModelFiles();
        this.writeModelFilesToDisk = !this.config.getDeleteModelFiles();
    }

    public IMessage toMessage(boolean isFinal) {
        if (!this.uploadModelFiles && !this.writeModelFilesToDisk) {
            log.info("Model channel is configured to not upload model files and to not keep them on disk, so model upload will have no effect");
            return null;
        }
        try {
            String filename = String.format(CSOM_FILE_NAME_TEMPLATE, this.config.getSystemGuid(), this.config.getExportId());
            if (this.uploadModelFiles) {
                BAbstractClientChannel channel = (BAbstractClientChannel)this.config.getParent();
                Optional optUploader = channel.getConnectionService().flatMap(ccs -> ccs.getFileUploader(channel));
                if (!optUploader.isPresent()) {
                    String msg = "Cannot upload csom file as no file uploader is registered for the Model Channel";
                    log.warning(msg);
                    throw new RuntimeException(msg);
                }
                Consumer<OutputStream> fileData = out -> {
                    try {
                        if (this.writeModelFilesToDisk) {
                            log.info(String.format("Temporary csom file %s will not be deleted due to channel configuration settings, manual deletion is recommended", filename));
                            this.fileStream = ForgeFileSendModelCloseHandler.initializeFileStream(filename);
                            TeeOutputStream teeStream = new TeeOutputStream(out, this.fileStream);
                            this.compressedStream = new GZIPOutputStream((OutputStream)teeStream);
                            this.writer = new OutputStreamWriter((OutputStream)this.compressedStream, StandardCharsets.UTF_8);
                        } else {
                            GZIPOutputStream compressedStream = new GZIPOutputStream((OutputStream)out);
                            this.writer = new OutputStreamWriter((OutputStream)compressedStream, StandardCharsets.UTF_8);
                        }
                        JSONWriter jsonSerializer = QuickJSONWriter.make((Appendable)this.writer);
                        jsonSerializer.object();
                        jsonSerializer.key(META_DATA).value((Object)this.config.makeModelMetadata());
                        this.encodeAdHocInfo(jsonSerializer);
                        ForgeFileSendModelCloseHandler.encodeTagDictionaries(jsonSerializer);
                        jsonSerializer.endObject();
                        this.close();
                    }
                    catch (IOException ex) {
                        throw new RuntimeException("Unable to create csom upload file.", ex);
                    }
                };
                HashMap<String, String> metadata = new HashMap<String, String>();
                metadata.put(FILE_TYPE, N4_CSOM);
                metadata.put(MIME_TYPE, "application/json+gzip");
                metadata.put(VERSION, VERSION_VALUE);
                log.finer("Uploading the csom file to Niagara Cloud.");
                FileUploader uploader = (FileUploader)optUploader.get();
                FileUploadRequest request = new FileUploadRequest(filename, fileData, metadata);
                this.uploadCompleted = uploader.upload(request);
            } else {
                log.info(String.format("Temporary csom file %s will not be deleted due to channel configuration settings, manual deletion is recommended", filename));
                OutputStream fileStream = ForgeFileSendModelCloseHandler.initializeFileStream(filename);
                GZIPOutputStream compressedStream = new GZIPOutputStream(fileStream);
                this.writer = new OutputStreamWriter((OutputStream)compressedStream, StandardCharsets.UTF_8);
                JSONWriter jsonSerializer = QuickJSONWriter.make((Appendable)this.writer);
                jsonSerializer.object();
                jsonSerializer.key(META_DATA).value((Object)this.config.makeModelMetadata());
                this.encodeAdHocInfo(jsonSerializer);
                ForgeFileSendModelCloseHandler.encodeTagDictionaries(jsonSerializer);
                jsonSerializer.endObject();
                this.close();
            }
        }
        catch (Exception ex) {
            String msg = "Unable to complete the model csom file processing.";
            log.log(Level.WARNING, msg, log.isLoggable(Level.FINE) ? ex : null);
            try {
                this.close();
            }
            catch (IOException ioex) {
                log.log(Level.WARNING, "Error while closing model upload csom file handler " + ioex, log.isLoggable(Level.FINE) ? ex : null);
            }
            throw ex instanceof RuntimeException ? (RuntimeException)ex : new RuntimeException(msg, ex);
        }
        return null;
    }

    private static void encodeTagDictionaries(JSONWriter jsonSerializer) throws IOException {
        try (DefaultValueDocEncoder encoder = new DefaultValueDocEncoder(new ModelEncoderPlugin(jsonSerializer));){
            encoder.setEncodeTransients(false);
            jsonSerializer.key(TAG_DICTIONARY).object();
            BTagDictionaryService tagDictionaryService = (BTagDictionaryService)Sys.getService((Type)BTagDictionaryService.TYPE);
            for (TagDictionary tagDictionary : tagDictionaryService.getTagDictionaries()) {
                String displayName = tagDictionary.getDisplayName(null);
                jsonSerializer.key(displayName);
                encoder.encode(displayName, (BValue)tagDictionary, Integer.MAX_VALUE);
            }
            jsonSerializer.endObject();
        }
    }

    public void close() throws IOException {
        try (OutputStreamWriter closingWriter = this.writer;){
            this.writer = null;
            if (closingWriter != null) {
                closingWriter.flush();
            }
        }
        ForgeFileSendModelCloseHandler.closeStream(this.fileStream);
        this.fileStream = null;
        ForgeFileSendModelCloseHandler.closeStream(this.compressedStream);
        this.compressedStream = null;
    }

    private static OutputStream initializeFileStream(String filename) {
        try {
            return AccessController.doPrivileged(() -> {
                ProtectedFileUtil.getOrCreateProtectedFolder((String)"cloudLinkModel");
                File file = ProtectedFileUtil.makeProtectedFile((String)("cloudLinkModel" + File.separator + filename));
                return Files.newOutputStream(file.toPath(), new OpenOption[0]);
            });
        }
        catch (PrivilegedActionException ex) {
            throw new RuntimeException("Unable to create csom upload file.", ex.getCause());
        }
    }

    private void encodeAdHocInfo(JSONWriter jsonSerializer) {
        jsonSerializer.key(AD_HOC_TAG_DICTIONARY).object();
        try {
            this.encodeAdHocTags(jsonSerializer);
            this.encodeAdHocRelations(jsonSerializer);
        }
        finally {
            jsonSerializer.endObject();
        }
    }

    private void encodeAdHocTags(JSONWriter jsonSerializer) {
        jsonSerializer.key("tags").array();
        try {
            Optional.ofNullable(this.adHocTagInfo).ifPresent(adHocTagInfo -> adHocTagInfo.values().stream().map(Map::entrySet).flatMap(Collection::stream).forEach(e -> {
                jsonSerializer.object();
                jsonSerializer.key(NAME).value(e.getKey());
                jsonSerializer.key("t").value(e.getValue());
                jsonSerializer.endObject();
            }));
        }
        finally {
            jsonSerializer.endArray();
        }
    }

    private void encodeAdHocRelations(JSONWriter jsonSerializer) {
        jsonSerializer.key("relations").array();
        try {
            Optional.ofNullable(this.adHocRelInfo).ifPresent(adHocRelInfo -> adHocRelInfo.values().stream().flatMap(Collection::stream).forEach(qName -> jsonSerializer.value(qName)));
        }
        finally {
            jsonSerializer.endArray();
        }
    }

    public CompletableFuture<IMessageResponse> getFuture(CompletableFuture<Map<String, Object>> channelFuture, IMessage message) {
        CompletableFuture<IMessageResponse> future = new CompletableFuture<IMessageResponse>();
        if (this.uploadModelFiles) {
            if (this.uploadCompleted == null) {
                String msg = "Cannot get future for csom file";
                log.warning(msg);
                future.completeExceptionally(new RuntimeException(msg));
                channelFuture.completeExceptionally(new RuntimeException(msg));
                return future;
            }
            String filename = String.format(CSOM_FILE_NAME_TEMPLATE, this.config.getSystemGuid(), this.config.getExportId());
            this.uploadCompleted.whenComplete((resp, err) -> {
                if (err != null) {
                    log.log(Level.WARNING, String.format("Model file uploaded failed %s", filename), log.isLoggable(Level.FINE) ? err : null);
                    future.completeExceptionally((Throwable)err);
                    channelFuture.completeExceptionally((Throwable)err);
                } else {
                    log.finer(String.format("Model file uploaded successfully %s", filename));
                    future.complete(null);
                    channelFuture.complete(Collections.singletonMap("uploadModelFile", true));
                }
            });
        } else {
            future.complete(null);
            channelFuture.complete(Collections.singletonMap("uploadModelFile", false));
        }
        return future;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties.putAll(properties);
        this.adHocRelInfo = (Map)properties.get("adHocRelation");
        if (this.adHocRelInfo == null) {
            log.warning("The ad hoc relation map is not available in properties");
        }
        this.adHocTagInfo = (Map)properties.get("adHocTag");
        if (this.adHocTagInfo == null) {
            log.warning("The ad hoc tag map is not available in properties");
        }
    }

    private static void closeStream(OutputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

