/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.msg;

import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.forge.channel.BForgeAmqpCommandChannelConfig;
import com.tridium.cloudLink.forge.msg.ForgeAmqpHandler;
import com.tridium.cloudLink.forge.msg.IForgeAckAlarmCommandHandler;
import com.tridium.cloudLink.msg.AckAlarmResult;
import com.tridium.cloudLink.msg.IAckAlarmCommandHandler;
import com.tridium.cloudLink.transport.AmqpMessage;
import com.tridium.cloudLink.transport.BAbstractTransport;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.cloudLink.transport.IMessageResponse;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ForgeAmqpAckAlarmCommandHandler
extends ForgeAmqpHandler
implements IForgeAckAlarmCommandHandler {
    private final BForgeAmqpCommandChannelConfig config;
    private String correlationId;
    public static final String COMMAND = "AlarmAckResponse";
    public static final String VERSION = "2";
    private static final int MSG_END_SIZE = 1;
    private static final Logger log = Logger.getLogger("cloudLink.channel.alarm");

    public ForgeAmqpAckAlarmCommandHandler(BChannelConfig channelConfig) {
        this.config = (BForgeAmqpCommandChannelConfig)channelConfig;
        this.makeMessageHeaders(COMMAND, VERSION, this.config);
        this.initializeMessage();
    }

    @Override
    public void addError(int code, String message) {
        this.jsonSerializer.key("IsSuccessful").value(false);
        this.jsonSerializer.key("Message").value((Object)message);
    }

    @Override
    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public int add(AckAlarmResult value) {
        this.jsonSerializer.key("IsSuccessful").value((Object)value.getStatus());
        this.jsonSerializer.key("Message").value((Object)value.getMessage());
        return this.stringWriter.getBuffer().length() + 1;
    }

    @Override
    public IMessage toMessage(boolean isFinal) {
        this.jsonSerializer.endObject();
        AmqpMessage msg = (AmqpMessage)super.toMessage(isFinal);
        if (this.correlationId != null) {
            msg.getMessage().setCorrelationId((Object)this.correlationId);
            this.correlationId = null;
        }
        return msg;
    }

    public CompletableFuture<IMessageResponse> getFuture(CompletableFuture<Boolean> channelFuture, IMessage message) {
        CompletableFuture<IMessageResponse> future = new CompletableFuture<IMessageResponse>();
        future.whenComplete((resp, err) -> {
            if (err != null) {
                log.log(Level.WARNING, "Alarm ack command response got error", log.isLoggable(Level.FINE) ? err : null);
                channelFuture.complete(false);
            } else {
                log.finer("Alarm ack command response message sent successfully");
                channelFuture.complete(true);
            }
        });
        return future;
    }

    @Override
    protected void initializeMessage() {
        super.initializeMessage();
        this.jsonSerializer.object();
    }

    @Override
    protected BAbstractTransport getTransport() {
        return this.config.getTransport(IAckAlarmCommandHandler.getOperationId());
    }
}

