/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.command;

import com.tridium.authn.BAuthenticationService;
import com.tridium.cloudLink.BAbstractCloudLinkHandlerFactory;
import com.tridium.cloudLink.BCloudConnectionService;
import com.tridium.cloudLink.ICloudLinkMessageHandler;
import com.tridium.cloudLink.auth.BFederatedIdentityAuthenticator;
import com.tridium.cloudLink.channel.BCommandsChannel;
import com.tridium.cloudLink.command.BCommand;
import com.tridium.cloudLink.command.BCommandContainer;
import com.tridium.cloudLink.command.CommandEvent;
import com.tridium.cloudLink.command.CommandRequest;
import com.tridium.cloudLink.forge.channel.IForgeChannelConfig;
import com.tridium.cloudLink.forge.command.BIForgeCommand;
import com.tridium.cloudLink.forge.command.ForgeAmqpCommandRequest;
import com.tridium.cloudLink.msg.IRegisterCommandsHandler;
import com.tridium.cloudLink.msg.ISendEventHandler;
import com.tridium.cloudLink.queue.BInMemoryCommandQueue;
import com.tridium.cloudLink.security.BCloudAuthenticationScheme;
import com.tridium.cloudLink.security.BCloudCallbackHandler;
import com.tridium.cloudLink.security.BCloudRoleMappings;
import com.tridium.cloudLink.security.BCloudTrustManager;
import com.tridium.cloudLink.security.BJwksTrustMapping;
import com.tridium.cloudLink.security.BRoleMapping;
import com.tridium.cloudLink.security.BUserMapping;
import com.tridium.cloudLink.security.CloudSession;
import com.tridium.cloudLink.transport.AmqpMessage;
import com.tridium.cloudLink.transport.BAbstractConnectedTransport;
import com.tridium.cloudLink.transport.BAbstractTransport;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.cloudLink.transport.IMessageCallback;
import com.tridium.cloudLink.transport.MessageWrapper;
import com.tridium.session.NiagaraSession;
import com.tridium.session.SessionManager;
import java.io.IOException;
import java.security.AccessController;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.baja.authn.BAuthenticationScheme;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.AuthenticationException;
import javax.baja.security.BAbstractAuthenticator;
import javax.baja.security.BPassword;
import javax.baja.security.BPasswordAuthenticator;
import javax.baja.security.PermissionException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.security.auth.callback.CallbackHandler;

@NiagaraType
public final class BForgeCommandContainer
extends BCommandContainer
implements IMessageCallback {
    public static final Type TYPE = Sys.loadType(BForgeCommandContainer.class);
    private Map<String, Map<String, BIForgeCommand>> commandMap;
    private static final Map<Integer, Integer> codeMap = new HashMap<Integer, Integer>();
    private static final Map<Integer, String> messageMap = new HashMap<Integer, String>();
    private static final String CLOUD_USERNAME = "cloudUser";
    private static final String FORGE_COMMAND_QUEUE = "forgeCommandQueue";
    private static final String PARTNER_ADMIN = "partner_admin";
    private static final String PARTNER_ADMIN_MAPPING = "PartnerAdminMapping";
    private static final String PARTNER_USER = "partner_user";
    private static final String PARTNER_USER_MAPPING = "PartnerUserMapping";
    private static final String CUSTOMER_ADMIN = "customer_admin";
    private static final String CUSTOMER_ADMIN_MAPPING = "CustomerAdminMapping";
    private static final String CUSTOMER_USER = "customer_user";
    private static final String CUSTOMER_USER_MAPPING = "CustomerUserMapping";
    private static final String NDS_OPERATOR = "nds_operator";
    private static final String NDS_OPERATOR_MAPPING = "NdsOperatorMapping";
    private static final String JWKS_ROUTE = "/api/v1/accesstoken";
    private static final String JWKS_KEY = "/publicKey";
    public static final String APPID_PREFIX = "appid_";
    public static final String ROLE_PREFIX = "role_";

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.ensureForgeAuthentication();
    }

    public void added(Property property, Context context) {
        super.added(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.getType().is(BIForgeCommand.TYPE)) {
            BIForgeCommand newCommand = (BIForgeCommand)this.get(property).as(BIForgeCommand.class);
            String route = newCommand.getRoute();
            if (!this.commandMap.containsKey(route)) {
                BCommandsChannel commandChannel = this.getChannel();
                BAbstractConnectedTransport transport = (BAbstractConnectedTransport)commandChannel.getChannelConfig().getTransport(IRegisterCommandsHandler.getOperationId()).as(BAbstractConnectedTransport.class);
                transport.addMessageCallback(route, (IMessageCallback)this);
                this.commandMap.put(route, new HashMap());
                commandChannel.registerCommands();
            }
            this.commandMap.get(route).put(newCommand.getCommandName(), newCommand);
        }
    }

    public void setupRoutes() {
        BCommandsChannel commandChannel = this.getChannel();
        BAbstractConnectedTransport transport = (BAbstractConnectedTransport)commandChannel.getChannelConfig().getTransport(IRegisterCommandsHandler.getOperationId()).as(BAbstractConnectedTransport.class);
        this.populateCommandMap();
        for (Map.Entry<String, Map<String, BIForgeCommand>> entry : this.commandMap.entrySet()) {
            transport.addMessageCallback(entry.getKey(), (IMessageCallback)this);
        }
    }

    public Set<String> getCommandIds() {
        this.populateCommandMap();
        return this.commandMap.keySet();
    }

    private void populateCommandMap() {
        if (this.commandMap != null) {
            return;
        }
        this.commandMap = new HashMap<String, Map<String, BIForgeCommand>>();
        for (BIForgeCommand command : (BIForgeCommand[])this.getChildren(BIForgeCommand.class)) {
            Map<String, BIForgeCommand> subMap;
            if (!this.commandMap.containsKey(command.getRoute())) {
                this.commandMap.put(command.getRoute(), new HashMap());
            }
            if ((subMap = this.commandMap.get(command.getRoute())).containsKey(command.getCommandName())) {
                log.warning(() -> String.format("Command route collision for %s %s, for %s and %s, skipping", command.getRoute(), command.getCommandName(), ((BComponent)command).getSlotPath(), ((BComponent)subMap.get(command.getCommandName())).getSlotPath()));
                continue;
            }
            this.commandMap.get(command.getRoute()).put(command.getCommandName(), command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(IMessage message) {
        if (!(message instanceof AmqpMessage)) {
            log.warning(() -> "Received message of unknown type " + message.getClass().getName());
            return;
        }
        ForgeAmqpCommandRequest request = new ForgeAmqpCommandRequest((AmqpMessage)message);
        log.fine(() -> String.format("Command received: applicationId=[%s] messageId=[%s] commandId=[%s] commandType=[%s]", request.getCaller(), request.getMessageId(), request.getCommandId(), request.getCommandName()));
        String route = (String)request.getMetadata().get("ObjectType") + '.' + request.getMetadata().get("ObjectVersion");
        Map<String, BIForgeCommand> commands = this.commandMap.get(route);
        BIForgeCommand command = commands.size() == 1 ? commands.values().iterator().next() : commands.get(request.getCommandName());
        if (command == null) {
            log.warning(() -> String.format("Error command not found: route=[%s], name=[%s], commandId=[%s]", route, request.getCommandName(), request.getCommandId()));
            return;
        }
        request.setCommand((BCommand)command.as(BCommand.class));
        CloudSession session = new CloudSession();
        try {
            BAuthenticationScheme scheme;
            BAuthenticationService service = (BAuthenticationService)Sys.getService((Type)BAuthenticationService.TYPE);
            BAuthenticationScheme[] schemes = (BAuthenticationScheme[])service.getAuthenticationSchemes().getChildren(BCloudAuthenticationScheme.class);
            BAuthenticationScheme bAuthenticationScheme = scheme = schemes.length > 0 ? schemes[0] : null;
            if (scheme == null) {
                throw new AuthenticationException("Missing cloud authentication scheme");
            }
            BCloudCallbackHandler callbackHandler = (BCloudCallbackHandler)scheme.getAgentOn(BCloudCallbackHandler.class);
            if (callbackHandler == null) {
                throw new AuthenticationException("Missing authentication handler");
            }
            BCommandsChannel channel = this.getChannel();
            if (channel == null) {
                log.warning("parent channel not found.");
                this.sendEnqueueResponse(request, 503, "Error: Service Unavailable");
                return;
            }
            callbackHandler.init((CommandRequest)request, ((IForgeChannelConfig)channel.getChannelConfig()).getSystemGuid());
            SessionManager.addSession((NiagaraSession)session);
            BUser user = service.authenticate((NiagaraSession)session, null, (CallbackHandler)callbackHandler, scheme);
            if (channel.isDisabled()) {
                throw new PermissionException("Command channel is disabled.");
            }
            if (!command.getEnabled()) {
                throw new PermissionException("Command is disabled.");
            }
            request.setUser(user);
            channel.enqueue((CommandRequest)request);
        }
        catch (PermissionException ex) {
            log.warning(() -> String.format("Error executing command: commandId=[%s] %s", request.getCommandId(), ex.getMessage()));
            this.sendEnqueueResponse(request, 503, "Error: Service Unavailable");
        }
        catch (AuthenticationException ex) {
            log.warning(() -> String.format("Error attempting to authenticating cloud user: commandId=[%s], callingIdentity=[%s] %s", request.getCommandId(), request.getCaller(), ex.getMessage()));
            this.sendEnqueueResponse(request, 401, "Error: Unauthorized");
        }
        finally {
            session.invalidate();
        }
    }

    public CompletableFuture<Boolean> sendEnqueueResponse(CommandRequest request, int errCode) {
        return this.sendEnqueueResponse(request, codeMap.get(errCode), messageMap.get(errCode));
    }

    private CompletableFuture<Boolean> sendEnqueueResponse(CommandRequest request, int errCode, String errMsg) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        BAbstractTransport transport = this.getChannel().getChannelConfig().getTransport("commandResponse");
        if (!transport.canSend()) {
            log.warning(String.format("Unable to send command response transport down: commandId=[%s], transportType=[%s]", request.getCommandId(), transport.getTransportType()));
            future.completeExceptionally(new IOException("transport down"));
            return future;
        }
        BAbstractCloudLinkHandlerFactory msgFactory = (BAbstractCloudLinkHandlerFactory)((BCloudConnectionService)this.getChannel().getConnectionService().orElseThrow(() -> new IllegalStateException("Unable to locate Cloud Connection Service."))).getMessageHandlerFactory(this.getChannel().getPlatformType(), transport.getTransportType()).orElseThrow(() -> new IllegalStateException("Unable to locate message handler factory."));
        ICloudLinkMessageHandler<Boolean> responseHandler = ((BIForgeCommand)request.getCommand().as(BIForgeCommand.class)).getErrorResponse(msgFactory, this.getChannel().getChannelConfig(), request.getMessageId(), errCode, errMsg);
        MessageWrapper wrapper = new MessageWrapper(responseHandler.toMessage(), responseHandler.getFuture(future), transport.getMessageRetries());
        AccessController.doPrivileged(() -> {
            this.getChannel().getChannelConfig().enqueueMessage("commandResponse", wrapper);
            return null;
        });
        future.whenComplete((resp, err) -> {
            if (err != null) {
                log.warning(String.format("Failed to send cloud command enqueue response message: commandId=[%s]", request.getCommandId()));
            } else {
                log.fine(() -> String.format("Cloud command enqueue response message sent successfully: commandId=[%s] ", request.getCommandId()));
            }
        });
        transport.notifyPending();
        return future;
    }

    public CompletableFuture<Boolean> sendStatusEvent(CommandRequest request, int statusCode) {
        ICloudLinkMessageHandler<Boolean> responseHandler;
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        BAbstractTransport transport = this.getChannel().getChannelConfig().getTransport(ISendEventHandler.getOperationId());
        if (!transport.canSend()) {
            log.warning(String.format("Unable to send command response transport down: commandId=[%s], transportType=[%s]", request.getCommandId(), transport.getTransportType()));
            future.completeExceptionally(new IOException("unable to send command response transport down"));
            return future;
        }
        BAbstractCloudLinkHandlerFactory msgFactory = (BAbstractCloudLinkHandlerFactory)((BCloudConnectionService)this.getChannel().getConnectionService().orElseThrow(() -> new IllegalStateException("Unable to locate Cloud Connection Service."))).getMessageHandlerFactory(this.getChannel().getPlatformType(), transport.getTransportType()).orElseThrow(() -> new IllegalStateException("Unable to locate message handler factory."));
        if (request.getSuppressStatusResponse()) {
            responseHandler = ((BIForgeCommand)request.getCommand().as(BIForgeCommand.class)).getErrorResponse(msgFactory, this.getChannel().getChannelConfig(), request.getMessageId(), codeMap.get(statusCode), messageMap.get(statusCode));
        } else {
            ICloudLinkMessageHandler<Boolean> commandHandler = (ICloudLinkMessageHandler<Boolean>)msgFactory.getMessageHandler(ISendEventHandler.class, this.getChannel().getChannelConfig());
            commandHandler.add(new CommandEvent(request.getCommandId(), statusCode));
            responseHandler = commandHandler;
        }
        MessageWrapper wrapper = new MessageWrapper(responseHandler.toMessage(), responseHandler.getFuture(future), transport.getMessageRetries());
        AccessController.doPrivileged(() -> {
            this.getChannel().getChannelConfig().enqueueMessage(ISendEventHandler.getOperationId(), wrapper);
            return null;
        });
        transport.notifyPending();
        return future;
    }

    public CompletableFuture<Boolean> sendDataEvent(CommandEvent event) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        BAbstractTransport transport = this.getChannel().getChannelConfig().getTransport(ISendEventHandler.getOperationId());
        if (!transport.canSend()) {
            future.completeExceptionally(new IOException("unable to send command event transport down"));
            return future;
        }
        BAbstractCloudLinkHandlerFactory msgFactory = (BAbstractCloudLinkHandlerFactory)((BCloudConnectionService)this.getChannel().getConnectionService().orElseThrow(() -> new IllegalStateException("Unable to locate Cloud Connection Service."))).getMessageHandlerFactory(this.getChannel().getPlatformType(), transport.getTransportType()).orElseThrow(() -> new IllegalStateException("Unable to locate message handler factory."));
        ISendEventHandler responseHandler = (ISendEventHandler)msgFactory.getMessageHandler(ISendEventHandler.class, this.getChannel().getChannelConfig());
        responseHandler.add(event);
        MessageWrapper wrapper = new MessageWrapper(responseHandler.toMessage(), responseHandler.getFuture(future), transport.getMessageRetries());
        AccessController.doPrivileged(() -> {
            this.getChannel().getChannelConfig().enqueueMessage(ISendEventHandler.getOperationId(), wrapper);
            return null;
        });
        transport.notifyPending();
        return future;
    }

    public static int getCode(int code) {
        return codeMap.get(code);
    }

    public static String getMessage(int code) {
        return messageMap.get(code);
    }

    private void ensureForgeAuthentication() {
        Map<String, String> rollMap;
        BAuthenticationService authenticationService = (BAuthenticationService)Sys.getService((Type)BAuthenticationService.TYPE);
        BCloudAuthenticationScheme[] cloudSchemes = (BCloudAuthenticationScheme[])authenticationService.getAuthenticationSchemes().getChildren(BCloudAuthenticationScheme.class);
        BCloudAuthenticationScheme cloudAuthenticationScheme = cloudSchemes[0];
        Map<String, String> appIdMap = Arrays.stream(this.getDynamicPropertiesArray()).filter(p -> p.getName().startsWith(APPID_PREFIX)).collect(Collectors.toMap(Slot::getName, p -> this.getString((Property)p)));
        if (!appIdMap.isEmpty()) {
            Object user;
            BUserService userService;
            BUser[] users;
            List cloudUsers;
            if (cloudAuthenticationScheme.getUserMappings().getEnabled()) {
                return;
            }
            cloudAuthenticationScheme.getUserMappings().setEnabled(true);
            BCommandsChannel channel = this.getChannel();
            if (channel != null && channel.getProperty(FORGE_COMMAND_QUEUE) == null) {
                BInMemoryCommandQueue queue = new BInMemoryCommandQueue();
                queue.setPriority(0);
                channel.add(FORGE_COMMAND_QUEUE, (BValue)queue, 5);
                channel.updatePriorityQueues();
            }
            if ((cloudUsers = Arrays.stream(users = (BUser[])(userService = BUserService.getService()).getChildren(BUser.class)).filter(BForgeCommandContainer::isCloudAuthenticationSchemeAssigned).collect(Collectors.toList())).isEmpty()) {
                log.config("ensureForgeAuthentication: adding cloud user.");
                user = new BUser();
                user.setAuthenticationSchemeName("cloudAuthenticationScheme");
                user.addRole("CloudUser", null);
                user.addRole("CloudAdmin", null);
                BPasswordAuthenticator bPasswordAuthenticator = new BPasswordAuthenticator();
                bPasswordAuthenticator.setPassword(BPassword.make((String)"Hon@123$1"));
                user.setAuthenticator((BAbstractAuthenticator)bPasswordAuthenticator);
                user.setFullName(CLOUD_USERNAME);
                userService.add("cloudUser?", (BValue)user);
            } else {
                user = (BUser)cloudUsers.get(0);
            }
            for (Map.Entry<String, String> appId : appIdMap.entrySet()) {
                if (cloudAuthenticationScheme.getUserMappings().getUser(appId.getValue()) != null) {
                    log.config(() -> "ensureForgeAuthentication: mapping already exists for app: " + (String)appId.getKey());
                    continue;
                }
                BUserMapping userMapping = new BUserMapping();
                userMapping.setAppId(appId.getValue());
                userMapping.setUserName(user.getName());
                cloudAuthenticationScheme.getUserMappings().add(appId.getKey(), (BValue)userMapping);
                log.config(() -> "ensureForgeAuthentication: adding user mapping for app: " + (String)appId.getKey());
            }
        }
        if (!(rollMap = Arrays.stream(this.getDynamicPropertiesArray()).filter(p -> p.getName().startsWith(ROLE_PREFIX)).collect(Collectors.toMap(Slot::getName, p -> this.getString((Property)p)))).isEmpty()) {
            BCloudTrustManager manager = cloudAuthenticationScheme.getTrustManager();
            if (((BJwksTrustMapping[])manager.getChildren(BJwksTrustMapping.class)).length > 0) {
                return;
            }
            BCommandsChannel channel = this.getChannel();
            if (channel == null) {
                return;
            }
            BFederatedIdentityAuthenticator authenticator = channel.getConnectionService().map(ccs -> ccs.getAuthenticator("FederatedIdentity")).orElse(null);
            if (authenticator == null) {
                return;
            }
            for (Map.Entry entry : rollMap.entrySet()) {
                if (manager.getKeyResolver((String)entry.getValue()) != null) {
                    log.config(() -> "ensureForgeAuthentication: trust mapping already exists for app: " + (String)appId.getKey());
                    continue;
                }
                BJwksTrustMapping jwksTrustMapping = new BJwksTrustMapping();
                String issuer = "https://" + authenticator.getRegistrationHost() + JWKS_ROUTE;
                jwksTrustMapping.setExpectedJwtIssuer(issuer);
                jwksTrustMapping.setJwksEndpoint(issuer + JWKS_KEY);
                jwksTrustMapping.setExpectedJwtAudience(authenticator.getSystemId());
                jwksTrustMapping.setAppId((String)entry.getValue());
                manager.add(SlotPath.escape((String)((String)entry.getValue())), (BValue)jwksTrustMapping);
            }
            BCloudRoleMappings roles = cloudAuthenticationScheme.getRoleMappings();
            BRoleMapping bRoleMapping = new BRoleMapping();
            bRoleMapping.setCloudRole(CUSTOMER_ADMIN);
            bRoleMapping.setStationRole("CloudAdmin");
            roles.add(CUSTOMER_ADMIN_MAPPING, (BValue)bRoleMapping);
            BRoleMapping bRoleMapping2 = new BRoleMapping();
            bRoleMapping2.setCloudRole(CUSTOMER_USER);
            bRoleMapping2.setStationRole("CloudUser");
            roles.add(CUSTOMER_USER_MAPPING, (BValue)bRoleMapping2);
            BRoleMapping bRoleMapping3 = new BRoleMapping();
            bRoleMapping3.setCloudRole(NDS_OPERATOR);
            bRoleMapping3.setStationRole("CloudOperator");
            roles.add(NDS_OPERATOR_MAPPING, (BValue)bRoleMapping3);
            BRoleMapping bRoleMapping4 = new BRoleMapping();
            bRoleMapping4.setCloudRole(PARTNER_ADMIN);
            bRoleMapping4.setStationRole("CloudAdmin");
            roles.add(PARTNER_ADMIN_MAPPING, (BValue)bRoleMapping4);
            BRoleMapping bRoleMapping5 = new BRoleMapping();
            bRoleMapping5.setCloudRole(PARTNER_USER);
            bRoleMapping5.setStationRole("CloudUser");
            roles.add(PARTNER_USER_MAPPING, (BValue)bRoleMapping5);
        }
    }

    public static boolean isCloudAuthenticationSchemeAssigned(BUser user) {
        boolean isCloudAuthenticationScheme = false;
        try {
            isCloudAuthenticationScheme = user.getAuthenticationScheme() instanceof BCloudAuthenticationScheme;
        }
        catch (Exception ex) {
            log.log(Level.INFO, "Unable check user authentication scheme", log.isLoggable(Level.FINE) ? ex : null);
        }
        return isCloudAuthenticationScheme;
    }

    static {
        codeMap.put(110, 204);
        codeMap.put(120, 500);
        codeMap.put(100, 0);
        codeMap.put(130, 504);
        codeMap.put(140, 503);
        messageMap.put(110, "Status: Done");
        messageMap.put(120, "Error: Bad Request");
        messageMap.put(100, "");
        messageMap.put(130, "Error: Command Timeout");
        messageMap.put(140, "Error: Service Unavailable");
    }
}

