/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.channel;

import com.tridium.cloudLink.channel.BMonoTransportChannelConfig;
import com.tridium.cloudLink.channel.BTransportConfig;
import com.tridium.cloudLink.forge.auth.BAbstractForgeAuthenticator;
import com.tridium.cloudLink.forge.channel.IForgeChannelConfig;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public abstract class BForgeMonoTransportChannelConfig
extends BMonoTransportChannelConfig
implements IForgeChannelConfig {
    public static final Type TYPE = Sys.loadType(BForgeMonoTransportChannelConfig.class);

    public Type getType() {
        return TYPE;
    }

    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        BTransportConfig transportConfig = this.getTransportInformation();
        if (transportConfig.getTransportType().equals("AMQP")) {
            BFacets maxMsgSizeFacets = transportConfig.getSlotFacets((Slot)BTransportConfig.maxMessageSize);
            transportConfig.setFacets((Slot)BTransportConfig.maxMessageSize, BFacets.make((BFacets)maxMsgSizeFacets, (BFacets)BFacets.make((String)"max", (BIDataValue)BInteger.make((int)2000000))));
        }
    }

    public String getPlatformType() {
        return "Forge";
    }

    public void validateConfiguration(String prefix, String channel, StringBuilder err, Logger log) {
        super.validateConfiguration(prefix, err);
        if (!(this.getAuthenticator(null) instanceof BAbstractForgeAuthenticator)) {
            log.info(() -> String.format("%s: %s %s", prefix, channel, "Invalid authenticator configured"));
            err.append("Invalid authenticator configured").append(';');
        }
    }

    @Override
    public String getSystemGuid() {
        BAbstractForgeAuthenticator auth = (BAbstractForgeAuthenticator)this.getAuthenticator(null).as(BAbstractForgeAuthenticator.class);
        return auth.getSystemGuid();
    }

    public String getSystemType() {
        BAbstractForgeAuthenticator auth = (BAbstractForgeAuthenticator)this.getAuthenticator(null).as(BAbstractForgeAuthenticator.class);
        return auth.getSystemType();
    }
}

