/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.auth;

import com.tridium.cloudLink.msg.IMessageBuilder;
import com.tridium.cloudLink.transport.HttpRequestMessage;
import com.tridium.cloudLink.transport.IMessage;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ForgeRegistrationStatusRequest
implements IMessageBuilder {
    private final String systemId;
    private final String certAlias;
    private final String registrationHost;
    private static final Logger log = Logger.getLogger("cloudLink.auth.federated");
    private static final String API_PATH = "/api/v1/forge-adapter/device/status/";

    public ForgeRegistrationStatusRequest(String server, String systemId, String certAlias) {
        this.registrationHost = server;
        this.systemId = systemId;
        this.certAlias = certAlias;
    }

    public IMessage toMessage(boolean isFinal) {
        URL url = null;
        try {
            url = new URL("https://" + this.registrationHost + API_PATH + this.systemId);
        }
        catch (MalformedURLException ex) {
            log.log(Level.INFO, "Unable to build URL for IoTHub registration status request", log.isLoggable(Level.FINE) ? ex : null);
        }
        String correlationId = UUID.randomUUID().toString();
        log.config(() -> "Sending IoTHub registration status request with correlation " + correlationId);
        return new HttpRequestMessage.HttpRequestMessageBuilder(HttpRequestMessage.HttpMethod.GET, url, Collections.singletonMap("x-activity-id", correlationId)).certAlias(this.certAlias).build();
    }
}

