/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Ashutosh Chaturvedi
 */

/**
 * API Status: **Private**
 * @module nmodule/cloudLink/rc/history/util/CloudHistoryExportExecuteCommand
 */
define(['baja!', 'lex!cloudLink', 'Promise', 'underscore', 'bajaux/commands/Command', 'nmodule/webEditors/rc/wb/mgr/mgrUtils'], function (baja, lexs, Promise, _, Command, mgrUtils) {
  'use strict';

  var cloudLinkLex = lexs[0],
      getMainTableSelectedSubjects = mgrUtils.getMainTableSelectedSubjects;
  /**
   * Execute the selected cloud history export config(s) if they are enabled.
   * @param {baja.Component} exportConfigSelectionSubjects - the existing database component
   * @returns {Promise}
   */

  function executeSelectedConfigs(exportConfigSelectionSubjects) {
    var promises = [];

    for (var i = 0; i < exportConfigSelectionSubjects.length; i++) {
      if (exportConfigSelectionSubjects[i].getEnabled()) {
        promises.push(exportConfigSelectionSubjects[i].execute());
      }
    }

    return Promise.all(promises);
  }
  /**
   * Command to execute the selected cloud history cloud export config(s).
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/cloudLink/rc/history/util/CloudHistoryExportExecuteCommand
   * @param {module:nmodule/cloudLink/rc/history/mgr/CloudHistoryExportUxManager} mgr
   */


  var CloudHistoryExportExecuteCommand = function CloudHistoryExportExecuteCommand(mgr) {
    Command.call(this, {
      module: 'cloudLink',
      lex: 'cloudHistoryExportConfig.execute',
      enabled: false,

      /**
       * Execute the export config selected in the cloud history export database table.
       * Reject if nothing is selected in the cloud history export database table.
       *
       * @alias module:nmodule/cloudLink/rc/history/util/CloudHistoryExportExecuteCommand#invoke
       * @returns {Promise}
       */
      func: function func() {
        var exportConfigSelectionSubjects = getMainTableSelectedSubjects(mgr);

        if (exportConfigSelectionSubjects.length >= 1) {
          return executeSelectedConfigs(exportConfigSelectionSubjects);
        } else {
          return Promise.reject(new Error(cloudLinkLex.get("cloudHistoryExportConfig.executeError")));
        }
      }
    });
    this.$mgr = mgr;
  };

  CloudHistoryExportExecuteCommand.prototype = Object.create(Command.prototype);
  CloudHistoryExportExecuteCommand.prototype.constructor = CloudHistoryExportExecuteCommand;
  /**
   * Function called when the selection in the main table changes.
   * The execute command should only be enabled when one or more enabled cloud history
   * export item is selected in the database table.
   *
   * @private
   */

  CloudHistoryExportExecuteCommand.prototype.tableSelectionChanged = function () {
    var exportConfigSelectionSubjects = getMainTableSelectedSubjects(this.$mgr);

    for (var i = 0; i < exportConfigSelectionSubjects.length; i++) {
      if (exportConfigSelectionSubjects[i].getEnabled()) {
        return this.setEnabled(true);
      }
    }

    this.setEnabled(false);
  };

  return CloudHistoryExportExecuteCommand;
});
