/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.clUtilsBacnet.util;

import com.tridium.bacnet.history.BAbstractBacnetHistory;
import com.tridium.clUtils.util.BHistoryImportHelper;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Optional;
import java.util.logging.Level;
import javax.baja.bacnet.datatypes.BBacnetDeviceObjectPropertyReference;
import javax.baja.driver.history.BHistoryImport;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraSingleton
public class BBacnetHistoryImportHelper
extends BHistoryImportHelper {
    public static final BBacnetHistoryImportHelper INSTANCE = new BBacnetHistoryImportHelper();
    public static final Type TYPE = Sys.loadType(BBacnetHistoryImportHelper.class);
    private static Method getDeviceObjectProp;

    public Type getType() {
        return TYPE;
    }

    public Optional<String> getReferenceInfo(BHistoryImport historyImport) {
        if (!(historyImport instanceof BAbstractBacnetHistory)) {
            return Optional.empty();
        }
        try {
            BBacnetDeviceObjectPropertyReference reference = (BBacnetDeviceObjectPropertyReference)getDeviceObjectProp.invoke((Object)historyImport, new Object[0]);
            if (reference == null) {
                return Optional.empty();
            }
            if (!reference.isDeviceIdUsed()) {
                BAbstractBacnetHistory bacnetHistoryImport = (BAbstractBacnetHistory)historyImport;
                if (bacnetHistoryImport.device() == null) {
                    return Optional.empty();
                }
                reference.setDeviceId(bacnetHistoryImport.device().getObjectId());
            }
            return Optional.of(reference.encodeToString());
        }
        catch (IOException | IllegalAccessException | InvocationTargetException ex) {
            log.log(Level.INFO, "unable to obtain bacnet device object property reference", log.isLoggable(Level.FINE) ? ex : null);
            return Optional.empty();
        }
    }

    protected void registerSelf() {
        try {
            TypeInfo[] importInfos;
            getDeviceObjectProp = BAbstractBacnetHistory.class.getDeclaredMethod("getDeviceObjectProp", new Class[0]);
            AccessController.doPrivileged(() -> {
                getDeviceObjectProp.setAccessible(true);
                return getDeviceObjectProp;
            });
            for (TypeInfo importInfo : importInfos = Sys.getRegistry().getConcreteTypes(BAbstractBacnetHistory.TYPE.getTypeInfo())) {
                BHistoryImportHelper.registerHelper((String)importInfo.getTypeClassName(), this::getReferenceInfo);
            }
        }
        catch (NoSuchMethodException | PrivilegedActionException ex) {
            log.log(Level.INFO, "unable to initialize BBacnetHistoryImportHelper", log.isLoggable(Level.FINE) ? ex : null);
        }
    }
}

