/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.clUtilsBacnet.util;

import com.tridium.clUtils.device.BDeviceInfoHelper;
import com.tridium.clUtils.util.TagUtil;
import java.util.HashMap;
import java.util.Map;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.config.BBacnetConfigDeviceExt;
import javax.baja.bacnet.config.BBacnetDeviceObject;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.driver.BDevice;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BIObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"bacnet:BacnetDevice"})})
public class BBacnetDeviceInfoHelper
extends BDeviceInfoHelper {
    public static final Type TYPE = Sys.loadType(BBacnetDeviceInfoHelper.class);

    public Type getType() {
        return TYPE;
    }

    protected void registerSelf() {
        TypeInfo[] deviceInfos;
        for (TypeInfo deviceInfo : deviceInfos = Sys.getRegistry().getConcreteTypes(BBacnetDevice.TYPE.getTypeInfo())) {
            BDeviceInfoHelper.registerHelper((String)deviceInfo.getTypeClassName(), this::getDeviceData);
        }
    }

    public Map<String, Object> getDeviceData(BDevice device) {
        BBacnetDeviceObject deviceData;
        Map valueMap = super.getDeviceData(device);
        BBacnetConfigDeviceExt configData = ((BBacnetDevice)device).getConfig();
        if (configData != null && (deviceData = configData.getDeviceObject()) != null) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("description", this.getDescription(deviceData));
            properties.put("type", device.getType().getTypeInfo().toString());
            properties.put("protocol", "BACnet");
            properties.put("manufacturer", deviceData.getVendorName());
            properties.put("model", deviceData.getModelName());
            properties.put("firmware-version", deviceData.getFirmwareRevision());
            properties.put("software-version", deviceData.getApplicationSoftwareVersion());
            properties.put("technical-address", (String)device.getSlotPath());
            properties.put("vendor-name", deviceData.getVendorName());
            properties.put("model-name", deviceData.getModelName());
            properties.put("firmware-revision", deviceData.getFirmwareRevision());
            properties.put("application-software-version", deviceData.getApplicationSoftwareVersion());
            properties.put("vendor-id", (String)deviceData.getVendorIdentifier());
            properties.put("location", this.getLocation(deviceData));
            properties.put("protocol-version", (String)deviceData.getProtocolVersion());
            properties.put("protocol-revision", (String)deviceData.getProtocolRevision());
            String deviceUuid = this.getDeviceUuid(deviceData, device);
            properties.put("device-uuid", deviceUuid);
            valueMap.put("properties", properties);
        }
        return valueMap;
    }

    private String getLocation(BBacnetDeviceObject bacnetDeviceObject) {
        BValue location = bacnetDeviceObject.get(BBacnetPropertyIdentifier.location.getTag());
        return location != null ? location.toString() : null;
    }

    private String getDescription(BBacnetDeviceObject bacnetDeviceObject) {
        BValue description = bacnetDeviceObject.get(BBacnetPropertyIdentifier.description.getTag());
        return description != null ? description.toString() : "";
    }

    private String getDeviceUuid(BBacnetDeviceObject bacnetDeviceObject, BDevice device) {
        BValue uuid = bacnetDeviceObject.get("deviceUuid");
        String deviceUuid = uuid != null ? uuid.toString() : "";
        return deviceUuid.isEmpty() ? (String)TagUtil.getCloudIdString((BIObject)device).orElse(null) : deviceUuid;
    }
}

