/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.clUtilsNiagara.util;

import com.tridium.clUtils.device.BDeviceInfoHelper;
import com.tridium.clUtils.device.IDeviceInfoHelper;
import com.tridium.nd.BNiagaraStation;
import java.util.HashMap;
import java.util.Map;
import javax.baja.driver.BDevice;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"niagaraDriver:NiagaraStation"})})
public class BNiagaraDeviceInfoHelper
extends BDeviceInfoHelper {
    public static final Type TYPE = Sys.loadType(BNiagaraDeviceInfoHelper.class);

    public Type getType() {
        return TYPE;
    }

    protected void registerSelf() {
        TypeInfo[] deviceInfos;
        for (TypeInfo deviceInfo : deviceInfos = Sys.getRegistry().getConcreteTypes(BNiagaraStation.TYPE.getTypeInfo())) {
            BNiagaraDeviceInfoHelper.registerHelper((String)deviceInfo.getTypeClassName(), (IDeviceInfoHelper)this);
        }
    }

    public Map<String, Object> getDeviceData(BDevice station) {
        Map valueMap = super.getDeviceData(station);
        BNiagaraStation niagaraStation = (BNiagaraStation)station;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("description", BNiagaraDeviceInfoHelper.getDescription(niagaraStation));
        properties.put("type", niagaraStation.getType().getTypeInfo().toString());
        properties.put("protocol", "Fox");
        properties.put("manufacturer", "Tridium");
        properties.put("model", niagaraStation.getHostModel());
        properties.put("firmware-version", niagaraStation.getHostModelVersion());
        properties.put("software-version", niagaraStation.getVersion());
        properties.put("technical-address", (String)niagaraStation.getSlotPath());
        properties.put("host-model", niagaraStation.getHostModel());
        properties.put("host-model-version", niagaraStation.getHostModelVersion());
        properties.put("remote-host", BNiagaraDeviceInfoHelper.getRemoteHost(niagaraStation));
        properties.put("location", BNiagaraDeviceInfoHelper.getLocation(niagaraStation));
        valueMap.put("properties", properties);
        return valueMap;
    }

    private static String getRemoteHost(BNiagaraStation niagaraStation) {
        return niagaraStation.getAddress() != BOrd.NULL ? niagaraStation.getRemoteHost().getHostname() : "null";
    }

    private static String getLocation(BNiagaraStation niagaraStation) {
        BValue location = niagaraStation.get("location");
        return location != null ? location.toString() : null;
    }

    private static String getDescription(BNiagaraStation niagaraStation) {
        BValue description = niagaraStation.get("description");
        return description != null ? description.toString() : "";
    }
}

