/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.clUtils.util;

import com.tridium.clUtils.util.IProxyPointResolver;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.driver.point.BProxyExt;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BSingleton;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public abstract class BProxyPointHelper
extends BSingleton {
    public static final Type TYPE = Sys.loadType(BProxyPointHelper.class);
    private static Map<String, IProxyPointResolver> helperMap;
    protected static final Logger log;

    public Type getType() {
        return TYPE;
    }

    public static Optional<String> getReference(BProxyExt proxyExt) {
        if (helperMap == null) {
            BProxyPointHelper.registerHelpers();
        }
        if (!helperMap.containsKey(proxyExt.getClass().getName())) {
            return Optional.empty();
        }
        return helperMap.get(proxyExt.getClass().getName()).getReference(proxyExt);
    }

    protected static void registerHelper(String className, IProxyPointResolver resolver) {
        helperMap.put(className, resolver);
    }

    private static void registerHelpers() {
        try {
            TypeInfo[] helperInfos = Sys.getRegistry().getConcreteTypes(TYPE.getTypeInfo());
            helperMap = new HashMap<String, IProxyPointResolver>();
            for (TypeInfo helperInfo : helperInfos) {
                BProxyPointHelper helper = (BProxyPointHelper)helperInfo.getInstance().as(BProxyPointHelper.class);
                helper.registerSelf();
            }
        }
        catch (Exception ex) {
            log.log(Level.INFO, "Cannot add history import helper implementation", log.isLoggable(Level.FINE) ? ex : null);
        }
    }

    protected abstract void registerSelf();

    static {
        log = Logger.getLogger("clUtils");
    }
}

