/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.msg;

import com.tridium.cloudLink.channel.BHistoriesChannel;
import com.tridium.cloudLink.forge.channel.BForgeHistoryChannelConfig;
import com.tridium.cloudLink.msg.GetHistoriesResult;
import com.tridium.collection.BListTable;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BIHistory;
import javax.baja.history.HistoryCursor;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BLong;
import javax.baja.sys.BNumber;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public final class ForgeHttpGetHistoriesResult
implements GetHistoriesResult {
    private static final Logger log = Logger.getLogger("cloudLink.channel.history");
    private final BListTable<BHistoryRecord> historyTable;
    private final BHistoryId historyId;
    private final String systemId;
    private static final int VERSION = 1;

    public ForgeHttpGetHistoriesResult(String body, BForgeHistoryChannelConfig config) throws Exception {
        this.systemId = config.getSystemId();
        JSONObject payload = new JSONObject(body);
        log.finest(() -> "ForgeHttpGetHistoriesResponse: bodyStr=" + body + "; payload=" + payload);
        JSONArray pointDetailsArray = payload.getJSONArray("pointDetails");
        if (pointDetailsArray.isEmpty()) {
            log.info("get histories result aborting, no records returned from cloud data store");
            this.historyId = BHistoryId.DEFAULT;
            this.historyTable = null;
            return;
        }
        JSONObject pointDetails = pointDetailsArray.getJSONObject(0);
        String telemetryId = pointDetails.getString("pointId");
        BHistoriesChannel historiesChannel = (BHistoriesChannel)config.getChannel().orElseThrow(() -> new Exception("channel not found"));
        Optional optHistory = historiesChannel.getHistory(telemetryId);
        if (!optHistory.isPresent()) {
            log.info("get histories result aborting, telemetry id not found: " + telemetryId);
            this.historyId = BHistoryId.DEFAULT;
            this.historyTable = null;
            return;
        }
        BIHistory history = (BIHistory)optHistory.get();
        this.historyId = history.getId();
        BTypeSpec spec = history.getRecordType();
        JSONObject preRecordJson = pointDetails.optJSONObject("preRecord");
        BHistoryRecord preRec = null;
        if (preRecordJson != null) {
            preRec = ForgeHttpGetHistoriesResult.makeRecord(spec, preRecordJson);
        }
        JSONObject postRecordJson = pointDetails.optJSONObject("postRecord");
        BHistoryRecord postRec = null;
        if (postRecordJson != null) {
            postRec = ForgeHttpGetHistoriesResult.makeRecord(spec, postRecordJson);
        }
        BFacets cxFacets = null;
        try {
            cxFacets = HistoryCursor.makeBoundaryRecordFacets((BHistoryRecord)preRec, (BHistoryRecord)postRec);
        }
        catch (IOException ex) {
            log.log(Level.CONFIG, "error getting boundary record facet information", log.isLoggable(Level.FINE) ? ex : null);
        }
        JSONArray recordsJson = pointDetails.getJSONArray("historyRecords");
        ArrayList<BHistoryRecord> records = new ArrayList<BHistoryRecord>(recordsJson.length());
        for (int lcv = 0; lcv < recordsJson.length(); ++lcv) {
            records.add(ForgeHttpGetHistoriesResult.makeRecord(spec, recordsJson.getJSONObject(lcv)));
        }
        Context cx = GetHistoriesResult.makeHistoryQueryResultCountContext((Context)cxFacets, (int)records.size());
        this.historyTable = new BListTable(records, cx);
    }

    public GetHistoriesResult.HistoriesResultPage page() {
        return new GetHistoriesResult.HistoriesResultPage(){

            public int getPageSize() {
                return 0;
            }

            public int getTotalElements() {
                return 0;
            }

            public int getPageCount() {
                return 0;
            }

            public int getPageNumber() {
                return 0;
            }
        };
    }

    public GetHistoriesResult.HistoriesResultLinks links() {
        return new GetHistoriesResult.HistoriesResultLinks(){

            public String getFirst() {
                return null;
            }

            public String getSelf() {
                return null;
            }

            public String getNext() {
                return null;
            }

            public String getLast() {
                return null;
            }
        };
    }

    public Map<String, Map<BHistoryId, Cursor<BHistoryRecord>>> getHistoriesMap() {
        if (this.historyTable == null) {
            return Collections.singletonMap(this.systemId, Collections.emptyMap());
        }
        return Collections.singletonMap(this.systemId, Collections.singletonMap(this.historyId, this.historyTable.cursor()));
    }

    public String getVersion() {
        return Objects.toString(1);
    }

    private static BHistoryRecord makeRecord(BTypeSpec spec, JSONObject recordJson) {
        BHistoryRecord rec = (BHistoryRecord)spec.getInstance().as(BHistoryRecord.class);
        try {
            rec.setTimestamp(BAbsTime.make((String)recordJson.getString("time")));
        }
        catch (IOException e) {
            log.info("Unable to deserialize history timestamp");
        }
        Object value = recordJson.get("value");
        JSONObject properties = recordJson.optJSONObject("properties");
        if (properties == null) {
            properties = new JSONObject();
        }
        ForgeHttpGetHistoriesResult.inflateRecord((BComplex)rec, "", properties, value);
        return rec;
    }

    private static void inflateRecord(BComplex record, String prefix, JSONObject json, Object value) {
        SlotCursor properties = record.getProperties();
        while (properties.next()) {
            Property property = properties.property();
            if (prefix != null && prefix.isEmpty() && property.getName().equals("timestamp")) continue;
            Type propType = property.getType();
            if (propType.is(BComplex.TYPE)) {
                BComplex complexProp = (BComplex)propType.getInstance();
                ForgeHttpGetHistoriesResult.inflateRecord(complexProp, prefix + property.getName() + '.', json, value);
                record.set(property, (BValue)complexProp);
                continue;
            }
            try {
                Object prop = json.opt(prefix + property.getName());
                if (prefix != null && prefix.isEmpty() && property.getName().equals("value")) {
                    prop = value;
                }
                if (prop == null) continue;
                if (propType.is(BINumeric.TYPE)) {
                    if (prop instanceof Long && propType.is(BLong.TYPE)) {
                        record.set(property, (BValue)BLong.make((long)((Long)prop)));
                        continue;
                    }
                    if (prop instanceof Number) {
                        record.set(property, (BValue)BNumber.cast((double)((Number)prop).doubleValue(), (Type)propType));
                        continue;
                    }
                    record.set(property, (BValue)BNumber.cast((double)Double.parseDouble(prop.toString()), (Type)propType));
                    continue;
                }
                if (propType.is(BIBoolean.TYPE)) {
                    if (prop instanceof Boolean) {
                        record.set(property, (BValue)BBoolean.make((boolean)((Boolean)prop)));
                        continue;
                    }
                    record.set(property, (BValue)BBoolean.make((String)prop.toString()));
                    continue;
                }
                if (propType.is(BIEnum.TYPE)) {
                    if (prop instanceof Integer) {
                        record.set(property, (BValue)((BIEnum)propType.getInstance()).getEnum().getRange().get(((Integer)prop).intValue()));
                        continue;
                    }
                    record.set(property, (BValue)((BIEnum)propType.getInstance()).getEnum().getRange().get(prop.toString()));
                    continue;
                }
                record.set(property, (BValue)((BSimple)propType.getInstance().as(BSimple.class)).decodeFromString(prop.toString()));
            }
            catch (IOException ex) {
                log.log(Level.INFO, "error decoding history record field " + prefix + property.getName(), log.isLoggable(Level.FINE) ? ex : null);
            }
        }
    }
}

