/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.msg;

import com.tridium.cloudLink.channel.BAbstractClientChannel;
import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.file.FileUploadRequest;
import com.tridium.cloudLink.file.FileUploader;
import com.tridium.cloudLink.forge.channel.BIForgeHistoryChannelConfig;
import com.tridium.cloudLink.forge.msg.ForgeAmqpSendHistoriesResult;
import com.tridium.cloudLink.forge.msg.ForgeHistorySerializer;
import com.tridium.cloudLink.history.HistoryItemWrapper;
import com.tridium.cloudLink.msg.ISendBulkHistoriesHandler;
import com.tridium.cloudLink.msg.SendHistoriesResult;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.cloudLink.transport.IMessageResponse;
import com.tridium.json.JSONWriter;
import com.tridium.json.quick.QuickJSONWriter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;

public class ForgeFileSendHistoriesBulkHandler
implements ISendBulkHistoriesHandler {
    private CompletableFuture<DataOutputStream> uploadStreamInitialized;
    private CompletableFuture<Void> dataUploaded;
    private CompletableFuture<Void> uploadCompleted;
    private final BIForgeHistoryChannelConfig config;
    private final long defaultMessageTimeoutMillis;
    private boolean _hasData;
    private DataOutputStream countingStream;
    private OutputStreamWriter writer;
    private ForgeHistorySerializer serializer;
    private int fileCounter;
    public static final String FILE_NAME_TEMPLATE = "%s_history_%s_%s.gz";
    private static final String FILE_TYPE = "filetype";
    private static final String FILE_TYPE_VALUE = "history+gzip";
    private static final String MIME_TYPE = "mimetype";
    private static final String VERSION = "version";
    private static final String VERSION_VALUE = "2";
    private static final String MODE = "mode";
    private static final String MODE_VALUE = "BackfillAfterReconnect";
    private static final Logger log = Logger.getLogger("cloudLink.channel.history");
    private static final Map<String, String> METADATA = new HashMap<String, String>();

    public ForgeFileSendHistoriesBulkHandler(BChannelConfig channelConfig) {
        this.config = (BIForgeHistoryChannelConfig)channelConfig;
        this.config.setExportId(this.config.getExportId() + 1);
        this.defaultMessageTimeoutMillis = this.config.getTransport(ISendBulkHistoriesHandler.getOperationId()).getDefaultMessageTimeout().getMillis();
    }

    public int add(HistoryItemWrapper value) {
        if (this.uploadStreamInitialized == null) {
            this.initializeUploadStream();
        }
        if (this.uploadCompleted.isCompletedExceptionally()) {
            this.uploadCompleted.join();
        }
        if (this.dataUploaded.isCompletedExceptionally()) {
            this.dataUploaded.join();
        }
        this.serializer.serializeRecord(value);
        this._hasData = true;
        return this.countingStream.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMessage toMessage(boolean isFinal) {
        if (this.uploadStreamInitialized == null) {
            String msg = "Error uploading history backfill file: upload stream close requested before stream was initialized";
            log.warning(msg);
            throw new RuntimeException(msg);
        }
        if (this.uploadCompleted.isCompletedExceptionally()) {
            this.uploadStreamInitialized = null;
            this._hasData = false;
            this.uploadCompleted.join();
        }
        if (this.dataUploaded.isCompletedExceptionally()) {
            this.uploadStreamInitialized = null;
            this._hasData = false;
            this.dataUploaded.join();
        }
        this.serializer.serializeEnd();
        try {
            this.close();
            this.dataUploaded.complete(null);
        }
        catch (IOException ex) {
            String msg = "Unable to close upload stream for history backfill";
            log.log(Level.WARNING, msg, log.isLoggable(Level.FINE) ? ex : null);
            this.dataUploaded.completeExceptionally(ex);
        }
        catch (RuntimeException ex) {
            String msg = "Unable to close upload stream for history backfill";
            log.log(Level.WARNING, msg, log.isLoggable(Level.FINE) ? ex : null);
            this.dataUploaded.completeExceptionally(ex);
        }
        finally {
            this.uploadStreamInitialized = null;
            this._hasData = false;
        }
        return null;
    }

    public CompletableFuture<IMessageResponse> getFuture(CompletableFuture<SendHistoriesResult> channelFuture, IMessage message) {
        CompletableFuture<IMessageResponse> future = new CompletableFuture<IMessageResponse>();
        if (this.uploadCompleted == null) {
            String msg = "Cannot get future for histories backfill file";
            log.warning(msg);
            future.completeExceptionally(new RuntimeException(msg));
            channelFuture.completeExceptionally(new RuntimeException(msg));
            return future;
        }
        this.uploadCompleted.whenComplete((resp, err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
            } else {
                future.complete(null);
            }
        });
        future.whenComplete((resp, err) -> {
            if (err != null) {
                channelFuture.completeExceptionally((Throwable)err);
                return;
            }
            channelFuture.complete(new ForgeAmqpSendHistoriesResult(1));
        });
        return future;
    }

    public boolean hasData() {
        return this._hasData;
    }

    protected void initializeUploadStream() {
        GZIPOutputStream compressedStream;
        BAbstractClientChannel channel = (BAbstractClientChannel)this.config.getParent();
        Optional optUploader = channel.getConnectionService().flatMap(ccs -> ccs.getFileUploader(channel));
        if (!optUploader.isPresent()) {
            String msg = "Cannot upload history backfill file as no file uploader is registered for the Histories Channel";
            log.warning(msg);
            throw new RuntimeException(msg);
        }
        long dataUploadTimeoutMillis = this.config.getBackfillFileUploadTimeout().getMillis();
        this.uploadStreamInitialized = new CompletableFuture();
        CompletableFuture localDataUploaded = new CompletableFuture();
        this.dataUploaded = localDataUploaded;
        Consumer<OutputStream> fileData = out -> {
            this.uploadStreamInitialized.complete(new DataOutputStream((OutputStream)out));
            try {
                localDataUploaded.get(dataUploadTimeoutMillis, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException ex) {
                String msg = String.format("Upload for history backfill file timed out after %d ms", dataUploadTimeoutMillis);
                log.log(Level.WARNING, msg, log.isLoggable(Level.FINE) ? ex : null);
                throw new RuntimeException(msg, new IOException(ex));
            }
            catch (InterruptedException | ExecutionException ex) {
                String msg = "Error while waiting on history backfill file to upload";
                log.log(Level.WARNING, msg, log.isLoggable(Level.FINE) ? ex : null);
                throw new RuntimeException(msg, new IOException(ex));
            }
        };
        FileUploader uploader = (FileUploader)optUploader.get();
        String filename = String.format(FILE_NAME_TEMPLATE, this.config.getSystemGuid(), this.config.getExportId(), this.fileCounter++);
        FileUploadRequest request = new FileUploadRequest(filename, fileData, METADATA);
        this.uploadCompleted = uploader.upload(request);
        try {
            this.countingStream = this.uploadStreamInitialized.get(this.defaultMessageTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException ex) {
            log.log(Level.WARNING, String.format("Attempt to initialize upload for history backfill file %s timed out after %d ms", filename, this.defaultMessageTimeoutMillis), log.isLoggable(Level.FINE) ? ex : null);
            this.uploadStreamInitialized = null;
            this.dataUploaded.completeExceptionally(ex);
            return;
        }
        catch (InterruptedException | ExecutionException ex) {
            log.log(Level.WARNING, "There was an error while initializing the upload for history backfill file " + filename, log.isLoggable(Level.FINE) ? ex : null);
            this.uploadStreamInitialized = null;
            this.dataUploaded.completeExceptionally(ex);
            return;
        }
        try {
            compressedStream = new GZIPOutputStream(this.countingStream);
        }
        catch (IOException ex) {
            log.log(Level.WARNING, "Unable to create compressed upload stream for history backfill file " + filename, log.isLoggable(Level.FINE) ? ex : null);
            this.uploadStreamInitialized = null;
            this.dataUploaded.completeExceptionally(ex);
            return;
        }
        this.writer = new OutputStreamWriter((OutputStream)compressedStream, StandardCharsets.UTF_8);
        JSONWriter jsonSerializer = QuickJSONWriter.make((Appendable)this.writer);
        this.serializer = new ForgeHistorySerializer(jsonSerializer);
        this.serializer.serializeStart();
        this._hasData = false;
        log.finer(() -> "Initialized upload for history backfill file " + filename);
    }

    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
            this.writer.close();
            this.writer = null;
        }
    }

    static {
        METADATA.put(FILE_TYPE, FILE_TYPE_VALUE);
        METADATA.put(MIME_TYPE, "application/json+gzip");
        METADATA.put(VERSION, VERSION_VALUE);
        METADATA.put(MODE, MODE_VALUE);
    }
}

