/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.msg;

import com.tridium.clUtils.util.CloudIdConstants;
import com.tridium.cloudLink.CloudLinkConstants;
import com.tridium.cloudLink.forge.channel.BForgeModelChannelConfig;
import com.tridium.cloudLink.forge.model.ComponentEncoder;
import com.tridium.cloudLink.forge.model.ModelEncoderPlugin;
import com.tridium.cloudLink.forge.msg.IForgeModelEntitySerializer;
import com.tridium.cloudLink.model.BModelExportPolicy;
import com.tridium.cloudLink.objectIdentity.BCloudIdManager;
import com.tridium.tagdictionary.BNiagaraTagDictionary;
import com.tridium.util.CompUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.units.BUnit;

public final class ForgeFileHistoryConfigSerializer
implements IForgeModelEntitySerializer<BHistoryConfig>,
AutoCloseable {
    private static final String RANGE = SlotPath.escape((String)"n:range");
    private static final String UNITS = SlotPath.escape((String)"n:units");
    private static final String TRUE_TEXT = SlotPath.escape((String)"n:trueText");
    private static final String FALSE_TEXT = SlotPath.escape((String)"n:falseText");
    private final BForgeModelChannelConfig config;
    private final ModelEncoderPlugin plugin;
    private final ComponentEncoder encoder;
    private final BCloudIdManager manager;

    public ForgeFileHistoryConfigSerializer(BForgeModelChannelConfig config, Map<String, Object> properties, ModelEncoderPlugin plugin) throws IOException {
        this.config = config;
        this.plugin = plugin;
        this.encoder = new ComponentEncoder(plugin);
        this.encoder.setEncodeTransients(false);
        this.encoder.setConfig(config);
        BModelExportPolicy policy = (BModelExportPolicy)properties.get("policy");
        this.encoder.setComponentTypePredicate(policy.getComponentTypeIncludedInModel());
        this.encoder.setRelationTypePredicate(policy.getRelationTypeIncludeInModel());
        this.manager = config.getChannel().flatMap(c -> c.getConnectionService()).map(ccs -> ccs.getCloudIdManager()).orElseThrow(() -> new IllegalStateException("Unable to get CloudIdManager while trying to serialize history model data."));
    }

    @Override
    public void serialize(BHistoryConfig historyConfig) throws IOException {
        BHistoryId histId = historyConfig.getId();
        Optional optTelemetryId = this.manager.getTelemetryId(histId);
        if (optTelemetryId.isPresent()) {
            CompUtil.setOrAdd((BComponent)historyConfig, (String)SlotPath.escape((String)BNiagaraTagDictionary.HISTORY.getQName()), (BValue)BString.make((String)SlotPath.unescape((String)historyConfig.getId().encodeToString())), (int)90113, (BFacets)BFacets.NULL, null);
            String telemetryId = (String)optTelemetryId.get();
            CompUtil.setOrAdd((BComponent)historyConfig, (String)CloudIdConstants.ESCAPED_CLOUD_ID_TAG, (BValue)BString.make((String)telemetryId), (int)90113, (BFacets)BFacets.NULL, null);
            CompUtil.setOrAdd((BComponent)historyConfig, (String)SlotPath.escape((String)"nc:telemetryId"), (BValue)BString.make((String)telemetryId), (int)90113, (BFacets)BFacets.NULL, null);
            CompUtil.setOrAdd((BComponent)historyConfig, (String)CloudLinkConstants.ESCAPED_DATA_TYPE_TAG, (BValue)BString.make((String)this.config.getDataType(historyConfig.getRecordType().getTypeInfo())), (int)90113, (BFacets)BFacets.NULL, null);
            CompUtil.setOrAdd((BComponent)historyConfig, (String)SlotPath.escape((String)BNiagaraTagDictionary.TYPE_ID.getQName()), (BValue)BString.make((String)historyConfig.getType().getTypeSpec().encodeToString()), (int)81921, (BFacets)BFacets.NULL, null);
            BFacets facets = (BFacets)historyConfig.get("valueFacets");
            if (facets != null) {
                String[] keys;
                String[] stringArray = keys = facets.list();
                int n = stringArray.length;
                block12: for (int i = 0; i < n; ++i) {
                    String key;
                    switch (key = stringArray[i]) {
                        case "range": {
                            BEnumRange range = (BEnumRange)facets.get(key);
                            int[] ordinals = range.getOrdinals();
                            String rangeString = Arrays.stream(ordinals).mapToObj(o -> range.getTag(o) + '=' + o).collect(Collectors.joining(",", "{", "}"));
                            CompUtil.setOrAdd((BComponent)historyConfig, (String)RANGE, (BValue)BString.make((String)rangeString), (int)81921, (BFacets)BFacets.NULL, null);
                            continue block12;
                        }
                        case "units": {
                            BUnit unit = (BUnit)facets.get(key);
                            if (unit == BUnit.NULL) continue block12;
                            CompUtil.setOrAdd((BComponent)historyConfig, (String)UNITS, (BValue)BString.make((String)unit.toString()), (int)81921, (BFacets)BFacets.NULL, null);
                            continue block12;
                        }
                        case "trueText": {
                            CompUtil.setOrAdd((BComponent)historyConfig, (String)TRUE_TEXT, (BValue)((BValue)facets.get(key)), (int)81921, (BFacets)BFacets.NULL, null);
                            continue block12;
                        }
                        case "falseText": {
                            CompUtil.setOrAdd((BComponent)historyConfig, (String)FALSE_TEXT, (BValue)((BValue)facets.get(key)), (int)81921, (BFacets)BFacets.NULL, null);
                        }
                    }
                }
            }
            this.plugin.key(telemetryId);
            this.encoder.encode(historyConfig.getName(), (BValue)historyConfig, 0);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.encoder != null) {
            this.encoder.close();
        }
    }
}

