/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.msg;

import biweekly.Biweekly;
import biweekly.ICalendar;
import com.tridium.clUtils.util.TagUtil;
import com.tridium.cloudLink.CloudLinkUtils;
import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.file.FileUploadRequest;
import com.tridium.cloudLink.file.FileUploader;
import com.tridium.cloudLink.forge.channel.BForgeScheduleChannelConfig;
import com.tridium.cloudLink.msg.IExportScheduleHandler;
import com.tridium.cloudLink.schedule.converter.ScheduleConverter;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.cloudLink.transport.IMessageResponse;
import com.tridium.cloudLink.util.ProtectedFileUtil;
import com.tridium.cloudLink.util.TeeOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.sys.BIObject;

public class ForgeFileExportScheduleHandler
implements IExportScheduleHandler {
    private final BForgeScheduleChannelConfig config;
    private final ScheduleConverter scheduleConverter = new ScheduleConverter();
    private String scheduleName;
    private ICalendar iCal;
    private String fileName;
    private File file;
    Consumer<OutputStream> fileDataConsumer;
    private FileUploadRequest fileUploadRequest;
    public static final String FILE_TYPE = "fileType";
    public static final String FORMAT = "format";
    public static final String FILE_NAME = "filename";
    public static final String SCHEDULE = "schedule";
    public static final String MIME_TYPE = "mimetype";
    public static final String VERSION = "version";
    public static final String VERSION_VALUE = "1.0";
    protected static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyyMMddHHmmss").withZone(ZoneId.of("UTC"));
    protected static final String FILE_NAME_TEMPLATE = "schedule_%s_%s_%s.ics.gz";
    protected static final Logger log = Logger.getLogger("cloudLink.channel.schedule");

    public ForgeFileExportScheduleHandler(BChannelConfig channelConfig) {
        this.config = (BForgeScheduleChannelConfig)channelConfig;
    }

    public int add(BAbstractSchedule value) {
        if (!this.config.getSaveToFile() && !this.config.getUploadToCloud()) {
            String msg = String.format("Schedule %s was not exported (uploaded or saved) due to configuration settings.", this.scheduleName);
            log.warning(msg);
            throw new IllegalStateException(msg);
        }
        if (this.iCal != null) {
            String msg = "A schedule has already been added.";
            log.warning(msg);
            throw new IllegalStateException(msg);
        }
        this.scheduleName = value.getDisplayName(null);
        Optional cloudIdIOpt = TagUtil.getCloudIdString((BIObject)value.asComponent());
        String scheduleCloudId = (String)cloudIdIOpt.orElseThrow(() -> {
            String msg = String.format("Schedule export failed because %s does not have a cloudId.", this.scheduleName);
            log.warning(msg);
            return new IllegalStateException(msg);
        });
        try {
            this.iCal = this.scheduleConverter.convert(value, new ICalendar());
            this.fileName = String.format(FILE_NAME_TEMPLATE, this.config.getSystemGuid(), scheduleCloudId, OffsetDateTime.now().format(DATE_FORMAT));
        }
        catch (IOException ioExcept) {
            String msg = String.format("Schedule %s could not be converted to a calendar: %s", this.scheduleName, ioExcept.getMessage());
            log.log(Level.WARNING, msg, log.isLoggable(Level.FINE) ? ioExcept : null);
            throw new UncheckedIOException(ioExcept);
        }
        return 0;
    }

    public IMessage toMessage(boolean isFinal) {
        if (this.iCal == null) {
            String msg = "Schedule export failed because no schedule was added to the message.";
            log.warning(msg);
            throw new IllegalStateException(msg);
        }
        if (this.config.getSaveToFile()) {
            this.file = ForgeFileExportScheduleHandler.makeFile(this.fileName);
        }
        if (this.config.getUploadToCloud()) {
            Map<String, String> metadata = ForgeFileExportScheduleHandler.setMetaDataProperties(this.fileName);
            this.fileDataConsumer = this.file == null ? ForgeFileExportScheduleHandler.makeFileDataConsumer(this.iCal) : ForgeFileExportScheduleHandler.makeFileDataConsumer(this.iCal, this.file);
            this.fileUploadRequest = new FileUploadRequest(this.fileName, this.fileDataConsumer, metadata);
        }
        return null;
    }

    private static Map<String, String> setMetaDataProperties(String fileName) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put(FILE_TYPE, SCHEDULE);
        metadata.put(MIME_TYPE, "text/ics+gzip");
        metadata.put(VERSION, VERSION_VALUE);
        metadata.put(FORMAT, fileName);
        metadata.put(FILE_NAME, CloudLinkUtils.getFileNameWithoutExtension((String)fileName));
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<IMessageResponse> getFuture(CompletableFuture<Void> channelFuture, IMessage message) {
        if (this.fileUploadRequest != null) {
            Optional<FileUploader> fileUploaderOpt = ForgeFileExportScheduleHandler.getFileUploader(this.config);
            if (!fileUploaderOpt.isPresent()) {
                String msg = String.format("Schedule %s was not uploaded because a file uploader has not been registered for the channel.", this.scheduleName);
                log.warning(msg);
                throw new IllegalStateException(msg);
            }
            fileUploaderOpt.get().upload(this.fileUploadRequest).whenComplete((resp, err) -> {
                if (err != null) {
                    log.log(Level.WARNING, String.format("Schedule export of %s failed during upload of file %s", this.scheduleName, this.fileName), log.isLoggable(Level.FINE) ? err : null);
                    channelFuture.completeExceptionally((Throwable)err);
                } else {
                    log.finer(String.format("Schedule %s was successfully uploaded.", this.scheduleName));
                    if (this.file != null) {
                        log.finer(String.format("Schedule %s was successfully saved to file %s", this.scheduleName, this.file.getAbsolutePath()));
                    }
                    channelFuture.complete(null);
                }
                this.reset();
            });
        } else if (this.file != null) {
            try {
                AccessController.doPrivileged(() -> {
                    try (GZIPOutputStream gzipStream = new GZIPOutputStream(Files.newOutputStream(this.file.toPath(), new OpenOption[0]));){
                        Biweekly.write((ICalendar[])new ICalendar[]{this.iCal}).go((OutputStream)gzipStream);
                    }
                    return null;
                });
                log.finer(String.format("Schedule %s was successfully saved to file %s", this.scheduleName, this.file.getAbsolutePath()));
                channelFuture.complete(null);
            }
            catch (PrivilegedActionException privExcept) {
                Throwable cause = privExcept.getCause();
                String msg = String.format("Schedule export of %s failed to save to file %s; %s", this.scheduleName, this.file.getAbsolutePath(), cause.getMessage());
                log.log(Level.WARNING, msg, log.isLoggable(Level.FINE) ? cause : null);
                channelFuture.completeExceptionally(cause);
            }
            finally {
                this.reset();
            }
        } else {
            throw new IllegalStateException("Schedule failed to upload or save; there is no message to send.");
        }
        return null;
    }

    private static File makeFile(String filename) {
        try {
            return AccessController.doPrivileged(() -> {
                ProtectedFileUtil.getOrCreateProtectedFolder((String)"cloudLinkSchedule");
                return ProtectedFileUtil.makeProtectedFile((String)("cloudLinkSchedule" + File.separator + filename));
            });
        }
        catch (PrivilegedActionException privExcept) {
            Throwable cause = privExcept.getCause();
            String msg = String.format("Schedule export failed to create file %s; %s", filename, cause.getMessage());
            log.log(Level.WARNING, msg, log.isLoggable(Level.FINE) ? cause : null);
            if (cause instanceof IOException) {
                throw new UncheckedIOException((IOException)cause);
            }
            throw new UndeclaredThrowableException(cause);
        }
    }

    private static Consumer<OutputStream> makeFileDataConsumer(ICalendar iCal) {
        return uploadStream -> {
            try (GZIPOutputStream gZipStream = new GZIPOutputStream((OutputStream)uploadStream);){
                Biweekly.write((ICalendar[])new ICalendar[]{iCal}).go((OutputStream)gZipStream);
            }
            catch (IOException ioExcept) {
                log.log(Level.WARNING, "Schedule upload failed: " + ioExcept.getMessage(), log.isLoggable(Level.FINE) ? ioExcept : null);
                throw new UncheckedIOException(ioExcept);
            }
        };
    }

    private static Consumer<OutputStream> makeFileDataConsumer(ICalendar iCal, File file) {
        return uploadStream -> {
            try {
                AccessController.doPrivileged(() -> {
                    try (GZIPOutputStream gZipStream = new GZIPOutputStream((OutputStream)new TeeOutputStream(uploadStream, Files.newOutputStream(file.toPath(), new OpenOption[0])));){
                        Biweekly.write((ICalendar[])new ICalendar[]{iCal}).go((OutputStream)gZipStream);
                    }
                    return null;
                });
            }
            catch (PrivilegedActionException privExcept) {
                Throwable cause = privExcept.getCause();
                log.log(Level.WARNING, String.format("Schedule upload and save failed for file %s: %s", file.getName(), cause.getMessage()), log.isLoggable(Level.FINE) ? cause : null);
                if (cause instanceof IOException) {
                    throw new UncheckedIOException((IOException)cause);
                }
                throw new UndeclaredThrowableException(cause);
            }
        };
    }

    private static Optional<FileUploader> getFileUploader(BForgeScheduleChannelConfig config) {
        return config.getChannel().flatMap(c -> c.getConnectionService().flatMap(ccs -> ccs.getFileUploader(c)));
    }

    private void reset() {
        this.scheduleName = null;
        this.iCal = null;
        this.fileName = null;
        this.file = null;
        this.fileDataConsumer = null;
        this.fileUploadRequest = null;
    }
}

