/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.msg;

import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.forge.channel.BForgeAmqpAlarmChannelConfig;
import com.tridium.cloudLink.forge.msg.ForgeAmqpAlarmHandler;
import com.tridium.cloudLink.msg.ISendAlarmHandler;
import com.tridium.cloudLink.transport.BAbstractTransport;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.cloudLink.transport.IMessageResponse;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.BAlarmRecord;

public class ForgeAmqpSendAlarmHandler
extends ForgeAmqpAlarmHandler
implements ISendAlarmHandler {
    public static final String VERSION = "3";
    private static final Logger log = Logger.getLogger("cloudLink.channel.alarm");

    public ForgeAmqpSendAlarmHandler(BChannelConfig channelConfig) {
        super((BForgeAmqpAlarmChannelConfig)channelConfig);
    }

    public boolean add(BAlarmRecord alarm) {
        if (this._hasData) {
            return false;
        }
        try {
            String command = alarm.getAckTime().isNull() && alarm.getNormalTime().isNull() ? "NewAlarmMessage" : "AlarmChangedMessage";
            this.makeMessageHeaders(command, VERSION, this.config);
            this.initializeMessage();
            this.serializeAlarm(alarm);
            return true;
        }
        catch (Exception ex) {
            log.log(Level.INFO, "Error serializing alarm: " + ex.getMessage(), log.isLoggable(Level.FINE) ? ex : null);
            return false;
        }
    }

    @Override
    public IMessage toMessage(boolean isFinal) {
        if (!this._hasData) {
            return null;
        }
        this.jsonSerializer.endObject();
        return super.toMessage(isFinal);
    }

    public CompletableFuture<IMessageResponse> getFuture(CompletableFuture<Boolean> channelFuture, IMessage message) {
        CompletableFuture<IMessageResponse> future = new CompletableFuture<IMessageResponse>();
        future.whenComplete((resp, err) -> {
            if (err != null) {
                log.log(Level.WARNING, "Alarm message got error", log.isLoggable(Level.FINE) ? err : null);
                channelFuture.complete(false);
            } else {
                log.finer("Alarm message sent successfully");
                channelFuture.complete(true);
            }
        });
        return future;
    }

    @Override
    protected void initializeMessage() {
        super.initializeMessage();
        this.jsonSerializer.object();
        this.jsonSerializer.key("Alarm");
        this._hasData = false;
    }

    @Override
    protected BAbstractTransport getTransport() {
        return this.config.getTransport(ISendAlarmHandler.getOperationId());
    }
}

