/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.msg;

import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.command.BReadPointCommand;
import com.tridium.cloudLink.forge.channel.BForgeAmqpCommandChannelConfig;
import com.tridium.cloudLink.forge.msg.ForgeAmqpHandler;
import com.tridium.cloudLink.forge.msg.IForgeMultiPointReadCommandHandler;
import com.tridium.cloudLink.msg.IMultiPointReadCommandHandler;
import com.tridium.cloudLink.transport.AmqpMessage;
import com.tridium.cloudLink.transport.BAbstractTransport;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.cloudLink.transport.IMessageResponse;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BFacets;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;

public class ForgeAmqpMultiPointReadCommandHandler
extends ForgeAmqpHandler
implements IForgeMultiPointReadCommandHandler {
    private final BForgeAmqpCommandChannelConfig config;
    private String correlationId;
    public static final String COMMAND = "MultiPointReadResponse";
    public static final String VERSION = "1";
    private static final int MSG_END_SIZE = 2;
    private static final Logger log = Logger.getLogger("cloudLink.channel.command");

    public ForgeAmqpMultiPointReadCommandHandler(BChannelConfig channelConfig) {
        this.config = (BForgeAmqpCommandChannelConfig)channelConfig;
        this.makeMessageHeaders(COMMAND, VERSION, this.config);
        this.initializeMessage();
    }

    @Override
    public void addError(int code, String message) {
        this.jsonSerializer.object();
        this.jsonSerializer.key("PointId").value((Object)"");
        this.jsonSerializer.key("Status").value((Object)message);
        this.jsonSerializer.key("Value").value(null);
        this.jsonSerializer.endObject();
    }

    @Override
    public void addError(String pointId, int code, String message) {
        this.jsonSerializer.object();
        this.jsonSerializer.key("PointId").value((Object)pointId);
        this.jsonSerializer.key("Status").value((Object)message);
        this.jsonSerializer.key("Value").value(null);
        this.jsonSerializer.endObject();
    }

    @Override
    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public int add(String name, BReadPointCommand.StatusWrapper value) {
        BasicContext conversionContext = new BasicContext((Context)BFacets.make((String)"precision", (BIDataValue)value.getPrecision()));
        this.jsonSerializer.object();
        this.jsonSerializer.key("PointId").value((Object)name);
        this.jsonSerializer.key("Status").value((Object)value.getValue().getStatus().toString());
        this.jsonSerializer.key("Value").value((Object)value.getValue().getValueValue().toString((Context)conversionContext));
        this.jsonSerializer.endObject();
        return this.stringWriter.getBuffer().length() + 2;
    }

    @Override
    public IMessage toMessage(boolean isFinal) {
        this.jsonSerializer.endArray();
        this.jsonSerializer.endObject();
        AmqpMessage msg = (AmqpMessage)super.toMessage(isFinal);
        if (this.correlationId != null) {
            msg.getMessage().setCorrelationId((Object)this.correlationId);
            this.correlationId = null;
        }
        return msg;
    }

    public CompletableFuture<IMessageResponse> getFuture(CompletableFuture<Boolean> channelFuture, IMessage message) {
        CompletableFuture<IMessageResponse> future = new CompletableFuture<IMessageResponse>();
        future.whenComplete((resp, err) -> {
            if (err != null) {
                log.log(Level.WARNING, "Multi Point read command response got error", log.isLoggable(Level.FINE) ? err : null);
                channelFuture.complete(false);
            } else {
                log.finer("Multi Point read command response message sent successfully");
                channelFuture.complete(true);
            }
        });
        return future;
    }

    @Override
    protected void initializeMessage() {
        super.initializeMessage();
        this.jsonSerializer.object();
        this.jsonSerializer.key("PointValues").array();
    }

    @Override
    protected BAbstractTransport getTransport() {
        return this.config.getTransport(IMultiPointReadCommandHandler.getOperationId());
    }
}

