/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.msg;

import com.tridium.cloudLink.msg.GetLastTimestampsResult;
import com.tridium.json.JSONObject;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import javax.baja.sys.BAbsTime;

public final class ForgeAmqpGetLastTimestampResult
implements GetLastTimestampsResult {
    private final Map<String, BAbsTime> lastTimestamps = new HashMap<String, BAbsTime>();
    private static final int NO_TIMESTAMPS = 2;
    private static final int INTERNAL_SERVER_ERROR = 3;

    public ForgeAmqpGetLastTimestampResult(JSONObject data, Logger log) throws IOException {
        JSONObject body = null;
        try {
            body = data.getJSONArray("Messages").getJSONObject(0).getJSONObject("Body");
            if (body.getInt("ResponseCode") == 3) {
                throw new IOException("Forge experienced an error:" + body.optString("ErrorMessage"));
            }
            if (body.getInt("ResponseCode") != 2) {
                JSONObject timestamps = body.getJSONObject("PointsWithLastKnownTimeStamp");
                Iterator it = timestamps.keys();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    this.lastTimestamps.put(key, BAbsTime.make((String)timestamps.getString(key)));
                }
                Object err = body.opt("ErrorMessage");
                if (err instanceof String && !((String)err).isEmpty()) {
                    String[] ids;
                    for (String id : ids = ((String)err).split(",")) {
                        this.lastTimestamps.put(id, BAbsTime.DEFAULT);
                    }
                }
            }
        }
        catch (Exception ex) {
            if (body != null) {
                String err = body.optString("ErrorMessage");
                log.info(() -> String.format("Error parsing last timestamps message: %s", err));
            }
            throw ex;
        }
    }

    public Map<String, BAbsTime> getLastTimestamps() {
        return Collections.unmodifiableMap(this.lastTimestamps);
    }
}

