/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.model;

import com.tridium.clUtils.util.TagUtil;
import com.tridium.cloudLink.forge.channel.BForgeModelChannelConfig;
import com.tridium.cloudLink.forge.model.DefaultValueDocEncoder;
import com.tridium.cloudLink.forge.model.ModelEncoderPlugin;
import com.tridium.cloudLink.forge.util.CloudLinkForgeTagUtil;
import com.tridium.cloudLink.tag.CloudLinkTagUtil;
import com.tridium.sys.tag.ComponentTags;
import java.io.IOException;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.io.ValueDocEncoder;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BNumber;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.tag.BIEntity;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;
import javax.baja.tag.TagDictionaryService;
import javax.baja.tag.util.ImpliedTags;

public final class ComponentEncoder
extends DefaultValueDocEncoder {
    private static final Logger log = Logger.getLogger("cloudLink.channel.model");
    private static final String CLOUD_ID_NAME = "cId";
    private static final String RELATION_ID_NAME = "rId";
    public static final String PROPERTY_NAME = "p";
    public static final String TYPE_NAME = "t";
    private static final String INBOUND_NAME = "inbound";
    public static final String TAGS_NAME = "tags";
    public static final String RELATIONS_NAME = "relations";
    public static final String LINKS = "links";
    public static final String SOURCE_ID = "sourceId";
    public static final String SOURCE_SLOT = "sourceSlot";
    public static final String TARGET_ID = "targetId";
    public static final String TARGET_SLOT = "targetSlot";
    private BForgeModelChannelConfig config;
    private Predicate<BComponent> componentTypeIncludedInModel = c -> true;
    private Predicate<Relation> relationTypeIncludedInModel = r -> true;

    public ComponentEncoder(ValueDocEncoder.IEncoderPlugin plugin) throws IOException {
        super(plugin);
    }

    public ComponentEncoder(ValueDocEncoder.IEncoderPlugin plugin, Context context) throws IOException {
        super(plugin, context);
    }

    public ValueDocEncoder.IEncoderPlugin attr(String key, BIDataValue dv) throws IOException {
        if (dv instanceof BBoolean) {
            return this.plugin.attr(key, ((BBoolean)dv).getBoolean());
        }
        if (dv instanceof BInteger || dv instanceof BLong) {
            if (this.plugin instanceof ModelEncoderPlugin) {
                return ((ModelEncoderPlugin)this.plugin).attr(key, ((BNumber)dv).getLong());
            }
            return this.plugin.attr(key, (double)((BNumber)dv).getLong());
        }
        if (dv instanceof BFloat || dv instanceof BDouble) {
            return this.plugin.attr(key, ((BNumber)dv).getDouble());
        }
        return this.plugin.attr(key, dv.encodeToString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encodingComponent(BComponent component) throws IOException {
        try {
            super.encodingComponent(component);
            this.startArray(TAGS_NAME);
            try {
                TagDictionaryService tagDictionaryService = component.getTagDictionaryService();
                if (tagDictionaryService != null) {
                    ImpliedTags impliedTags = new ImpliedTags(tagDictionaryService, (Entity)component);
                    ComponentTags directTags = new ComponentTags(component);
                    impliedTags.getAll().stream().filter(t -> !directTags.contains(t.getId())).forEach(t -> {
                        Id tagId = t.getId();
                        String tagStr = tagId.getQName();
                        BIDataValue tagValue = t.getValue();
                        try {
                            this.start(PROPERTY_NAME);
                            try {
                                this.attr(tagStr, tagValue).endAttr();
                            }
                            finally {
                                this.end(PROPERTY_NAME);
                            }
                        }
                        catch (IOException ignore) {
                            log.finest("Unable to encode tag: " + tagId);
                        }
                    });
                }
            }
            finally {
                this.endArray();
            }
            this.startArray(RELATIONS_NAME);
            try {
                component.relations().getAll().stream().filter(this.relationTypeIncludedInModel.and(CloudLinkTagUtil.relationIncludedInModel)).forEach(r -> {
                    try {
                        this.start(PROPERTY_NAME);
                        try {
                            this.attr(RELATION_ID_NAME, r.getId().toString());
                            this.attr(INBOUND_NAME, r.isInbound());
                            this.attr(CLOUD_ID_NAME, CloudLinkForgeTagUtil.getOrAddCloudId(this.config, (BIEntity)r.getEndpoint()));
                        }
                        finally {
                            this.end(PROPERTY_NAME);
                        }
                    }
                    catch (IOException e) {
                        log.finest("Unable to encode relation: " + r.getId().toString());
                    }
                });
            }
            finally {
                this.endArray();
            }
            this.startArray(LINKS);
            try {
                Arrays.stream(component.getKnobs()).filter(k -> (k.getLink().getParent().getFlags((Slot)k.getLink().getPropertyInParent()) & 2) == 0 && !CloudLinkTagUtil.entityExcludedFromModel.test(k.getTargetComponent())).forEach(k -> TagUtil.getCloudId((BComponent)k.getTargetComponent()).ifPresent(cid -> {
                    try {
                        this.start(PROPERTY_NAME);
                        try {
                            this.attr(SOURCE_SLOT, k.getSourceSlotName());
                            this.attr(TARGET_ID, cid.encodeToString());
                            this.attr(TARGET_SLOT, k.getTargetSlotName());
                        }
                        finally {
                            this.end(PROPERTY_NAME);
                        }
                    }
                    catch (IOException e) {
                        log.finest("Unable to encode link: " + k.getLink().toString());
                    }
                }));
                Arrays.stream(component.getLinks()).filter(s -> (s.getParent().getFlags((Slot)s.getPropertyInParent()) & 2) == 0 && !CloudLinkTagUtil.entityExcludedFromModel.test(s.getSourceComponent())).forEach(s -> TagUtil.getCloudId((BComponent)s.getSourceComponent()).ifPresent(cid -> {
                    try {
                        this.start(PROPERTY_NAME);
                        try {
                            this.attr(SOURCE_ID, cid.encodeToString());
                            this.attr(SOURCE_SLOT, s.getSourceSlotName());
                            this.attr(TARGET_SLOT, s.getTargetSlotName());
                        }
                        finally {
                            this.end(PROPERTY_NAME);
                        }
                    }
                    catch (IOException e) {
                        log.finest("Unable to encode link: " + s.toString());
                    }
                }));
            }
            finally {
                this.endArray();
            }
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "error serializing component with id " + TagUtil.getCloudId((BComponent)component).orElseGet(() -> BString.make((String)"not set")), log.isLoggable(Level.FINE) ? ex : null);
        }
    }

    protected void encodingComponentStub(BComponent c) throws IOException {
        if (this.componentTypeIncludedInModel.test(c) && CloudLinkTagUtil.entityIncludedInModel.test(c)) {
            this.plugin.attr(CLOUD_ID_NAME, CloudLinkForgeTagUtil.getOrAddCloudId(this.config, (BIEntity)c));
        }
    }

    public void setConfig(BForgeModelChannelConfig config) {
        this.config = config;
    }

    public void setComponentTypePredicate(Predicate<BComponent> componentTypePredicate) {
        this.componentTypeIncludedInModel = componentTypePredicate;
    }

    public void setRelationTypePredicate(Predicate<Relation> relationTypePredicate) {
        this.relationTypeIncludedInModel = relationTypePredicate;
    }
}

